/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-uswid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


const gchar *
fu_uswid_payload_compression_to_string(FuUswidPayloadCompression val)
{
    if (val == FU_USWID_PAYLOAD_COMPRESSION_NONE)
        return "none";
    if (val == FU_USWID_PAYLOAD_COMPRESSION_ZLIB)
        return "zlib";
    if (val == FU_USWID_PAYLOAD_COMPRESSION_LZMA)
        return "lzma";
    return NULL;
}
FuUswidPayloadCompression
fu_uswid_payload_compression_from_string(const gchar *val)
{
    if (g_strcmp0(val, "none") == 0)
        return FU_USWID_PAYLOAD_COMPRESSION_NONE;
    if (g_strcmp0(val, "zlib") == 0)
        return FU_USWID_PAYLOAD_COMPRESSION_ZLIB;
    if (g_strcmp0(val, "lzma") == 0)
        return FU_USWID_PAYLOAD_COMPRESSION_LZMA;
    return FU_USWID_PAYLOAD_COMPRESSION_NONE;
}
/**
 * fu_struct_uswid_ref: (skip):
 **/
FuStructUswid *
fu_struct_uswid_ref(FuStructUswid *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_uswid_unref: (skip):
 **/
void
fu_struct_uswid_unref(FuStructUswid *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructUswid refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_uswid_new_internal: (skip):
 **/
static FuStructUswid *
fu_struct_uswid_new_internal(void)
{
    FuStructUswid *st = g_new0(FuStructUswid, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_uswid_get_magic: (skip):
 **/
static const fwupd_guid_t *
fu_struct_uswid_get_magic(const FuStructUswid *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_uswid_get_hdrver: (skip):
 **/
guint8
fu_struct_uswid_get_hdrver(const FuStructUswid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}
/**
 * fu_struct_uswid_get_hdrsz: (skip):
 **/
guint16
fu_struct_uswid_get_hdrsz(const FuStructUswid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 17, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_get_payloadsz: (skip):
 **/
guint32
fu_struct_uswid_get_payloadsz(const FuStructUswid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 19, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_get_flags: (skip):
 **/
guint8
fu_struct_uswid_get_flags(const FuStructUswid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[23];
}
/**
 * fu_struct_uswid_get_compression: (skip):
 **/
guint8
fu_struct_uswid_get_compression(const FuStructUswid *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[24];
}

/* setters */
/**
 * fu_struct_uswid_set_magic: (skip):
 **/
static void
fu_struct_uswid_set_magic(FuStructUswid *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_uswid_set_hdrver: (skip):
 **/
void
fu_struct_uswid_set_hdrver(FuStructUswid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[16] = value;
}
/**
 * fu_struct_uswid_set_hdrsz: (skip):
 **/
void
fu_struct_uswid_set_hdrsz(FuStructUswid *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 17, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_set_payloadsz: (skip):
 **/
void
fu_struct_uswid_set_payloadsz(FuStructUswid *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 19, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_uswid_set_flags: (skip):
 **/
void
fu_struct_uswid_set_flags(FuStructUswid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[23] = value;
}
/**
 * fu_struct_uswid_set_compression: (skip):
 **/
void
fu_struct_uswid_set_compression(FuStructUswid *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[24] = value;
}
/**
 * fu_struct_uswid_new: (skip):
 **/
FuStructUswid *
fu_struct_uswid_new(void)
{
    FuStructUswid *st = fu_struct_uswid_new_internal();
    st->buf = g_byte_array_sized_new(25);
    fu_byte_array_set_size(st->buf, 25, 0x0);
    fu_struct_uswid_set_magic(st, (fwupd_guid_t *) "\x53\x42\x4f\x4d\xd6\xba\x2e\xac\xa3\xe6\x7a\x52\xaa\xee\x3b\xaf");
    fu_struct_uswid_set_hdrsz(st, 25);
    return st;
}
/**
 * fu_struct_uswid_to_string: (skip):
 **/
static gchar *
fu_struct_uswid_to_string(const FuStructUswid *st)
{
    g_autoptr(GString) str = g_string_new("FuStructUswid:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  hdrver: 0x%x\n",
                           (guint) fu_struct_uswid_get_hdrver(st));
    g_string_append_printf(str, "  hdrsz: 0x%x\n",
                           (guint) fu_struct_uswid_get_hdrsz(st));
    g_string_append_printf(str, "  payloadsz: 0x%x\n",
                           (guint) fu_struct_uswid_get_payloadsz(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_uswid_get_flags(st));
    g_string_append_printf(str, "  compression: 0x%x\n",
                           (guint) fu_struct_uswid_get_compression(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_uswid_validate_internal(FuStructUswid *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (memcmp(fu_struct_uswid_get_magic(st), "\x53\x42\x4f\x4d\xd6\xba\x2e\xac\xa3\xe6\x7a\x52\xaa\xee\x3b\xaf", 16) != 0) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructUswid.magic was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_uswid_validate_stream: (skip):
 **/
gboolean
fu_struct_uswid_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructUswid) st = fu_struct_uswid_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 25, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructUswid failed read of 0x%x: ", (guint) 25);
        return FALSE;
    }
    if (st->buf->len != 25) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructUswid requested 0x%x and got 0x%x",
                    (guint) 25,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_uswid_validate_internal(st, error);
}
static gboolean
fu_struct_uswid_parse_internal(FuStructUswid *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_uswid_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_uswid_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_uswid_parse_stream: (skip):
 **/
FuStructUswid *
fu_struct_uswid_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructUswid) st = fu_struct_uswid_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 25, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructUswid failed read of 0x%x: ", (guint) 25);
        return NULL;
    }
    if (st->buf->len != 25) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructUswid requested 0x%x and got 0x%x",
                    (guint) 25,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_uswid_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
