//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/PRemoteEncoderParent.h"
#include "PlatformEncoderModule.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteMediaData.h"
#include "mozilla/RemoteMediaDataEncoderChild.h"
#include "mozilla/RemoteMediaDataEncoderParent.h"
#include "mozilla/dom/MediaIPCUtils.h"

#include "mozilla/PRemoteMediaManagerParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {


auto PRemoteEncoderParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PRemoteEncoderParent::PRemoteEncoderParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PRemoteEncoderParent);
}

PRemoteEncoderParent::~PRemoteEncoderParent()
{
    MOZ_COUNT_DTOR(PRemoteEncoderParent);
}

auto PRemoteEncoderParent::ActorAlloc() -> void
{
    AddRef();
}

auto PRemoteEncoderParent::ActorDealloc() -> void
{
    Release();
}

auto PRemoteEncoderParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PRemoteEncoderParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PRemoteEncoderParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PRemoteEncoderParent::Manager() const -> PRemoteMediaManagerParent*
{
    return static_cast<PRemoteMediaManagerParent*>(IProtocol::Manager());
}

auto PRemoteEncoderParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PRemoteEncoderParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PRemoteEncoderParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PRemoteEncoderParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PRemoteEncoderParent::OnMessageReceived(const Message& msg__) -> PRemoteEncoderParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_Construct__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_Construct", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteEncoder::Reply_Construct(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ConstructResolver resolver = [resolver__ = std::move(resolver__)](const MediaResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteEncoderParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvConstruct(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_Init__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_Init", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteEncoder::Reply_Init(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitResolver resolver = [resolver__ = std::move(resolver__)](const EncodeInitResultIPDL& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteEncoderParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvInit(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_Encode__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_Encode", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__data = IPC::ReadParam<EncodedInputIPDL>((&(reader__)));
            if (!maybe__data) {
                FatalError("Error deserializing 'EncodedInputIPDL'");
                return MsgValueError;

            }
            auto& data = *maybe__data;
            // Sentinel = 'data'
            if ((!(((&(reader__)))->ReadSentinel(67109275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'EncodedInputIPDL'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteEncoder::Reply_Encode(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            EncodeResolver resolver = [resolver__ = std::move(resolver__)](const EncodeResultIPDL& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteEncoderParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvEncode(std::move(data), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_Reconfigure__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_Reconfigure", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__configurationChanges = IPC::ReadParam<RefPtr<EncoderConfigurationChangeList>>((&(reader__)));
            if (!maybe__configurationChanges) {
                FatalError("Error deserializing 'EncoderConfigurationChangeList'");
                return MsgValueError;

            }
            auto& configurationChanges = *maybe__configurationChanges;
            // Sentinel = 'configurationChanges'
            if ((!(((&(reader__)))->ReadSentinel(1453656114)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'EncoderConfigurationChangeList'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteEncoder::Reply_Reconfigure(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ReconfigureResolver resolver = [resolver__ = std::move(resolver__)](const MediaResult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'error'
                    ((&(writer__)))->WriteSentinel(107741739);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteEncoderParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvReconfigure(configurationChanges, std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_Drain__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_Drain", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteEncoder::Reply_Drain(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            DrainResolver resolver = [resolver__ = std::move(resolver__)](const EncodeResultIPDL& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteEncoderParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvDrain(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_ReleaseTicket__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_ReleaseTicket", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__ticketId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__ticketId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& ticketId = *maybe__ticketId;
            // Sentinel = 'ticketId'
            if ((!(((&(reader__)))->ReadSentinel(248906546)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvReleaseTicket(std::move(ticketId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_Shutdown", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteEncoder::Reply_Shutdown(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            ShutdownResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'unused'
                    ((&(writer__)))->WriteSentinel(155517589);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteEncoderParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvShutdown(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg_SetBitrate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg_SetBitrate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aBitsPerSec = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aBitsPerSec) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aBitsPerSec = *maybe__aBitsPerSec;
            // Sentinel = 'aBitsPerSec'
            if ((!(((&(reader__)))->ReadSentinel(419890230)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PRemoteEncoder::Reply_SetBitrate(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            SetBitrateResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'rv'
                    ((&(writer__)))->WriteSentinel(22806761);

                    if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PRemoteEncoderParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->RecvSetBitrate(std::move(aBitsPerSec), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PRemoteEncoder::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PRemoteEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PRemoteEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PRemoteEncoder::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<RemoteMediaDataEncoderParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PRemoteEncoderParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PRemoteEncoderParent::Result
{
    return MsgNotKnown;
}



} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::PRemoteEncoderParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PRemoteEncoder'
    (aWriter)->WriteSentinel(673121661);
}

auto ParamTraits<::mozilla::PRemoteEncoderParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PRemoteEncoder actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PRemoteEncoder'
    if ((!((aReader)->ReadSentinel(673121661)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PRemoteEncoder actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PRemoteEncoderMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PRemoteEncoder)");

        return {};
    }
    return static_cast<::mozilla::PRemoteEncoderParent*>(actor);
}

} // namespace IPC
