/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.NameHelper;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.jdbc.metadata.TypeMetadata;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetProcedureColumns
extends AbstractMetadataMethod {
    private static final String COLUMNINFO = "COLUMNINFO";
    private static final String COLUMN_PROCEDURE_NAME = "PP.RDB$PROCEDURE_NAME";
    private static final String COLUMN_PARAMETER_NAME = "PP.RDB$PARAMETER_NAME";
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(20).at(0).simple(449, 63, "PROCEDURE_CAT", "COLUMNINFO").addField().at(1).simple(449, 63, "PROCEDURE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "PROCEDURE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNINFO").addField().at(4).simple(500, 0, "COLUMN_TYPE", "COLUMNINFO").addField().at(5).simple(496, 0, "DATA_TYPE", "COLUMNINFO").addField().at(6).simple(448, 31, "TYPE_NAME", "COLUMNINFO").addField().at(7).simple(496, 0, "PRECISION", "COLUMNINFO").addField().at(8).simple(496, 0, "LENGTH", "COLUMNINFO").addField().at(9).simple(500, 0, "SCALE", "COLUMNINFO").addField().at(10).simple(500, 0, "RADIX", "COLUMNINFO").addField().at(11).simple(500, 0, "NULLABLE", "COLUMNINFO").addField().at(12).simple(448, Integer.MAX_VALUE, "REMARKS", "COLUMNINFO").addField().at(13).simple(448, 31, "COLUMN_DEF", "COLUMNINFO").addField().at(14).simple(496, 0, "SQL_DATA_TYPE", "COLUMNINFO").addField().at(15).simple(496, 0, "SQL_DATETIME_SUB", "COLUMNINFO").addField().at(16).simple(496, 0, "CHAR_OCTET_LENGTH", "COLUMNINFO").addField().at(17).simple(496, 0, "ORDINAL_POSITION", "COLUMNINFO").addField().at(18).simple(448, 3, "IS_NULLABLE", "COLUMNINFO").addField().at(19).simple(448, 63, "SPECIFIC_NAME", "COLUMNINFO").addField().toRowDescriptor();

    private GetProcedureColumns(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public final ResultSet getProcedureColumns(String catalog, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if ("".equals(procedureNamePattern) || "".equals(columnNamePattern)) {
            return this.createEmpty();
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetProcedureColumnsQuery(catalog, procedureNamePattern, columnNamePattern);
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    final RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        short columnType = rs.getShort("COLUMN_TYPE");
        short nullFlag = rs.getShort("NULL_FLAG");
        TypeMetadata typeMetadata = TypeMetadata.builder(this.mediator.getFirebirdSupportInfo()).fromCurrentRow(rs).build();
        String catalog = rs.getString("PROCEDURE_CAT");
        String procedureName = rs.getString("PROCEDURE_NAME");
        return valueBuilder.at(0).setString(catalog).at(1).set(null).at(2).setString(procedureName).at(3).setString(rs.getString("COLUMN_NAME")).at(4).setShort(columnType == 0 ? 1 : 4).at(5).setInt(typeMetadata.getJdbcType()).at(6).setString(typeMetadata.getSqlTypeName()).at(7).setInt(typeMetadata.getColumnSize()).at(8).setInt(typeMetadata.getLength()).at(9).setShort(typeMetadata.getScale()).at(10).setShort(typeMetadata.getRadix()).at(11).setShort(nullFlag == 1 ? 0 : 1).at(12).setString(rs.getString("REMARKS")).at(13).setString(GetProcedureColumns.extractDefault(rs.getString("COLUMN_DEF"))).at(14).set(null).at(15).set(null).at(16).setInt(typeMetadata.getCharOctetLength()).at(17).setInt(rs.getInt("PARAMETER_NUMBER")).at(18).setString(nullFlag == 1 ? "NO" : "YES").at(19).setString(NameHelper.toSpecificName(catalog, procedureName)).toRowValue(false);
    }

    abstract DbMetadataMediator.MetadataQuery createGetProcedureColumnsQuery(String var1, String var2, String var3);

    public static GetProcedureColumns create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3)) {
            if (mediator.isUseCatalogAsPackage()) {
                return FB3CatalogAsPackage.createInstance(mediator);
            }
            return FB3.createInstance(mediator);
        }
        return FB2_5.createInstance(mediator);
    }

    private static final class FB3CatalogAsPackage
    extends GetProcedureColumns {
        private static final String GET_PROCEDURE_COLUMNS_FRAGMENT_3_W_PKG = "select\n  coalesce(trim(trailing from PP.RDB$PACKAGE_NAME), '') as PROCEDURE_CAT,\n  trim(trailing from PP.RDB$PROCEDURE_NAME) as PROCEDURE_NAME,\n  trim(trailing from PP.RDB$PARAMETER_NAME) as COLUMN_NAME,\n  PP.RDB$PARAMETER_TYPE as COLUMN_TYPE,\n  F.RDB$FIELD_TYPE as FIELD_TYPE,\n  F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  F.RDB$FIELD_SCALE as FIELD_SCALE,\n  F.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  F.RDB$CHARACTER_LENGTH as CHAR_LEN,\n  F.RDB$CHARACTER_SET_ID as CHARSET_ID,\n  F.RDB$NULL_FLAG as NULL_FLAG,\n  PP.RDB$DESCRIPTION as REMARKS,\n  PP.RDB$PARAMETER_NUMBER + 1 as PARAMETER_NUMBER,\n  coalesce(PP.RDB$DEFAULT_SOURCE, F.RDB$DEFAULT_SOURCE) as COLUMN_DEF\nfrom RDB$PROCEDURE_PARAMETERS PP inner join RDB$FIELDS F on PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME";
        private static final String GET_PROCEDURE_COLUMNS_END_3_W_PKG = "\norder by PP.RDB$PACKAGE_NAME nulls first, PP.RDB$PROCEDURE_NAME, PP.RDB$PARAMETER_TYPE desc, PP.RDB$PARAMETER_NUMBER";
        private static final String COLUMN_PACKAGE_NAME = "PP.RDB$PACKAGE_NAME";

        private FB3CatalogAsPackage(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedureColumns createInstance(DbMetadataMediator mediator) {
            return new FB3CatalogAsPackage(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProcedureColumnsQuery(String catalog, String procedureNamePattern, String columnNamePattern) {
            ArrayList<Clause> clauses = new ArrayList<Clause>(3);
            if (catalog != null) {
                if (catalog.isEmpty()) {
                    clauses.add(Clause.isNullClause(COLUMN_PACKAGE_NAME));
                } else {
                    clauses.add(Clause.equalsClause(COLUMN_PACKAGE_NAME, catalog));
                }
            }
            clauses.add(new Clause(GetProcedureColumns.COLUMN_PROCEDURE_NAME, procedureNamePattern));
            clauses.add(new Clause(GetProcedureColumns.COLUMN_PARAMETER_NAME, columnNamePattern));
            String sql = GET_PROCEDURE_COLUMNS_FRAGMENT_3_W_PKG + (String)(Clause.anyCondition(clauses) ? "\nwhere " + Clause.conjunction(clauses) : "") + GET_PROCEDURE_COLUMNS_END_3_W_PKG;
            return new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(clauses));
        }
    }

    private static class FB3
    extends GetProcedureColumns {
        private static final String GET_PROCEDURE_COLUMNS_FRAGMENT_3 = "select\n  null as PROCEDURE_CAT,\n  trim(trailing from PP.RDB$PROCEDURE_NAME) as PROCEDURE_NAME,\n  trim(trailing from PP.RDB$PARAMETER_NAME) as COLUMN_NAME,\n  PP.RDB$PARAMETER_TYPE as COLUMN_TYPE,\n  F.RDB$FIELD_TYPE as FIELD_TYPE,\n  F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  F.RDB$FIELD_SCALE as FIELD_SCALE,\n  F.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  F.RDB$CHARACTER_LENGTH as CHAR_LEN,\n  F.RDB$CHARACTER_SET_ID as CHARSET_ID,\n  F.RDB$NULL_FLAG as NULL_FLAG,\n  PP.RDB$DESCRIPTION as REMARKS,\n  PP.RDB$PARAMETER_NUMBER + 1 as PARAMETER_NUMBER,\n  coalesce(PP.RDB$DEFAULT_SOURCE, F.RDB$DEFAULT_SOURCE) as COLUMN_DEF\nfrom RDB$PROCEDURE_PARAMETERS PP inner join RDB$FIELDS F on PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME\nwhere PP.RDB$PACKAGE_NAME is null";
        private static final String GET_PROCEDURE_COLUMNS_END_3 = "\norder by PP.RDB$PACKAGE_NAME, PP.RDB$PROCEDURE_NAME, PP.RDB$PARAMETER_TYPE desc, PP.RDB$PARAMETER_NUMBER";

        private FB3(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedureColumns createInstance(DbMetadataMediator mediator) {
            return new FB3(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProcedureColumnsQuery(String catalog, String procedureNamePattern, String columnNamePattern) {
            Clause procedureClause = new Clause(GetProcedureColumns.COLUMN_PROCEDURE_NAME, procedureNamePattern);
            Clause columnClause = new Clause(GetProcedureColumns.COLUMN_PARAMETER_NAME, columnNamePattern);
            String query = GET_PROCEDURE_COLUMNS_FRAGMENT_3 + procedureClause.getCondition("\nand ", "") + columnClause.getCondition("\nand ", "") + GET_PROCEDURE_COLUMNS_END_3;
            return new DbMetadataMediator.MetadataQuery(query, Clause.parameters(procedureClause, columnClause));
        }
    }

    private static class FB2_5
    extends GetProcedureColumns {
        private static final String GET_PROCEDURE_COLUMNS_FRAGMENT_2_5 = "select\n  null as PROCEDURE_CAT,\n  PP.RDB$PROCEDURE_NAME as PROCEDURE_NAME,\n  PP.RDB$PARAMETER_NAME as COLUMN_NAME,\n  PP.RDB$PARAMETER_TYPE as COLUMN_TYPE,\n  F.RDB$FIELD_TYPE as FIELD_TYPE,\n  F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,\n  F.RDB$FIELD_PRECISION as FIELD_PRECISION,\n  F.RDB$FIELD_SCALE as FIELD_SCALE,\n  F.RDB$FIELD_LENGTH as FIELD_LENGTH,\n  F.RDB$CHARACTER_LENGTH as CHAR_LEN,\n  F.RDB$CHARACTER_SET_ID as CHARSET_ID,\n  F.RDB$NULL_FLAG as NULL_FLAG,\n  PP.RDB$DESCRIPTION as REMARKS,\n  PP.RDB$PARAMETER_NUMBER + 1 as PARAMETER_NUMBER,\n  coalesce(PP.RDB$DEFAULT_SOURCE, F.RDB$DEFAULT_SOURCE) as COLUMN_DEF\nfrom RDB$PROCEDURE_PARAMETERS PP inner join RDB$FIELDS F on PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME";
        private static final String GET_PROCEDURE_COLUMNS_END_2_5 = "\norder by PP.RDB$PROCEDURE_NAME, PP.RDB$PARAMETER_TYPE desc, PP.RDB$PARAMETER_NUMBER";

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedureColumns createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProcedureColumnsQuery(String catalog, String procedureNamePattern, String columnNamePattern) {
            Clause procedureClause = new Clause(GetProcedureColumns.COLUMN_PROCEDURE_NAME, procedureNamePattern);
            Clause columnClause = new Clause(GetProcedureColumns.COLUMN_PARAMETER_NAME, columnNamePattern);
            String query = GET_PROCEDURE_COLUMNS_FRAGMENT_2_5 + (String)(Clause.anyCondition(procedureClause, columnClause) ? "\nwhere " + procedureClause.getCondition(columnClause.hasCondition()) + columnClause.getCondition(false) : "") + GET_PROCEDURE_COLUMNS_END_2_5;
            return new DbMetadataMediator.MetadataQuery(query, Clause.parameters(procedureClause, columnClause));
        }
    }
}

