/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.gds.ng.DatatypeCoder;

public final class EncodingSpecificDatatypeCoder
implements DatatypeCoder {
    private final DatatypeCoder parentCoder;
    private final EncodingDefinition encodingDefinition;
    private final Encoding encoding;

    EncodingSpecificDatatypeCoder(DatatypeCoder parentCoder, EncodingDefinition encodingDefinition) {
        this.parentCoder = Objects.requireNonNull(parentCoder, "parentCoder");
        this.encodingDefinition = Objects.requireNonNull(encodingDefinition, "encodingDefinition");
        this.encoding = Objects.requireNonNull(encodingDefinition.getEncoding(), "encodingDefinition.encoding");
    }

    @Override
    public byte[] encodeString(String val) {
        return val != null ? this.encoding.encodeToCharset(val) : null;
    }

    @Override
    public Writer createWriter(OutputStream out) {
        return this.encoding.createWriter(out);
    }

    @Override
    public String decodeString(byte[] buf) {
        return buf != null ? this.encoding.decodeFromCharset(buf) : null;
    }

    @Override
    public Reader createReader(InputStream in) {
        return this.encoding.createReader(in);
    }

    @Override
    public DatatypeCoder forEncodingDefinition(EncodingDefinition encodingDefinition) {
        if (this.encodingDefinition.equals(encodingDefinition)) {
            return this;
        }
        return this.parentCoder.forEncodingDefinition(encodingDefinition);
    }

    @Override
    public EncodingDefinition getEncodingDefinition() {
        return this.encodingDefinition;
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public DatatypeCoder unwrap() {
        return this.parentCoder;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DatatypeCoder)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EncodingSpecificDatatypeCoder) {
            EncodingSpecificDatatypeCoder other = (EncodingSpecificDatatypeCoder)o;
            return this.encodingDefinition.equals(other.encodingDefinition) && this.parentCoder.getClass() == other.parentCoder.getClass();
        }
        DatatypeCoder other = (DatatypeCoder)o;
        return this.encodingDefinition.equals(other.getEncodingDefinition()) && this.parentCoder.getClass() == other.getClass();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parentCoder.getClass(), this.encodingDefinition);
    }

    @Override
    public int sizeOfShort() {
        return this.parentCoder.sizeOfShort();
    }

    @Override
    public byte[] encodeShort(short val) {
        return this.parentCoder.encodeShort(val);
    }

    @Override
    public byte[] encodeShort(int val) {
        return this.parentCoder.encodeShort(val);
    }

    @Override
    public void encodeShort(int val, byte[] buf, int off) {
        this.parentCoder.encodeShort(val, buf, off);
    }

    @Override
    public short decodeShort(byte[] buf) {
        return this.parentCoder.decodeShort(buf);
    }

    @Override
    public short decodeShort(byte[] buf, int off) {
        return this.parentCoder.decodeShort(buf, off);
    }

    @Override
    public byte[] encodeInt(int val) {
        return this.parentCoder.encodeInt(val);
    }

    @Override
    public void encodeInt(int val, byte[] buf, int off) {
        this.parentCoder.encodeInt(val, buf, off);
    }

    @Override
    public int decodeInt(byte[] buf) {
        return this.parentCoder.decodeInt(buf);
    }

    @Override
    public int decodeInt(byte[] buf, int off) {
        return this.parentCoder.decodeInt(buf, off);
    }

    @Override
    public byte[] encodeLong(long val) {
        return this.parentCoder.encodeLong(val);
    }

    @Override
    public long decodeLong(byte[] buf) {
        return this.parentCoder.decodeLong(buf);
    }

    @Override
    public byte[] encodeFloat(float val) {
        return this.parentCoder.encodeFloat(val);
    }

    @Override
    public float decodeFloat(byte[] buf) {
        return this.parentCoder.decodeFloat(buf);
    }

    @Override
    public byte[] encodeDouble(double val) {
        return this.parentCoder.encodeDouble(val);
    }

    @Override
    public double decodeDouble(byte[] buf) {
        return this.parentCoder.decodeDouble(buf);
    }

    @Override
    public boolean decodeBoolean(byte[] buf) {
        return this.parentCoder.decodeBoolean(buf);
    }

    @Override
    public byte[] encodeBoolean(boolean val) {
        return this.parentCoder.encodeBoolean(val);
    }

    @Override
    public LocalTime decodeLocalTime(byte[] buf) {
        return this.parentCoder.decodeLocalTime(buf);
    }

    @Override
    public LocalTime decodeLocalTime(byte[] buf, int off) {
        return this.parentCoder.decodeLocalTime(buf, off);
    }

    @Override
    public byte[] encodeLocalTime(LocalTime val) {
        return this.parentCoder.encodeLocalTime(val);
    }

    @Override
    public void encodeLocalTime(LocalTime val, byte[] buf, int off) {
        this.parentCoder.encodeLocalTime(val, buf, off);
    }

    @Override
    public LocalDate decodeLocalDate(byte[] buf) {
        return this.parentCoder.decodeLocalDate(buf);
    }

    @Override
    public LocalDate decodeLocalDate(byte[] buf, int off) {
        return this.parentCoder.decodeLocalDate(buf, off);
    }

    @Override
    public byte[] encodeLocalDate(LocalDate val) {
        return this.parentCoder.encodeLocalDate(val);
    }

    @Override
    public void encodeLocalDate(LocalDate val, byte[] buf, int off) {
        this.parentCoder.encodeLocalDate(val, buf, off);
    }

    @Override
    public LocalDateTime decodeLocalDateTime(byte[] buf) {
        return this.parentCoder.decodeLocalDateTime(buf);
    }

    @Override
    public LocalDateTime decodeLocalDateTime(byte[] buf, int off) {
        return this.parentCoder.decodeLocalDateTime(buf, off);
    }

    @Override
    public byte[] encodeLocalDateTime(LocalDateTime val) {
        return this.parentCoder.encodeLocalDateTime(val);
    }

    @Override
    public void encodeLocalDateTime(LocalDateTime val, byte[] buf, int off) {
        this.parentCoder.encodeLocalDateTime(val, buf, off);
    }

    @Override
    public Decimal64 decodeDecimal64(byte[] buf) {
        return this.parentCoder.decodeDecimal64(buf);
    }

    @Override
    public byte[] encodeDecimal64(Decimal64 val) {
        return this.parentCoder.encodeDecimal64(val);
    }

    @Override
    public Decimal128 decodeDecimal128(byte[] buf) {
        return this.parentCoder.decodeDecimal128(buf);
    }

    @Override
    public byte[] encodeDecimal128(Decimal128 val) {
        return this.parentCoder.encodeDecimal128(val);
    }

    @Override
    public BigInteger decodeInt128(byte[] buf) {
        return this.parentCoder.decodeInt128(buf);
    }

    @Override
    public byte[] encodeInt128(BigInteger val) {
        return this.parentCoder.encodeInt128(val);
    }

    @Override
    public IEncodingFactory getEncodingFactory() {
        return this.parentCoder.getEncodingFactory();
    }
}

