/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.sqlserver;

import java.util.function.Consumer;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.server.sqlserver.SqlServerConnectionInitializer;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptionsBuilder;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.DatabaseServerType;

public final class SqlServerDatabaseConnector
extends DatabaseConnector {
    private static DatabaseConnectorOptions databaseConnectorOptions() {
        DatabaseServerType dbServerType = new DatabaseServerType("sqlserver", "Microsoft SQL Server");
        DatabaseConnectionSourceBuilder connectionSourceBuilder = DatabaseConnectionSourceBuilder.builder((String)"jdbc:sqlserver://${host}:${port};databaseName=${database}").withDefaultPort(1433).withDefaultUrlx("applicationName", "SchemaCrawler").withDefaultUrlx("encrypt", false).withConnectionInitializer((Consumer)new SqlServerConnectionInitializer());
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand((DatabaseServerType)dbServerType);
        pluginCommand.addOption("server", String.class, new String[]{"--server=mysql", "Loads SchemaCrawler plug-in for Microsoft SQL Server", "If you are using instance names, named pipes, or Windows authentication, you will need to provide a database connection URL on the SchemaCrawler command-line", "See https://www.schemacrawler.com/database-support.html"}).addOption("host", String.class, new String[]{"Host name", "Optional, defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number", "Optional, defaults to 1433"}).addOption("database", String.class, new String[]{"Database name", "Be sure to also restrict your schemas to this database, by using an additional option,", "--schemas=<database>.dbo"});
        return (DatabaseConnectorOptions)DatabaseConnectorOptionsBuilder.builder((DatabaseServerType)dbServerType).withHelpCommand(pluginCommand).withUrlStartsWith("jdbc:sqlserver:").withInformationSchemaViewsFromResourceFolder("/sqlserver.information_schema").withDatabaseConnectionSourceBuilder(() -> connectionSourceBuilder).withSchemaRetrievalOptionsBuilder((schemaRetrievalOptionsBuilder, connection) -> schemaRetrievalOptionsBuilder.with(SchemaInfoMetadataRetrievalStrategy.tableColumnsRetrievalStrategy, MetadataRetrievalStrategy.metadata_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.primaryKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.foreignKeysRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.indexesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.viewInformationRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.viewTableUsageRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.triggersRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.tableConstraintsRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.tableConstraintColumnsRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.tableCheckConstraintsRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.tableAdditionalAttributesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.tableColumnAdditionalAttributesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.routinesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.routineReferencesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.proceduresRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.procedureParametersRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.functionsRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas).with(SchemaInfoMetadataRetrievalStrategy.functionParametersRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_over_schemas)).withLimitOptionsBuilder(limitOptionsBuilder -> limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionRule(".*\\.dbo", "model\\..*|master\\..*|msdb\\..*|tempdb\\..*|rdsadmin\\..*"))).build();
    }

    public SqlServerDatabaseConnector() {
        super(SqlServerDatabaseConnector.databaseConnectorOptions());
    }
}

