/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.NativeTokenHolder;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.CommonCredentialsProvider;
import com.amazon.redshift.plugin.InternalPluginException;
import com.amazon.redshift.plugin.httpserver.RequestHandler;
import com.amazon.redshift.plugin.httpserver.Server;
import com.amazon.redshift.plugin.utils.RandomStateUtil;
import com.amazon.redshift.plugin.utils.ResponseUtils;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssooidc.SsoOidcClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcClientBuilder;
import software.amazon.awssdk.services.ssooidc.model.AccessDeniedException;
import software.amazon.awssdk.services.ssooidc.model.AuthorizationPendingException;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse;
import software.amazon.awssdk.services.ssooidc.model.SlowDownException;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcException;

public class BrowserIdcAuthPlugin
extends CommonCredentialsProvider {
    public static final String KEY_IDC_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    public static final String KEY_ISSUER_URL = "issuer_url";
    public static final String KEY_IDC_REGION = "idc_region";
    private static final String KEY_IDC_CLIENT_DISPLAY_NAME = "idc_client_display_name";
    public static final String OAUTH_CSRF_STATE_PARAMETER_NAME = "state";
    public static final String OAUTH_REDIRECT_PARAMETER_NAME = "redirect_uri";
    public static final String OAUTH_CLIENT_ID_PARAMETER_NAME = "client_id";
    public static final String OAUTH_RESPONSE_TYPE_PARAMETER_NAME = "response_type";
    public static final String OAUTH_GRANT_TYPE_PARAMETER_NAME = "grant_type";
    public static final String OAUTH_SCOPE_PARAMETER_NAME = "scopes";
    public static final String OAUTH_CODE_CHALLENGE_PARAMETER_NAME = "code_challenge";
    public static final String OAUTH_CHALLENGE_METHOD_PARAMETER_NAME = "code_challenge_method";
    public final int CREATE_TOKEN_POLLING_INTERVAL = 1;
    public final int DEFAULT_IDC_TOKEN_EXPIRY_IN_SEC = 900;
    public final int CODE_VERIFIER_BYTE_LENGTH = 60;
    public final long MILLISECOND_MULTIPLIER = 1000L;
    protected String m_issuer_url;
    protected String m_idc_region;
    protected String m_redirect_uri;
    protected SsoOidcClient m_sdk_client;
    private static final String AUTH_CODE_PARAMETER_NAME = "code";
    private static final String CURRENT_INTERACTION_PROTOCOL = "https";
    private static final String OIDC_SUBDOMAIN = "oidc";
    private static final String AMAZON_COM_DOMAIN = "amazonaws.com";
    private static final String AMAZON_CHINA_DOMAIN = "amazonaws.com.cn";
    private static final Pattern REGION_PATTERN = Pattern.compile("^[a-z]{2,3}(-[a-z]+)+-[0-9]+$");
    private static final String REDSHIFT_IDC_CONNECT_SCOPE = "redshift:connect";
    private static final String AUTH_CODE_GRANT_TYPE = "authorization_code";
    private static final String M_CLIENT_TYPE = "public";
    private static final String M_REDIRECT_URI = "http://127.0.0.1";
    private static final String AUTHORIZE_ENDPOINT = "/authorize";
    private static final String CHALLENGE_METHOD = "S256";
    private static final String SHA256_METHOD = "SHA-256";
    private int m_idc_response_timeout = 120;
    private int m_listen_port = 7890;
    private String m_idcClientDisplayName = RedshiftProperty.IDC_CLIENT_DISPLAY_NAME.getDefaultValue();
    private static final Map<String, RegisterClientResponse> m_register_client_cache = new HashMap<String, RegisterClientResponse>();

    @Override
    protected NativeTokenHolder getAuthToken() throws IOException {
        return this.getIdcToken();
    }

    protected NativeTokenHolder getIdcToken() throws IOException {
        try {
            this.checkRequiredParameters();
            this.m_sdk_client = (SsoOidcClient)((SsoOidcClientBuilder)SsoOidcClient.builder().region(Region.of((String)this.m_idc_region))).build();
            this.m_redirect_uri = "http://127.0.0.1:" + this.m_listen_port;
            RegisterClientResponse registerClientResponse = this.getRegisterClientResponse();
            String codeVerifier = this.generateCodeVerifier();
            String codeChallenge = this.generateCodeChallenge(codeVerifier);
            String authCode = this.fetchAuthorizationCode(codeChallenge, registerClientResponse);
            CreateTokenResponse createTokenResponse = this.fetchTokenResponse(registerClientResponse, authCode, codeVerifier);
            return this.processCreateTokenResponse(createTokenResponse);
        }
        catch (InternalPluginException | URISyntaxException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "InternalPluginException in getIdcToken", new Object[0]);
            }
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private void checkRequiredParameters() throws InternalPluginException {
        if (Utils.isNullOrEmpty(this.m_issuer_url)) {
            this.m_log.logDebug("IdC authentication failed: issuer_url needs to be provided in connection params", new Object[0]);
            throw new InternalPluginException("IdC authentication failed: The issuer URL must be included in the connection parameters.");
        }
        if (Utils.isNullOrEmpty(this.m_idc_region)) {
            this.m_log.logDebug("IdC authentication failed: idc_region needs to be provided in connection params", new Object[0]);
            throw new InternalPluginException("IdC authentication failed: The IdC region must be included in the connection parameters.");
        }
    }

    @Override
    public void addParameter(String key, String value) {
        switch (key) {
            case "issuer_url": {
                this.m_issuer_url = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting issuer_url: {0}", this.m_issuer_url);
                break;
            }
            case "idc_region": {
                this.m_idc_region = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting idc_region: {0}", this.m_idc_region);
                break;
            }
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(value);
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting listen_port: {0}", this.m_listen_port);
                break;
            }
            case "idc_client_display_name": {
                if (!Utils.isNullOrEmpty(value)) {
                    this.m_idcClientDisplayName = value;
                }
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting idc_client_display_name: {0}", this.m_idcClientDisplayName);
                break;
            }
            case "idp_response_timeout": {
                if (Utils.isNullOrEmpty(value)) break;
                int timeout = Integer.parseInt(value);
                if (timeout > 10) {
                    this.m_idc_response_timeout = timeout;
                    if (!RedshiftLogger.isEnable()) break;
                    this.m_log.logDebug("Setting idc_response_timeout={0}", this.m_idc_response_timeout);
                    break;
                }
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("Setting default idc_response_timeout={0}; provided value={1}", this.m_idc_response_timeout, timeout);
                break;
            }
            default: {
                super.addParameter(key, value);
            }
        }
    }

    protected RegisterClientResponse getRegisterClientResponse() throws IOException {
        String registerClientCacheKey = this.m_issuer_url + ":" + this.m_idc_region + ":" + this.m_listen_port;
        RegisterClientResponse cachedRegisterClientResponse = m_register_client_cache.get(registerClientCacheKey);
        if (this.isCachedRegisterClientResponseValid(cachedRegisterClientResponse)) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Using cached register client response", new Object[0]);
                this.m_log.logDebug("Cached register client secret expiry is {0}", cachedRegisterClientResponse.clientSecretExpiresAt());
            }
            return cachedRegisterClientResponse;
        }
        RegisterClientRequest registerClientRequest = (RegisterClientRequest)RegisterClientRequest.builder().clientName(this.m_idcClientDisplayName).clientType(M_CLIENT_TYPE).scopes(new String[]{REDSHIFT_IDC_CONNECT_SCOPE}).issuerUrl(this.m_issuer_url).redirectUris(new String[]{this.m_redirect_uri}).grantTypes(new String[]{AUTH_CODE_GRANT_TYPE}).build();
        RegisterClientResponse registerClientResponse = null;
        try {
            registerClientResponse = this.m_sdk_client.registerClient(registerClientRequest);
            if (RedshiftLogger.isEnable() && registerClientResponse.sdkHttpResponse() != null) {
                this.m_log.logDebug("registerClient response code: {0}", registerClientResponse.sdkHttpResponse().statusCode());
            }
        }
        catch (SsoOidcException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Error: Unexpected server error while registering client;", new Object[0]);
            }
            throw new IOException("IdC authentication failed : An error occurred during the request.", ex);
        }
        catch (Exception ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, ex, "Error: Unexpected register client error;", new Object[0]);
            }
            throw new IOException("IdC registerClient failed : There was an error during the request.", ex);
        }
        m_register_client_cache.put(registerClientCacheKey, registerClientResponse);
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("Cached register client secret expiry is {0}", registerClientResponse.clientSecretExpiresAt());
        }
        return registerClientResponse;
    }

    protected String generateCodeVerifier() {
        byte[] randomBytes = new byte[60];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(randomBytes);
        String codeVerifier = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        return codeVerifier;
    }

    protected String generateCodeChallenge(String verifier) {
        byte[] sha256Hash = this.sha256(verifier.getBytes(StandardCharsets.US_ASCII));
        String codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(sha256Hash);
        return codeChallenge;
    }

    protected String fetchAuthorizationCode(String codeChallenge, RegisterClientResponse registerClientResponse) throws IOException, URISyntaxException {
        final String state = RandomStateUtil.generateRandomState();
        RequestHandler requestHandler = new RequestHandler(new Function<List<NameValuePair>, Object>(){

            @Override
            public Object apply(List<NameValuePair> nameValuePairs) {
                String incomingState = ResponseUtils.findParameter(BrowserIdcAuthPlugin.OAUTH_CSRF_STATE_PARAMETER_NAME, nameValuePairs);
                if (!state.equals(incomingState)) {
                    String state_error_message = "Incoming state " + incomingState + " does not match the outgoing state " + state;
                    BrowserIdcAuthPlugin.this.m_log.log(LogLevel.DEBUG, state_error_message, new Object[0]);
                    return new InternalPluginException(state_error_message);
                }
                String code = ResponseUtils.findParameter(BrowserIdcAuthPlugin.AUTH_CODE_PARAMETER_NAME, nameValuePairs);
                if (Utils.isNullOrEmpty(code)) {
                    String code_error_message = "No valid code found";
                    BrowserIdcAuthPlugin.this.m_log.log(LogLevel.DEBUG, code_error_message, new Object[0]);
                    return new InternalPluginException(code_error_message);
                }
                return code;
            }
        });
        Server server = new Server(this.m_listen_port, requestHandler, Duration.ofSeconds(this.m_idc_response_timeout), this.m_log);
        try {
            server.listen();
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.DEBUG, String.format("Listening for connection on port %d", this.m_listen_port), new Object[0]);
            }
            this.openBrowser(state, codeChallenge, registerClientResponse);
            server.waitForResult();
        }
        catch (IOException | URISyntaxException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(ex);
            }
            server.stop();
            throw ex;
        }
        Object result = requestHandler.getResult();
        if (result instanceof InternalPluginException) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Error occurred while fetching authorization code: {0}", result);
            }
            throw (InternalPluginException)result;
        }
        if (result instanceof String) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.DEBUG, "Got authorization code of length={0}", ((String)result).length());
            }
            return (String)result;
        }
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("result: {0}", result);
        }
        throw new InternalPluginException("Error fetching authentication code from browser. Failed to login during timeout.");
    }

    protected CreateTokenResponse fetchTokenResponse(RegisterClientResponse registerClientResponse, String authCode, String codeVerifier) throws IOException {
        long pollingEndTime = System.currentTimeMillis() + (long)this.m_idc_response_timeout * 1000L;
        int pollingIntervalInSec = 1;
        while (System.currentTimeMillis() < pollingEndTime) {
            try {
                CreateTokenResponse createTokenResponse = this.getCreateTokenResponse(registerClientResponse.clientId(), registerClientResponse.clientSecret(), authCode, AUTH_CODE_GRANT_TYPE, codeVerifier, this.m_redirect_uri);
                if (RedshiftLogger.isEnable() && registerClientResponse.sdkHttpResponse() != null) {
                    this.m_log.logDebug("createToken response code: {0}", createTokenResponse.sdkHttpResponse().statusCode());
                }
                if (createTokenResponse != null && createTokenResponse.accessToken() != null) {
                    return createTokenResponse;
                }
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logError("Failed to fetch an IdC access token", new Object[0]);
                }
                throw new IOException("IdC authentication failed : The credential token couldn't be fetched.");
            }
            catch (AuthorizationPendingException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logDebug("Browser authorization pending from user", new Object[0]);
                }
            }
            catch (SlowDownException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Too frequent createToken requests made by client;", new Object[0]);
                }
                throw new IOException("IdC authentication failed : Requests to the IdC service are too frequent.", ex);
            }
            catch (AccessDeniedException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Access denied, please ensure app assignment is done for the user;", new Object[0]);
                }
                throw new IOException("IdC authentication failed : You don't have sufficient permission to perform the action. Please ensure app assignment is done for the user.", ex);
            }
            catch (SsoOidcException ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Server error in creating token;", new Object[0]);
                }
                throw new IOException("IdC authentication failed : An error occurred during the request.", ex);
            }
            catch (Exception ex) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.ERROR, ex, "Error: Unexpected error in create token;", new Object[0]);
                }
                throw new IOException("IdC createToken failed : There was an error during the request.", ex);
            }
            try {
                Thread.sleep((long)pollingIntervalInSec * 1000L);
            }
            catch (InterruptedException ex) {
                if (!RedshiftLogger.isEnable()) continue;
                this.m_log.log(LogLevel.ERROR, ex, "Thread interrupted during sleep", new Object[0]);
            }
        }
        if (RedshiftLogger.isEnable()) {
            this.m_log.logError("Error: Request timed out while waiting for user authentication in the browser", new Object[0]);
        }
        throw new IOException("IdC authentication failed : The request timed out. Authentication wasn't completed.");
    }

    protected CreateTokenResponse getCreateTokenResponse(String clientId, String clientSecret, String authCode, String grantType, String codeVerifier, String redirectUri) {
        CreateTokenRequest createTokenRequest = (CreateTokenRequest)CreateTokenRequest.builder().clientId(clientId).clientSecret(clientSecret).code(authCode).grantType(grantType).codeVerifier(codeVerifier).redirectUri(redirectUri).build();
        return this.m_sdk_client.createToken(createTokenRequest);
    }

    protected NativeTokenHolder processCreateTokenResponse(CreateTokenResponse createTokenResponse) throws IOException {
        String idcToken = createTokenResponse.accessToken();
        if (Utils.isNullOrEmpty(idcToken)) {
            throw new InternalPluginException("Returned access token is null or empty.");
        }
        int expiresInSecs = 900;
        if (createTokenResponse.expiresIn() != null && createTokenResponse.expiresIn() > 0) {
            expiresInSecs = createTokenResponse.expiresIn();
        }
        Date expiration = new Date(System.currentTimeMillis() + (long)expiresInSecs * 1000L);
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("Access token expires at {0}", expiration);
        }
        return NativeTokenHolder.newInstance(idcToken, expiration);
    }

    protected void openBrowser(String state, String codeChallenge, RegisterClientResponse registerClientResponse) throws URISyntaxException, IOException {
        String idc_host = this.buildOidcHostUrl(this.m_idc_region);
        URIBuilder builder = new URIBuilder().setScheme(CURRENT_INTERACTION_PROTOCOL).setHost(idc_host).setPath(AUTHORIZE_ENDPOINT).addParameter(OAUTH_RESPONSE_TYPE_PARAMETER_NAME, AUTH_CODE_PARAMETER_NAME).addParameter(OAUTH_CLIENT_ID_PARAMETER_NAME, registerClientResponse.clientId()).addParameter(OAUTH_REDIRECT_PARAMETER_NAME, this.m_redirect_uri).addParameter(OAUTH_SCOPE_PARAMETER_NAME, REDSHIFT_IDC_CONNECT_SCOPE).addParameter(OAUTH_CSRF_STATE_PARAMETER_NAME, state).addParameter(OAUTH_CODE_CHALLENGE_PARAMETER_NAME, codeChallenge).addParameter(OAUTH_CHALLENGE_METHOD_PARAMETER_NAME, CHALLENGE_METHOD);
        URI authorizeRequestUrl = builder.build();
        this.validateURL(authorizeRequestUrl.toString());
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(authorizeRequestUrl);
        } else {
            this.m_log.log(LogLevel.ERROR, "Unable to open the browser. Desktop environment is not supported", new Object[0]);
        }
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("Authorization code request URI: \n%s", authorizeRequestUrl.toString()), new Object[0]);
        }
    }

    private String buildOidcHostUrl(String idc_region) {
        if (idc_region == null) {
            throw new IllegalArgumentException("Region cannot be null");
        }
        String normalizedRegion = idc_region.trim().toLowerCase();
        if (normalizedRegion.isEmpty()) {
            throw new IllegalArgumentException("Region cannot be empty");
        }
        if (!REGION_PATTERN.matcher(normalizedRegion).matches()) {
            throw new IllegalArgumentException("Invalid AWS region format: " + normalizedRegion);
        }
        String domain = normalizedRegion.startsWith("cn-") ? AMAZON_CHINA_DOMAIN : AMAZON_COM_DOMAIN;
        return String.format("%s.%s.%s", OIDC_SUBDOMAIN, normalizedRegion, domain);
    }

    private byte[] sha256(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(SHA256_METHOD);
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.ERROR, e, "Thread interrupted during sleep", new Object[0]);
            }
            return null;
        }
    }

    private boolean isCachedRegisterClientResponseValid(RegisterClientResponse cachedRegisterClientResponse) {
        if (cachedRegisterClientResponse == null || cachedRegisterClientResponse.clientSecretExpiresAt() == null) {
            return false;
        }
        return System.currentTimeMillis() < cachedRegisterClientResponse.clientSecretExpiresAt() * 1000L;
    }
}

