/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.codegen;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.GenerationException;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.SqlParameterInfo;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.List;
import java.util.Map;

public class ParameterHandlerGenerator {
    private StringBuilder stringBuffer_;
    private ClassInfo classInfo_;

    public ParameterHandlerGenerator(ClassInfo classInfo, StringBuilder stringBuilder) {
        this.stringBuffer_ = stringBuilder;
        this.classInfo_ = classInfo;
    }

    public void generateParameterHandler(MethodInfo methodInfo) {
        boolean bl2 = methodInfo.getSqlStatementType() == SqlStatementType.CALL;
        this.generateComments("  ");
        this.stringBuffer_.append("  public static class " + methodInfo.getParameterHandlerClassNameForStatementDescriptor() + " extends BaseParameterHandler \n");
        this.stringBuffer_.append("  {\n");
        this.generateComments("    ");
        this.stringBuffer_.append("    public void handleParameters (PreparedStatement stmt, Object... parameters) throws SQLException\n");
        this.stringBuffer_.append("    {\n");
        MetaDataInfo metaDataInfo = methodInfo.getParameterMetaDataInfo();
        int[] nArray = metaDataInfo.getSqlTypeForUseInExecution();
        this.generateParmHandlerInputParm(nArray, metaDataInfo.getSqlPrecision(), metaDataInfo.getSqlScale(), metaDataInfo.getSqlParmMode(), bl2, methodInfo.getParameterInfoArray(), methodInfo);
        this.stringBuffer_.append("    }\n");
        this.stringBuffer_.append("  }\n\n");
    }

    private void generateComments(String string) {
        this.stringBuffer_.append(string + "/**\n");
        this.stringBuffer_.append(string + " * @generated\n");
        this.stringBuffer_.append(string + " */");
        this.stringBuffer_.append("\n");
    }

    private void generateParmHandlerInputParm(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, boolean bl2, ParameterInfoArray parameterInfoArray, MethodInfo methodInfo) throws GenerationException {
        int n2;
        int n3;
        List<TypeInfo> list = methodInfo.getParameterList();
        List<TypeInfo> list2 = methodInfo.getParameterListWithoutHandlers();
        String string = "stmt";
        if (bl2) {
            for (n3 = 0; n3 < nArray4.length; ++n3) {
                n2 = nArray4[n3];
                if (n2 != 4 && n2 != 2) continue;
                int n4 = nArray[n3];
                if (n4 == 3 || n4 == 2) {
                    this.stringBuffer_.append("      registerOutParameter (stmt, " + (n3 + 1) + ", " + TypeHelper.getJdbcSQLTypeString(n4) + ", " + nArray3[n3] + ");\n");
                    continue;
                }
                this.stringBuffer_.append("      registerOutParameter (stmt, " + (n3 + 1) + ", " + TypeHelper.getJdbcSQLTypeString(n4) + ");\n");
            }
        }
        n3 = parameterInfoArray.getSqlParameterInfo().size();
        String string2 = null;
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n3];
        TypeInfo typeInfo = null;
        JavaType javaType = null;
        this.validateListAccess(0, null == list2 ? 0 : list2.size(), methodInfo, null);
        int n5 = list.size();
        block7: for (int i10 = 0; i10 < n3; ++i10) {
            SqlParameterInfo sqlParameterInfo = parameterInfoArray.getSqlParameterInfo().get(i10);
            SqlParameterInfo.ParameterEntryInfoInSQL parameterEntryInfoInSQL = sqlParameterInfo.getParameterEntryTypeInSQLString();
            n2 = sqlParameterInfo.getParameterPositionZeroBased();
            if (nArray4[i10] == 4) continue;
            switch (parameterEntryInfoInSQL) {
                case isNonPositionalParameterMarker__: {
                    int n6;
                    if (methodInfo.isOnlyMethodParameterAnObjectArray()) {
                        n6 = n2;
                        n2 = 0;
                        typeInfo = list2.get(n2);
                        javaType = typeInfo.getJavaType();
                    } else {
                        this.validateListAccess(n2, n5, methodInfo, parameterEntryInfoInSQL);
                        typeInfo = list.get(n2);
                        javaType = typeInfo.getJavaType();
                        n6 = this.getPositionInParameterHandlerParametersZeroBased(methodInfo, typeInfo, n2, list, list2);
                        if (javaType == JavaType.MAP || javaType == JavaType.BEAN) {
                            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText(JavaType.MAP == javaType ? "ERR_SQL_INAVALD_PARAMETER_MAP" : "ERR_SQL_INAVALD_PARAMETER_BEAN", n2 + 1), null, 10310, null, methodInfo);
                        }
                    }
                    this.generateParmHandlerMethodSignature(string, i10 + 1, n6, nArray[i10], nArray3[i10], typeInfo);
                    continue block7;
                }
                case isPositionalParameterMarker__: {
                    this.validateListAccess(n2, n5, methodInfo, parameterEntryInfoInSQL);
                    typeInfo = list.get(n2);
                    int n6 = this.getPositionInParameterHandlerParametersZeroBased(methodInfo, typeInfo, n2, list, list2);
                    javaType = typeInfo.getJavaType();
                    if (javaType == JavaType.MAP || javaType == JavaType.BEAN) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText(JavaType.MAP == javaType ? "ERR_SQL_INAVALD_PARAMETER_MAP" : "ERR_SQL_INAVALD_PARAMETER_BEAN", n2 + 1), null, 10311, null, methodInfo);
                    }
                    this.generateParmHandlerMethodSignature(string, i10 + 1, n6, nArray[i10], nArray3[i10], typeInfo);
                    continue block7;
                }
                case isHostVariable__: {
                    n2 = 0;
                    typeInfo = list2.get(n2);
                    int n6 = this.getPositionInParameterHandlerParametersZeroBased(methodInfo, typeInfo, n2, list, list2);
                    if (methodInfo.hasMultiRowParameters()) {
                        typeInfo = typeInfo.getBaseType();
                    }
                    string2 = sqlParameterInfo.getHostVariableName();
                    if (typeInfo.getJavaType() == JavaType.MAP) {
                        this.generateParmHandlerMap(string, blArray, i10 + 1, 0, nArray[i10], nArray3[i10], string2, typeInfo);
                        continue block7;
                    }
                    Map<Integer, BeanInformation> map = methodInfo.getInputBeanInfo();
                    if (map == null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_BEAN_INFO_NOT_FND", string2, n2 + 1), null, 10093, null, methodInfo);
                    }
                    BeanInformation beanInformation = map.get(n2);
                    if (beanInformation == null) {
                        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_BEAN_INFO_NOT_FND", string2, n2 + 1), null, 10094, null, methodInfo);
                    }
                    this.generateParmHandlerBean(string, blArray2, string2, i10 + 1, 0, nArray[i10], nArray3[i10], typeInfo, beanInformation, methodInfo);
                    continue block7;
                }
                case isBean_OR_Map__: {
                    this.validateListAccess(n2, n5, methodInfo, parameterEntryInfoInSQL);
                    typeInfo = list.get(n2);
                    int n6 = this.getPositionInParameterHandlerParametersZeroBased(methodInfo, typeInfo, n2, list, list2);
                    if (methodInfo.hasMultiRowParameters()) {
                        typeInfo = typeInfo.getBaseType();
                    }
                    string2 = sqlParameterInfo.getHostVariableName();
                    if (typeInfo.getJavaType() == JavaType.MAP) {
                        this.generateParmHandlerMap(string, blArray, i10 + 1, n6, nArray[i10], nArray3[i10], string2, typeInfo);
                        continue block7;
                    }
                    this.generateParmHandlerBean(string, blArray2, string2, i10 + 1, n6, nArray[i10], nArray3[i10], typeInfo, methodInfo.getInputBeanInfo().get(n2), methodInfo);
                }
            }
        }
    }

    private int getPositionInParameterHandlerParametersZeroBased(MethodInfo methodInfo, TypeInfo typeInfo, int n2, List<TypeInfo> list, List<TypeInfo> list2) {
        if (list2.size() <= n2) {
            if (list.size() > n2) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("SQL_PARAMETER_MARKER_REFERENCES_HANDLE", typeInfo.getFullyQualifiedName(), methodInfo.getSql()), null, 10631, null, methodInfo);
            }
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("SQL_PARAMETER_MARKERS_AND_NOT_ENOUGH_PARAMETER", n2 + 1, list.size(), methodInfo.getSql()), null, 10632, null, methodInfo);
        }
        return n2;
    }

    private void validateListAccess(int n2, int n3, MethodInfo methodInfo, SqlParameterInfo.ParameterEntryInfoInSQL parameterEntryInfoInSQL) {
        if (n2 > n3 - 1) {
            if (null == parameterEntryInfoInSQL || SqlParameterInfo.ParameterEntryInfoInSQL.isPositionalParameterMarker__ == parameterEntryInfoInSQL || SqlParameterInfo.ParameterEntryInfoInSQL.isBean_OR_Map__ == parameterEntryInfoInSQL) {
                if (1 >= n3) {
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("SQL_PARAMETER_MARKERS_AND_NO_PARAMETERS", methodInfo.getSql()), null, 10750, null, methodInfo);
                }
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("SQL_PARAMETER_MARKERS_AND_NOT_ENOUGH_PARAMETER", n2 + 1, n3, methodInfo.getSql()), null, 10747, null, methodInfo);
            }
            if (SqlParameterInfo.ParameterEntryInfoInSQL.isNonPositionalParameterMarker__ == parameterEntryInfoInSQL || SqlParameterInfo.ParameterEntryInfoInSQL.isHostVariable__ == parameterEntryInfoInSQL) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_DECLARED_PARAM", n2 + 1, methodInfo.getSql(), n3), null, 10328, null, methodInfo);
            }
        }
    }

    private void generateParmHandlerMethodSignature(String string, int n2, int n3, int n4, int n5, TypeInfo typeInfo) {
        this.generateParmHandlerSetXXX(string, "    ", n2, n4, n5, "parameters[" + n3 + "]", true, typeInfo.getJavaType(), typeInfo.getBaseType() == null ? JavaType.NOTSET : typeInfo.getBaseType().getJavaType());
    }

    private void generateParmHandlerBean(String string, boolean[] blArray, String string2, int n2, int n3, int n4, int n5, TypeInfo typeInfo, BeanInformation beanInformation, MethodInfo methodInfo) {
        String string3;
        beanInformation.checkBeanValidityAndThrowExceptionIfNeeded(methodInfo);
        String string4 = null;
        JavaType javaType = null;
        JavaType javaType2 = null;
        BeanPropertyInformation beanPropertyInformation = beanInformation.getPropertyUsingCaseSensitiveName(string2);
        if (beanPropertyInformation == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INV_HOSTVAR", string2), null, 10174, null, methodInfo);
        }
        string4 = beanPropertyInformation.getReadMethod();
        string4 = string4 != null ? string4 + "()" : beanPropertyInformation.getField();
        javaType = beanPropertyInformation.getPropertyTypeInfo().getJavaType();
        Object object = beanPropertyInformation.getPropertyTypeInfo().getBaseType();
        javaType2 = object == null ? JavaType.NOTSET : ((TypeInfo)object).getJavaType();
        if (string4 == null && (string3 = beanInformation.getParameterWrapperForGetMethod()) != null) {
            string4 = string3 + "( \"" + string2 + "\" )";
            javaType = JavaType.OBJECT;
        }
        if (string4 == null) {
            return;
        }
        if (!blArray[n3]) {
            this.stringBuffer_.append("      " + typeInfo.getTypeName() + " bean" + n3 + " = (" + typeInfo.getTypeName() + ") parameters[" + n3 + "];\n");
            blArray[n3] = true;
        }
        if (beanPropertyInformation.isInputValueRequired() && !beanPropertyInformation.getPropertyTypeInfo().isPrimitive()) {
            this.stringBuffer_.append("      checkForRequiredInput(bean" + n3 + "." + string2 + ", \"" + string2 + "\");\n");
        }
        if ((object = beanPropertyInformation.getFormatterClassQualifiedName()) != null) {
            String string5 = "pdqFieldFormatter" + String.valueOf(n2);
            this.stringBuffer_.append("    " + (String)object + " " + string5 + " = new " + (String)object + "(\"" + beanPropertyInformation.getFormattingOptions() + "\"); \n");
            this.generateParmHandlerSetXXX(string, "    ", n2, n4, n5, string5 + ".parse(bean" + n3 + "." + string4 + ")", true, JavaType.OBJECT, JavaType.OBJECT);
        } else {
            this.generateParmHandlerSetXXX(string, "    ", n2, n4, n5, "bean" + n3 + "." + string4, true, javaType, javaType2);
        }
    }

    private void generateParmHandlerMap(String string, boolean[] blArray, int n2, int n3, int n4, int n5, String string2, TypeInfo typeInfo) {
        if (n4 == 0) {
            n4 = 1111;
        }
        if (!blArray[n3]) {
            this.stringBuffer_.append("      " + this.removeGeneric(typeInfo.getTypeName()) + " parmMap" + n3 + " = (" + this.removeGeneric(typeInfo.getTypeName()) + ") parameters[" + n3 + "];\n");
            blArray[n3] = true;
        }
        this.stringBuffer_.append("      setObject (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n4) + ", parmMap" + n3 + ".get (\"" + string2 + "\"), " + n5 + ");\n");
    }

    private int guessSqlTypeFromJavaType(JavaType javaType) {
        switch (javaType) {
            case STRING: {
                return 12;
            }
            case LONG: 
            case SIMPLE_LONG: {
                return -5;
            }
            case BYTE_ARRAY: 
            case SIMPLE_BYTE_ARRAY: {
                return -3;
            }
            case BOOLEAN: 
            case SIMPLE_BOOLEAN: {
                return 16;
            }
            case BLOB: {
                return 2004;
            }
            case CLOB: {
                return 2005;
            }
            case DATE: {
                return 91;
            }
            case BIGDECIMAL: {
                return 3;
            }
            case DOUBLE: 
            case SIMPLE_DOUBLE: {
                return 8;
            }
            case INTEGER: 
            case SIMPLE_INTEGER: {
                return 4;
            }
            case FLOAT: 
            case SIMPLE_FLOAT: {
                return 6;
            }
            case SHORT: 
            case SIMPLE_SHORT: {
                return 5;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: {
                return 93;
            }
            case TIMESTAMPTZ: {
                return -100010;
            }
            case BYTE: 
            case SIMPLE_BYTE: {
                return -6;
            }
            case OBJECT: {
                return 1111;
            }
        }
        return 1111;
    }

    private void generateParmHandlerSetXXX(String string, String string2, int n2, int n3, int n4, String string3, boolean bl2, JavaType javaType, JavaType javaType2) {
        if (n3 == 0) {
            n3 = this.guessSqlTypeFromJavaType(javaType);
        }
        switch (javaType) {
            case STRING: {
                this.stringBuffer_.append(string2 + "  setString (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (String)" : "") + string3 + ");\n");
                break;
            }
            case LONG: 
            case SIMPLE_LONG: {
                this.stringBuffer_.append(string2 + "  setLong (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (Long)" : "") + string3 + ");\n");
                break;
            }
            case SIMPLE_BYTE_ARRAY: {
                this.stringBuffer_.append(string2 + "  setBytes (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (byte[])" : "") + string3 + ");\n");
                break;
            }
            case ARRAY: {
                if (javaType2 == JavaType.SIMPLE_BYTE) {
                    this.stringBuffer_.append(string2 + "  setBytes (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (byte[])" : "") + string3 + ");\n");
                    break;
                }
                this.stringBuffer_.append(string2 + "  setObject (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + ", " + string3 + ", " + n4 + ");\n");
                break;
            }
            case BOOLEAN: 
            case SIMPLE_BOOLEAN: {
                this.stringBuffer_.append(string2 + "  setBoolean (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (Boolean)" : "") + string3 + ");\n");
                break;
            }
            case BLOB: {
                this.stringBuffer_.append(string2 + "  setBlob (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (java.sql.Blob)" : "") + string3 + ");\n");
                break;
            }
            case CLOB: {
                this.stringBuffer_.append(string2 + "  setClob (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (java.sql.Clob)" : "") + string3 + ");\n");
                break;
            }
            case DATE: {
                this.stringBuffer_.append(string2 + "  setDate (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (java.sql.Date)" : "") + string3 + ");\n");
                break;
            }
            case BIGDECIMAL: {
                this.stringBuffer_.append(string2 + "  setBigDecimal (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (java.math.BigDecimal)" : "") + string3 + ");\n");
                break;
            }
            case DOUBLE: 
            case SIMPLE_DOUBLE: {
                this.stringBuffer_.append(string2 + "  setDouble (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (Double)" : "") + string3 + ");\n");
                break;
            }
            case INTEGER: 
            case SIMPLE_INTEGER: {
                this.stringBuffer_.append(string2 + "  setInteger (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (Integer)" : "") + string3 + ");\n");
                break;
            }
            case FLOAT: 
            case SIMPLE_FLOAT: {
                this.stringBuffer_.append(string2 + "  setFloat (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (Float)" : "") + string3 + ");\n");
                break;
            }
            case SHORT: 
            case SIMPLE_SHORT: {
                this.stringBuffer_.append(string2 + "  setShort (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (Short)" : "") + string3 + ");\n");
                break;
            }
            case TIME: {
                this.stringBuffer_.append(string2 + "  setTime (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (java.sql.Time)" : "") + string3 + ");\n");
                break;
            }
            case TIMESTAMP: {
                this.stringBuffer_.append(string2 + "  setTimestamp (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (java.sql.Timestamp)" : "") + string3 + ");\n");
                break;
            }
            case TIMESTAMPTZ: {
                this.stringBuffer_.append(string2 + "  setDBTimestamp (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (com.ibm.db2.jcc.DBTimestamp)" : "") + string3 + ");\n");
                break;
            }
            case BYTE: 
            case SIMPLE_BYTE: {
                this.stringBuffer_.append(string2 + "  setByte (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + "," + (bl2 ? " (Byte)" : "") + string3 + ");\n");
                break;
            }
            default: {
                this.stringBuffer_.append(string2 + "  setObject (" + string + ", " + n2 + ", " + TypeHelper.getJdbcSQLTypeString(n3) + ", " + string3 + ", " + n4 + ");\n");
            }
        }
    }

    private String removeGeneric(String string) {
        int n2 = string.indexOf(60);
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }
}

