/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbStatement;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.InlineBlobResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;

public abstract class AbstractFbWireStatement
extends AbstractFbStatement
implements FbWireStatement {
    private final Map<RowDescriptor, byte[]> blrCache = Collections.synchronizedMap(new WeakHashMap());
    private volatile int handle = 65535;
    private final FbWireDatabase database;

    public AbstractFbWireStatement(FbWireDatabase database) {
        this.database = Objects.requireNonNull(database, "database");
    }

    @Override
    public final LockCloseable withLock() {
        return this.database.withLock();
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    private XdrStreamAccess getXdrStreamAccess() throws SQLException {
        if (this.database != null) {
            return this.database.getXdrStreamAccess();
        }
        throw new SQLException("Connection closed or no connection available");
    }

    @Override
    public final FbWireDatabase getDatabase() {
        return this.database;
    }

    @Override
    public final int getHandle() {
        return this.handle;
    }

    protected final void setHandle(int handle) {
        this.handle = handle;
    }

    @Override
    public FbWireTransaction getTransaction() {
        return (FbWireTransaction)super.getTransaction();
    }

    protected final byte[] calculateBlr(RowDescriptor rowDescriptor) throws SQLException {
        if (rowDescriptor == null) {
            return null;
        }
        byte[] blr = this.blrCache.get(rowDescriptor);
        if (blr == null) {
            blr = this.getBlrCalculator().calculateBlr(rowDescriptor);
            this.blrCache.put(rowDescriptor, blr);
        }
        return blr;
    }

    protected final byte[] calculateBlr(RowDescriptor rowDescriptor, RowValue rowValue) throws SQLException {
        if (rowDescriptor == null || rowValue == null) {
            return null;
        }
        return this.getBlrCalculator().calculateBlr(rowDescriptor, rowValue);
    }

    protected final BlrCalculator getBlrCalculator() {
        return this.getDatabase().getBlrCalculator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws SQLException {
        try {
            super.close();
            return;
        }
        finally {
            try (LockCloseable ignored = this.withLock();){
                this.blrCache.clear();
            }
        }
    }

    @Override
    protected boolean isValidTransactionClass(Class<? extends FbTransaction> transactionClass) {
        return FbWireTransaction.class.isAssignableFrom(transactionClass);
    }

    @Override
    public final RowDescriptor emptyRowDescriptor() {
        return this.database.emptyRowDescriptor();
    }

    @Override
    public byte[] getSqlInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            this.checkStatementValid();
            return this.getInfo(70, requestItems, bufferLength);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected byte[] getInfo(int operation, byte[] requestItems, int bufferLength) throws SQLException {
        return this.getDatabase().getInfo(operation, this.getHandle(), requestItems, bufferLength, this.getStatementWarningCallback());
    }

    protected void handleInlineBlobResponse(InlineBlobResponse inlineBlobResponse) {
    }

    protected final <T> DeferredAction wrapDeferredResponse(DeferredResponse<T> deferredResponse, Function<Response, T> responseMapper) {
        return DeferredAction.wrapDeferredResponse(deferredResponse, responseMapper, this.getStatementWarningCallback(), this::deferredExceptionHandler);
    }

    private void deferredExceptionHandler(Exception exception) {
        if (exception instanceof SQLException) {
            this.exceptionListenerDispatcher.errorOccurred((SQLException)exception);
        }
        if (exception instanceof IOException || exception.getCause() instanceof IOException) {
            this.forceState(StatementState.ERROR);
        }
    }
}

