/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.internal.util.MapUtils;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.AddressResolverGroupMetrics;
import reactor.netty.transport.ClientTransport;
import reactor.netty.transport.MicrometerAddressResolverGroupMetrics;
import reactor.netty.transport.NameResolverProvider;
import reactor.netty.transport.ProxyProvider;
import reactor.netty.transport.TransportConfig;

public abstract class ClientTransportConfig<CONF extends TransportConfig>
extends TransportConfig {
    final ConnectionProvider connectionProvider;
    @Nullable Consumer<? super CONF> doOnConnect;
    @Nullable Consumer<? super Connection> doOnConnected;
    @Nullable Consumer<? super Connection> doOnDisconnected;
    @Nullable Consumer<? super Connection> doOnResolve;
    @Nullable BiConsumer<? super Connection, ? super SocketAddress> doAfterResolve;
    @Nullable BiConsumer<? super Connection, ? super Throwable> doOnResolveError;
    @Nullable NameResolverProvider nameResolverProvider;
    @Nullable ProxyProvider proxyProvider;
    @Nullable Supplier<ProxyProvider> proxyProviderSupplier;
    Supplier<? extends SocketAddress> remoteAddress;
    @Nullable ClientTransport.ResolvedAddressSelector<? super CONF> resolvedAddressesSelector;
    @Nullable AddressResolverGroup<?> resolver;
    static final ConcurrentMap<Integer, DnsAddressResolverGroup> RESOLVERS_CACHE = new ConcurrentHashMap<Integer, DnsAddressResolverGroup>();
    static final NameResolverProvider DEFAULT_NAME_RESOLVER_PROVIDER = NameResolverProvider.builder().build();

    @Override
    public int channelHash() {
        int result = super.channelHash();
        result = 31 * result + Objects.hashCode(this.proxyProvider);
        result = 31 * result + Objects.hashCode(this.resolver);
        result = 31 * result + Objects.hashCode(this.resolvedAddressesSelector);
        return result;
    }

    public ConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    public final @Nullable Consumer<? super CONF> doOnConnect() {
        return this.doOnConnect;
    }

    public final @Nullable Consumer<? super Connection> doOnConnected() {
        return this.doOnConnected;
    }

    public final @Nullable Consumer<? super Connection> doOnDisconnected() {
        return this.doOnDisconnected;
    }

    public final boolean hasProxy() {
        return this.proxyProvider != null || this.proxyProviderSupplier != null;
    }

    public @Nullable NameResolverProvider getNameResolverProvider() {
        return this.nameResolverProvider;
    }

    public final @Nullable ProxyProvider proxyProvider() {
        return this.proxyProvider;
    }

    public final @Nullable Supplier<ProxyProvider> proxyProviderSupplier() {
        return this.proxyProviderSupplier;
    }

    public final Supplier<? extends SocketAddress> remoteAddress() {
        return this.remoteAddress;
    }

    public final @Nullable AddressResolverGroup<?> resolver() {
        return this.resolver;
    }

    protected ClientTransportConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(options);
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
    }

    protected ClientTransportConfig(ClientTransportConfig<CONF> parent) {
        super(parent);
        this.connectionProvider = parent.connectionProvider;
        this.doOnConnect = parent.doOnConnect;
        this.doOnConnected = parent.doOnConnected;
        this.doOnDisconnected = parent.doOnDisconnected;
        this.doOnResolve = parent.doOnResolve;
        this.doAfterResolve = parent.doAfterResolve;
        this.doOnResolveError = parent.doOnResolveError;
        this.resolvedAddressesSelector = parent.resolvedAddressesSelector;
        this.nameResolverProvider = parent.nameResolverProvider;
        this.proxyProvider = parent.proxyProvider;
        this.proxyProviderSupplier = parent.proxyProviderSupplier;
        this.remoteAddress = parent.remoteAddress;
        this.resolver = parent.resolver;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? DomainSocketChannel.class : SocketChannel.class;
    }

    protected abstract AddressResolverGroup<?> defaultAddressResolverGroup();

    @Override
    protected ConnectionObserver defaultConnectionObserver() {
        if (this.channelGroup() == null && this.doOnConnected() == null && this.doOnDisconnected() == null) {
            return ConnectionObserver.emptyListener();
        }
        return new ClientTransportDoOn(this.channelGroup(), this.doOnConnected(), this.doOnDisconnected());
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        if (this.proxyProvider != null) {
            return new ClientTransportChannelInitializer(this.proxyProvider);
        }
        return ChannelPipelineConfigurer.emptyConfigurer();
    }

    @Override
    protected EventLoopGroup eventLoopGroup() {
        return this.loopResources().onClient(this.isPreferNative());
    }

    protected void proxyProvider(ProxyProvider proxyProvider) {
        this.proxyProvider = proxyProvider;
    }

    protected void proxyProviderSupplier(Supplier<ProxyProvider> proxyProviderSupplier) {
        this.proxyProviderSupplier = proxyProviderSupplier;
    }

    protected AddressResolverGroup<?> resolverInternal() {
        AddressResolverGroup<?> resolverGroup;
        AddressResolverGroup<?> addressResolverGroup = resolverGroup = this.resolver != null ? this.resolver : this.defaultAddressResolverGroup();
        if (this.metricsRecorder != null) {
            if (this.metricsRecorder instanceof MicrometerChannelMetricsRecorder) {
                return MicrometerAddressResolverGroupMetrics.getOrCreate(resolverGroup, (MicrometerChannelMetricsRecorder)this.metricsRecorder);
            }
            return AddressResolverGroupMetrics.getOrCreate(resolverGroup, this.metricsRecorder);
        }
        return resolverGroup;
    }

    final @Nullable List<? extends SocketAddress> applyResolvedAddressesSelector(List<? extends SocketAddress> resolvedAddresses) {
        return this.resolvedAddressesSelector != null ? this.resolvedAddressesSelector.apply(this, resolvedAddresses) : resolvedAddresses;
    }

    static DnsAddressResolverGroup getOrCreateResolver(NameResolverProvider nameResolverProvider, LoopResources loopResources, boolean preferNative) {
        return MapUtils.computeIfAbsent(RESOLVERS_CACHE, Objects.hash(nameResolverProvider, loopResources, preferNative), key -> nameResolverProvider.newNameResolverGroup(loopResources, preferNative));
    }

    static final class ClientTransportDoOn
    implements ConnectionObserver {
        final @Nullable ChannelGroup channelGroup;
        final @Nullable Consumer<? super Connection> doOnConnected;
        final @Nullable Consumer<? super Connection> doOnDisconnected;

        ClientTransportDoOn(@Nullable ChannelGroup channelGroup, @Nullable Consumer<? super Connection> doOnConnected, @Nullable Consumer<? super Connection> doOnDisconnected) {
            this.channelGroup = channelGroup;
            this.doOnConnected = doOnConnected;
            this.doOnDisconnected = doOnDisconnected;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.channelGroup != null && newState == ConnectionObserver.State.CONNECTED) {
                this.channelGroup.add((Object)connection.channel());
                return;
            }
            if (this.doOnConnected != null && newState == ConnectionObserver.State.CONFIGURED) {
                this.doOnConnected.accept(connection);
                return;
            }
            if (this.doOnDisconnected != null) {
                if (newState == ConnectionObserver.State.DISCONNECTING) {
                    connection.onDispose(() -> this.doOnDisconnected.accept(connection));
                } else if (newState == ConnectionObserver.State.RELEASED) {
                    this.doOnDisconnected.accept(connection);
                }
            }
        }
    }

    static final class ClientTransportChannelInitializer
    implements ChannelPipelineConfigurer {
        final ProxyProvider proxyProvider;

        ClientTransportChannelInitializer(ProxyProvider proxyProvider) {
            this.proxyProvider = proxyProvider;
        }

        @Override
        public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, @Nullable SocketAddress remoteAddress) {
            if (this.proxyProvider.shouldProxy(remoteAddress)) {
                this.proxyProvider.addProxyHandler(channel);
            }
        }
    }
}

