/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class PublicKeyDiscoveryInput {
    private final ByteBuffer recipientStaticPrivateKey;

    protected PublicKeyDiscoveryInput(BuilderImpl builder) {
        this.recipientStaticPrivateKey = builder.recipientStaticPrivateKey();
    }

    public ByteBuffer recipientStaticPrivateKey() {
        return this.recipientStaticPrivateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer recipientStaticPrivateKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(PublicKeyDiscoveryInput model) {
            this.recipientStaticPrivateKey = model.recipientStaticPrivateKey();
        }

        @Override
        public Builder recipientStaticPrivateKey(ByteBuffer recipientStaticPrivateKey) {
            this.recipientStaticPrivateKey = recipientStaticPrivateKey;
            return this;
        }

        @Override
        public ByteBuffer recipientStaticPrivateKey() {
            return this.recipientStaticPrivateKey;
        }

        @Override
        public PublicKeyDiscoveryInput build() {
            if (Objects.isNull(this.recipientStaticPrivateKey())) {
                throw new IllegalArgumentException("Missing value for required field `recipientStaticPrivateKey`");
            }
            return new PublicKeyDiscoveryInput(this);
        }
    }

    public static interface Builder {
        public Builder recipientStaticPrivateKey(ByteBuffer var1);

        public ByteBuffer recipientStaticPrivateKey();

        public PublicKeyDiscoveryInput build();
    }
}

