/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.monitor;

import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.opensearch.monitor.GCedMemoryUsage;
import org.opensearch.sql.opensearch.monitor.MemoryUsage;
import org.opensearch.sql.opensearch.monitor.RuntimeMemoryUsage;
import shaded.com.google.common.annotations.VisibleForTesting;

public class OpenSearchMemoryHealthy {
    @Generated
    private static final Logger log = LogManager.getLogger(OpenSearchMemoryHealthy.class);
    private final RandomFail randomFail;
    private final MemoryUsage memoryUsage;

    public OpenSearchMemoryHealthy(Settings settings) {
        this.randomFail = new RandomFail();
        this.memoryUsage = this.buildMemoryUsage(settings);
    }

    @VisibleForTesting
    public OpenSearchMemoryHealthy(RandomFail randomFail, MemoryUsage memoryUsage) {
        this.randomFail = randomFail;
        this.memoryUsage = memoryUsage;
    }

    private MemoryUsage buildMemoryUsage(Settings settings) {
        try {
            return this.isCalciteEnabled(settings) ? GCedMemoryUsage.getInstance() : RuntimeMemoryUsage.getInstance();
        }
        catch (Throwable e) {
            return RuntimeMemoryUsage.getInstance();
        }
    }

    private boolean isCalciteEnabled(Settings settings) {
        if (settings != null) {
            return (Boolean)settings.getSettingValue(Settings.Key.CALCITE_ENGINE_ENABLED);
        }
        return false;
    }

    public boolean isMemoryHealthy(long limitBytes) {
        long memoryUsage = this.memoryUsage.usage();
        log.debug("Memory usage:{}, limit:{}", (Object)memoryUsage, (Object)limitBytes);
        if (memoryUsage < limitBytes) {
            return true;
        }
        log.warn("Memory usage:{} exceed limit:{}", (Object)memoryUsage, (Object)limitBytes);
        if (this.randomFail.shouldFail()) {
            log.warn("Fast failing the current request");
            throw new MemoryUsageExceedFastFailureException();
        }
        throw new MemoryUsageExceedException();
    }

    static class RandomFail {
        RandomFail() {
        }

        public boolean shouldFail() {
            return ThreadLocalRandom.current().nextBoolean();
        }
    }

    public static class MemoryUsageExceedFastFailureException
    extends MemoryUsageException {
        @Generated
        public MemoryUsageExceedFastFailureException() {
        }
    }

    public static class MemoryUsageExceedException
    extends MemoryUsageException {
        @Generated
        public MemoryUsageExceedException() {
        }
    }

    public static class MemoryUsageException
    extends RuntimeException {
        @Generated
        public MemoryUsageException() {
        }
    }
}

