/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.IndexBasedArrayIterator;
import androidx.collection.SimpleArrayMap;
import androidx.collection.internal.ContainerHelpersKt;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap<K, V>
extends SimpleArrayMap<K, V>
implements Map<K, V> {
    @Nullable
    EntrySet mEntrySet;
    @Nullable
    KeySet mKeySet;
    @Nullable
    ValueCollection mValues;

    public ArrayMap() {
    }

    public ArrayMap(int capacity) {
        super(capacity);
    }

    public ArrayMap(@Nullable SimpleArrayMap map) {
        super(map);
    }

    public boolean containsAll(@NonNull Collection<?> collection) {
        for (Object o : collection) {
            if (this.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return super.containsValue(value);
    }

    @Override
    public V get(@Nullable Object key) {
        return super.get(key);
    }

    @Override
    public V remove(@Nullable Object key) {
        return super.remove(key);
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        this.ensureCapacity(this.size() + map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean removeAll(@NonNull Collection<?> collection) {
        int oldSize = this.size();
        for (Object o : collection) {
            this.remove(o);
        }
        return oldSize != this.size();
    }

    public boolean retainAll(@NonNull Collection<?> collection) {
        int oldSize = this.size();
        for (int i = this.size() - 1; i >= 0; --i) {
            if (collection.contains(this.keyAt(i))) continue;
            this.removeAt(i);
        }
        return oldSize != this.size();
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.mEntrySet;
        if (entrySet == null) {
            entrySet = this.mEntrySet = new EntrySet();
        }
        return entrySet;
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        KeySet keySet = this.mKeySet;
        if (keySet == null) {
            keySet = this.mKeySet = new KeySet();
        }
        return keySet;
    }

    @Override
    @NonNull
    public Collection<V> values() {
        ValueCollection values = this.mValues;
        if (values == null) {
            values = this.mValues = new ValueCollection();
        }
        return values;
    }

    static <T> boolean equalsSetHelper(Set<T> set, Object object) {
        if (set == object) {
            return true;
        }
        if (object instanceof Set) {
            Set s = (Set)object;
            try {
                return set.size() == s.size() && set.containsAll(s);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        @NonNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }
    }

    final class KeySet
    implements Set<K> {
        KeySet() {
        }

        @Override
        public boolean add(K object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends K> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return ArrayMap.this.containsKey(object);
        }

        @Override
        public boolean containsAll(@NonNull Collection<?> collection) {
            return ArrayMap.this.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        @Override
        @NonNull
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            int index = ArrayMap.this.indexOfKey(object);
            if (index >= 0) {
                ArrayMap.this.removeAt(index);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> collection) {
            return ArrayMap.this.removeAll(collection);
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> collection) {
            return ArrayMap.this.retainAll(collection);
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }

        @Override
        @NonNull
        public Object[] toArray() {
            int N = ArrayMap.this.size();
            Object[] result = new Object[N];
            for (int i = 0; i < N; ++i) {
                result[i] = ArrayMap.this.keyAt(i);
            }
            return result;
        }

        @Override
        @NonNull
        public <T> T[] toArray(@NonNull T[] array) {
            int mySize = this.size();
            if (array.length < mySize) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), mySize);
            }
            for (int i = 0; i < mySize; ++i) {
                array[i] = ArrayMap.this.keyAt(i);
            }
            if (array.length > mySize) {
                array[mySize] = null;
            }
            return array;
        }

        @Override
        public boolean equals(Object object) {
            return ArrayMap.equalsSetHelper(this, object);
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (int i = ArrayMap.this.size() - 1; i >= 0; --i) {
                Object obj = ArrayMap.this.keyAt(i);
                result += obj == null ? 0 : obj.hashCode();
            }
            return result;
        }
    }

    final class ValueCollection
    implements Collection<V> {
        ValueCollection() {
        }

        @Override
        public boolean add(V object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends V> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return ArrayMap.this.__restricted$indexOfValue(object) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.isEmpty();
        }

        @Override
        @NonNull
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean remove(Object object) {
            int index = ArrayMap.this.__restricted$indexOfValue(object);
            if (index >= 0) {
                ArrayMap.this.removeAt(index);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> collection) {
            int N = ArrayMap.this.size();
            boolean changed = false;
            for (int i = 0; i < N; ++i) {
                Object cur = ArrayMap.this.valueAt(i);
                if (!collection.contains(cur)) continue;
                ArrayMap.this.removeAt(i);
                --i;
                --N;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> collection) {
            int N = ArrayMap.this.size();
            boolean changed = false;
            for (int i = 0; i < N; ++i) {
                Object cur = ArrayMap.this.valueAt(i);
                if (collection.contains(cur)) continue;
                ArrayMap.this.removeAt(i);
                --i;
                --N;
                changed = true;
            }
            return changed;
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }

        @Override
        @NonNull
        public Object[] toArray() {
            int N = ArrayMap.this.size();
            Object[] result = new Object[N];
            for (int i = 0; i < N; ++i) {
                result[i] = ArrayMap.this.valueAt(i);
            }
            return result;
        }

        @Override
        @NonNull
        public <T> T[] toArray(@NonNull T[] array) {
            int mySize = this.size();
            if (array.length < mySize) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), mySize);
            }
            for (int i = 0; i < mySize; ++i) {
                array[i] = ArrayMap.this.valueAt(i);
            }
            if (array.length > mySize) {
                array[mySize] = null;
            }
            return array;
        }
    }

    final class MapIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        int mEnd;
        int mIndex;
        boolean mEntryValid;

        MapIterator() {
            this.mEnd = ArrayMap.this.size() - 1;
            this.mIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mEnd;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.mIndex;
            this.mEntryValid = true;
            return this;
        }

        @Override
        public void remove() {
            if (!this.mEntryValid) {
                throw new IllegalStateException();
            }
            ArrayMap.this.removeAt(this.mIndex);
            --this.mIndex;
            --this.mEnd;
            this.mEntryValid = false;
        }

        @Override
        public K getKey() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.keyAt(this.mIndex);
        }

        @Override
        public V getValue() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.valueAt(this.mIndex);
        }

        @Override
        public V setValue(V object) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            return ArrayMap.this.setValueAt(this.mIndex, object);
        }

        @Override
        public boolean equals(Object o) {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ContainerHelpersKt.equal(e.getKey(), ArrayMap.this.keyAt(this.mIndex)) && ContainerHelpersKt.equal(e.getValue(), ArrayMap.this.valueAt(this.mIndex));
        }

        @Override
        public int hashCode() {
            if (!this.mEntryValid) {
                throw new IllegalStateException("This container does not support retaining Map.Entry objects");
            }
            Object key = ArrayMap.this.keyAt(this.mIndex);
            Object value = ArrayMap.this.valueAt(this.mIndex);
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class ValueIterator
    extends IndexBasedArrayIterator<V> {
        ValueIterator() {
            super(ArrayMap.this.size());
        }

        @Override
        protected V elementAt(int index) {
            return ArrayMap.this.valueAt(index);
        }

        @Override
        protected void removeAt(int index) {
            ArrayMap.this.removeAt(index);
        }
    }

    final class KeyIterator
    extends IndexBasedArrayIterator<K> {
        KeyIterator() {
            super(ArrayMap.this.size());
        }

        @Override
        protected K elementAt(int index) {
            return ArrayMap.this.keyAt(index);
        }

        @Override
        protected void removeAt(int index) {
            ArrayMap.this.removeAt(index);
        }
    }
}

