/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.node;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.commonmark.internal.util.Escaping;

public class DefinitionMap<D> {
    private final Class<D> type;
    private final Map<String, D> definitions = new LinkedHashMap<String, D>();

    public DefinitionMap(Class<D> type) {
        this.type = type;
    }

    public Class<D> getType() {
        return this.type;
    }

    public void addAll(DefinitionMap<D> that) {
        for (Map.Entry<String, D> entry : that.definitions.entrySet()) {
            this.definitions.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    public D putIfAbsent(String label, D definition) {
        String normalizedLabel = Escaping.normalizeLabelContent(label);
        return this.definitions.putIfAbsent(normalizedLabel, definition);
    }

    public D get(String label) {
        String normalizedLabel = Escaping.normalizeLabelContent(label);
        return this.definitions.get(normalizedLabel);
    }

    public Set<String> keySet() {
        return this.definitions.keySet();
    }

    public Collection<D> values() {
        return this.definitions.values();
    }
}

