/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import groovy.lang.MetaProperty;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.scala.ScalaPlugin;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.scala.ScalaModel;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaCompileOptionsImpl;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaForkOptionsImpl;
import org.jetbrains.plugins.gradle.tooling.internal.scala.ScalaModelImpl;

public class ScalaModelBuilderImpl
implements ModelBuilderService {
    private static final String COMPILE_SCALA_TASK = "compileScala";

    public boolean canBuild(String modelName) {
        return ScalaModel.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        ScalaPlugin scalaPlugin = (ScalaPlugin)project.getPlugins().findPlugin(ScalaPlugin.class);
        ScalaModel scalaModel = null;
        if (scalaPlugin != null) {
            Task scalaTask = project.getTasks().getByName(COMPILE_SCALA_TASK);
            scalaModel = ScalaModelBuilderImpl.createModel(scalaTask);
        } else {
            Iterator it = project.getTasks().withType(ScalaCompile.class).iterator();
            if (it.hasNext()) {
                scalaModel = ScalaModelBuilderImpl.createModel((Task)it.next());
            }
        }
        return scalaModel;
    }

    @Nullable
    private static ScalaModel createModel(@Nullable Task task) {
        if (!(task instanceof ScalaCompile)) {
            return null;
        }
        ScalaCompile scalaCompile = (ScalaCompile)task;
        ScalaModelImpl scalaModel = new ScalaModelImpl();
        scalaModel.setScalaClasspath(new LinkedHashSet<File>(scalaCompile.getScalaClasspath().getFiles()));
        scalaModel.setZincClasspath(new LinkedHashSet<File>(scalaCompile.getZincClasspath().getFiles()));
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.4")) {
            scalaModel.setScalaCompilerPlugins(new LinkedHashSet<File>(scalaCompile.getScalaCompilerPlugins().getFiles()));
        }
        scalaModel.setScalaCompileOptions(ScalaModelBuilderImpl.create(scalaCompile.getScalaCompileOptions()));
        scalaModel.setTargetCompatibility(scalaCompile.getTargetCompatibility());
        scalaModel.setSourceCompatibility(scalaCompile.getSourceCompatibility());
        return scalaModel;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            ScalaModelBuilderImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ScalaModelBuilderImpl.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ScalaModelBuilderImpl.$$$reportNull$$$0(2);
        }
        if (exception == null) {
            ScalaModelBuilderImpl.$$$reportNull$$$0(3);
        }
        context.getMessageReporter().createMessage().withGroup("gradle.scalaProjectModel.group").withKind(Message.Kind.ERROR).withTitle("Scala import failure").withText("Unable to build Scala project configuration").withException(exception).reportMessage(project);
    }

    @Contract(value="null -> null")
    @Nullable
    private static ScalaCompileOptionsImpl create(@Nullable ScalaCompileOptions options) {
        MetaProperty useCompileDaemonProperty;
        Object useCompileDaemon;
        Object useAnt;
        Object fork;
        Object daemonServer;
        if (options == null) {
            return null;
        }
        ScalaCompileOptionsImpl result = new ScalaCompileOptionsImpl();
        result.setAdditionalParameters(ScalaModelBuilderImpl.wrapStringList(options.getAdditionalParameters()));
        MetaProperty daemonServerProperty = DefaultGroovyMethods.hasProperty((Object)options, (String)"daemonServer");
        Object object = daemonServer = daemonServerProperty != null ? daemonServerProperty.getProperty((Object)options) : null;
        if (daemonServer instanceof String) {
            result.setDaemonServer((String)daemonServer);
        }
        result.setDebugLevel(options.getDebugLevel());
        result.setDeprecation(options.isDeprecation());
        result.setEncoding(options.getEncoding());
        result.setFailOnError(options.isFailOnError());
        result.setForce(String.valueOf(options.isForce()));
        MetaProperty forkProperty = DefaultGroovyMethods.hasProperty((Object)options, (String)"fork");
        Object object2 = fork = forkProperty != null ? forkProperty.getProperty((Object)options) : null;
        if (fork instanceof Boolean) {
            result.setFork((Boolean)fork);
        }
        result.setForkOptions(ScalaModelBuilderImpl.create(options.getForkOptions()));
        result.setListFiles(options.isListFiles());
        result.setLoggingLevel(options.getLoggingLevel());
        result.setDebugLevel(options.getDebugLevel());
        result.setLoggingPhases(ScalaModelBuilderImpl.wrapStringList(options.getLoggingPhases()));
        result.setOptimize(options.isOptimize());
        result.setUnchecked(options.isUnchecked());
        MetaProperty useAntProperty = DefaultGroovyMethods.hasProperty((Object)options, (String)"useAnt");
        Object object3 = useAnt = useAntProperty != null ? useAntProperty.getProperty((Object)options) : null;
        if (useAnt instanceof Boolean) {
            result.setUseAnt((Boolean)useAnt);
        }
        Object object4 = useCompileDaemon = (useCompileDaemonProperty = DefaultGroovyMethods.hasProperty((Object)options, (String)"useCompileDaemon")) != null ? useCompileDaemonProperty.getProperty((Object)options) : null;
        if (useCompileDaemon instanceof Boolean) {
            result.setUseCompileDaemon((Boolean)useCompileDaemon);
        }
        return result;
    }

    @Nullable
    private static List<String> wrapStringList(@Nullable List<?> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(x -> x.toString()).collect(Collectors.toList());
    }

    @Contract(value="null -> null")
    @Nullable
    private static ScalaForkOptionsImpl create(@Nullable ScalaForkOptions forkOptions) {
        if (forkOptions == null) {
            return null;
        }
        ScalaForkOptionsImpl result = new ScalaForkOptionsImpl();
        result.setJvmArgs(ScalaModelBuilderImpl.wrapStringList(forkOptions.getJvmArgs()));
        result.setMemoryInitialSize(forkOptions.getMemoryInitialSize());
        result.setMemoryMaximumSize(forkOptions.getMemoryMaximumSize());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "modelName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "exception";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/tooling/builder/ScalaModelBuilderImpl";
        objectArray[2] = "reportErrorMessage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

