import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { Box, Static } from 'ink';
import { HistoryItemDisplay } from './HistoryItemDisplay.js';
import { ShowMoreLines } from './ShowMoreLines.js';
import { OverflowProvider } from '../contexts/OverflowContext.js';
import { useUIState } from '../contexts/UIStateContext.js';
import { useAppContext } from '../contexts/AppContext.js';
import { AppHeader } from './AppHeader.js';
import { useSettings } from '../contexts/SettingsContext.js';
// Limit Gemini messages to a very high number of lines to mitigate performance
// issues in the worst case if we somehow get an enormous response from Gemini.
// This threshold is arbitrary but should be high enough to never impact normal
// usage.
const MAX_GEMINI_MESSAGE_LINES = 65536;
export const MainContent = () => {
    const { version } = useAppContext();
    const uiState = useUIState();
    const settings = useSettings();
    const useAlternateBuffer = settings.merged.ui?.useAlternateBuffer ?? false;
    const { pendingHistoryItems, mainAreaWidth, staticAreaMaxItemHeight, availableTerminalHeight, } = uiState;
    const historyItems = [
        _jsx(AppHeader, { version: version }, "app-header"),
        ...uiState.history.map((h) => (_jsx(HistoryItemDisplay, { terminalWidth: mainAreaWidth, availableTerminalHeight: staticAreaMaxItemHeight, availableTerminalHeightGemini: MAX_GEMINI_MESSAGE_LINES, item: h, isPending: false, commands: uiState.slashCommands }, h.id))),
    ];
    const pendingItems = (_jsx(OverflowProvider, { children: _jsxs(Box, { flexDirection: "column", width: mainAreaWidth, children: [pendingHistoryItems.map((item, i) => (_jsx(HistoryItemDisplay, { availableTerminalHeight: uiState.constrainHeight ? availableTerminalHeight : undefined, terminalWidth: mainAreaWidth, item: { ...item, id: 0 }, isPending: true, isFocused: !uiState.isEditorDialogOpen, activeShellPtyId: uiState.activePtyId, embeddedShellFocused: uiState.embeddedShellFocused }, i))), _jsx(ShowMoreLines, { constrainHeight: uiState.constrainHeight })] }) }));
    if (useAlternateBuffer) {
        // Placeholder alternate buffer implementation using a scrollable box that
        // is always scrolled to the bottom. In follow up PRs we will switch this
        // to a proper alternate buffer implementation.
        return (_jsx(Box, { flexDirection: "column", overflowY: "scroll", scrollTop: Number.MAX_SAFE_INTEGER, maxHeight: availableTerminalHeight, children: _jsxs(Box, { flexDirection: "column", flexShrink: 0, children: [historyItems, pendingItems] }) }));
    }
    return (_jsxs(_Fragment, { children: [_jsx(Static, { items: historyItems, children: (item) => item }, uiState.historyRemountKey), pendingItems] }));
};
//# sourceMappingURL=MainContent.js.map