﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotevents/IoTEventsRequest.h>
#include <aws/iotevents/IoTEvents_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoTEvents {
namespace Model {

/**
 */
class ListDetectorModelVersionsRequest : public IoTEventsRequest {
 public:
  AWS_IOTEVENTS_API ListDetectorModelVersionsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListDetectorModelVersions"; }

  AWS_IOTEVENTS_API Aws::String SerializePayload() const override;

  AWS_IOTEVENTS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the detector model whose versions are returned.</p>
   */
  inline const Aws::String& GetDetectorModelName() const { return m_detectorModelName; }
  inline bool DetectorModelNameHasBeenSet() const { return m_detectorModelNameHasBeenSet; }
  template <typename DetectorModelNameT = Aws::String>
  void SetDetectorModelName(DetectorModelNameT&& value) {
    m_detectorModelNameHasBeenSet = true;
    m_detectorModelName = std::forward<DetectorModelNameT>(value);
  }
  template <typename DetectorModelNameT = Aws::String>
  ListDetectorModelVersionsRequest& WithDetectorModelName(DetectorModelNameT&& value) {
    SetDetectorModelName(std::forward<DetectorModelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token that you can use to return the next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDetectorModelVersionsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to be returned per request.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListDetectorModelVersionsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_detectorModelName;

  Aws::String m_nextToken;

  int m_maxResults{0};
  bool m_detectorModelNameHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTEvents
}  // namespace Aws
