﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/eventbridge/EventBridge_EXPORTS.h>
#include <aws/eventbridge/model/EndpointEventBus.h>
#include <aws/eventbridge/model/EndpointState.h>
#include <aws/eventbridge/model/ReplicationConfig.h>
#include <aws/eventbridge/model/RoutingConfig.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EventBridge {
namespace Model {
class DescribeEndpointResult {
 public:
  AWS_EVENTBRIDGE_API DescribeEndpointResult() = default;
  AWS_EVENTBRIDGE_API DescribeEndpointResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EVENTBRIDGE_API DescribeEndpointResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the endpoint you asked for information about.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DescribeEndpointResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the endpoint you asked for information about.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeEndpointResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the endpoint you asked for information about.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  DescribeEndpointResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The routing configuration of the endpoint you asked for information
   * about.</p>
   */
  inline const RoutingConfig& GetRoutingConfig() const { return m_routingConfig; }
  template <typename RoutingConfigT = RoutingConfig>
  void SetRoutingConfig(RoutingConfigT&& value) {
    m_routingConfigHasBeenSet = true;
    m_routingConfig = std::forward<RoutingConfigT>(value);
  }
  template <typename RoutingConfigT = RoutingConfig>
  DescribeEndpointResult& WithRoutingConfig(RoutingConfigT&& value) {
    SetRoutingConfig(std::forward<RoutingConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether replication is enabled or disabled for the endpoint you asked for
   * information about.</p>
   */
  inline const ReplicationConfig& GetReplicationConfig() const { return m_replicationConfig; }
  template <typename ReplicationConfigT = ReplicationConfig>
  void SetReplicationConfig(ReplicationConfigT&& value) {
    m_replicationConfigHasBeenSet = true;
    m_replicationConfig = std::forward<ReplicationConfigT>(value);
  }
  template <typename ReplicationConfigT = ReplicationConfig>
  DescribeEndpointResult& WithReplicationConfig(ReplicationConfigT&& value) {
    SetReplicationConfig(std::forward<ReplicationConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The event buses being used by the endpoint you asked for information
   * about.</p>
   */
  inline const Aws::Vector<EndpointEventBus>& GetEventBuses() const { return m_eventBuses; }
  template <typename EventBusesT = Aws::Vector<EndpointEventBus>>
  void SetEventBuses(EventBusesT&& value) {
    m_eventBusesHasBeenSet = true;
    m_eventBuses = std::forward<EventBusesT>(value);
  }
  template <typename EventBusesT = Aws::Vector<EndpointEventBus>>
  DescribeEndpointResult& WithEventBuses(EventBusesT&& value) {
    SetEventBuses(std::forward<EventBusesT>(value));
    return *this;
  }
  template <typename EventBusesT = EndpointEventBus>
  DescribeEndpointResult& AddEventBuses(EventBusesT&& value) {
    m_eventBusesHasBeenSet = true;
    m_eventBuses.emplace_back(std::forward<EventBusesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the role used by the endpoint you asked for information about.</p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  DescribeEndpointResult& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the endpoint you asked for information about.</p>
   */
  inline const Aws::String& GetEndpointId() const { return m_endpointId; }
  template <typename EndpointIdT = Aws::String>
  void SetEndpointId(EndpointIdT&& value) {
    m_endpointIdHasBeenSet = true;
    m_endpointId = std::forward<EndpointIdT>(value);
  }
  template <typename EndpointIdT = Aws::String>
  DescribeEndpointResult& WithEndpointId(EndpointIdT&& value) {
    SetEndpointId(std::forward<EndpointIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL of the endpoint you asked for information about.</p>
   */
  inline const Aws::String& GetEndpointUrl() const { return m_endpointUrl; }
  template <typename EndpointUrlT = Aws::String>
  void SetEndpointUrl(EndpointUrlT&& value) {
    m_endpointUrlHasBeenSet = true;
    m_endpointUrl = std::forward<EndpointUrlT>(value);
  }
  template <typename EndpointUrlT = Aws::String>
  DescribeEndpointResult& WithEndpointUrl(EndpointUrlT&& value) {
    SetEndpointUrl(std::forward<EndpointUrlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current state of the endpoint you asked for information about.</p>
   */
  inline EndpointState GetState() const { return m_state; }
  inline void SetState(EndpointState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline DescribeEndpointResult& WithState(EndpointState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason the endpoint you asked for information about is in its current
   * state.</p>
   */
  inline const Aws::String& GetStateReason() const { return m_stateReason; }
  template <typename StateReasonT = Aws::String>
  void SetStateReason(StateReasonT&& value) {
    m_stateReasonHasBeenSet = true;
    m_stateReason = std::forward<StateReasonT>(value);
  }
  template <typename StateReasonT = Aws::String>
  DescribeEndpointResult& WithStateReason(StateReasonT&& value) {
    SetStateReason(std::forward<StateReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the endpoint you asked for information about was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeEndpointResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The last time the endpoint you asked for information about was modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  DescribeEndpointResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeEndpointResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_arn;

  RoutingConfig m_routingConfig;

  ReplicationConfig m_replicationConfig;

  Aws::Vector<EndpointEventBus> m_eventBuses;

  Aws::String m_roleArn;

  Aws::String m_endpointId;

  Aws::String m_endpointUrl;

  EndpointState m_state{EndpointState::NOT_SET};

  Aws::String m_stateReason;

  Aws::Utils::DateTime m_creationTime{};

  Aws::Utils::DateTime m_lastModifiedTime{};

  Aws::String m_requestId;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_routingConfigHasBeenSet = false;
  bool m_replicationConfigHasBeenSet = false;
  bool m_eventBusesHasBeenSet = false;
  bool m_roleArnHasBeenSet = false;
  bool m_endpointIdHasBeenSet = false;
  bool m_endpointUrlHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_stateReasonHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EventBridge
}  // namespace Aws
