/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha3

// DeviceTaintRuleSpecApplyConfiguration represents a declarative configuration of the DeviceTaintRuleSpec type for use
// with apply.
//
// DeviceTaintRuleSpec specifies the selector and one taint.
type DeviceTaintRuleSpecApplyConfiguration struct {
	// DeviceSelector defines which device(s) the taint is applied to.
	// All selector criteria must be satisfied for a device to
	// match. The empty selector matches all devices. Without
	// a selector, no devices are matches.
	DeviceSelector *DeviceTaintSelectorApplyConfiguration `json:"deviceSelector,omitempty"`
	// The taint that gets applied to matching devices.
	Taint *DeviceTaintApplyConfiguration `json:"taint,omitempty"`
}

// DeviceTaintRuleSpecApplyConfiguration constructs a declarative configuration of the DeviceTaintRuleSpec type for use with
// apply.
func DeviceTaintRuleSpec() *DeviceTaintRuleSpecApplyConfiguration {
	return &DeviceTaintRuleSpecApplyConfiguration{}
}

// WithDeviceSelector sets the DeviceSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeviceSelector field is set to the value of the last call.
func (b *DeviceTaintRuleSpecApplyConfiguration) WithDeviceSelector(value *DeviceTaintSelectorApplyConfiguration) *DeviceTaintRuleSpecApplyConfiguration {
	b.DeviceSelector = value
	return b
}

// WithTaint sets the Taint field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Taint field is set to the value of the last call.
func (b *DeviceTaintRuleSpecApplyConfiguration) WithTaint(value *DeviceTaintApplyConfiguration) *DeviceTaintRuleSpecApplyConfiguration {
	b.Taint = value
	return b
}
