/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
)

// ImageVolumeSourceApplyConfiguration represents a declarative configuration of the ImageVolumeSource type for use
// with apply.
//
// ImageVolumeSource represents a image volume resource.
type ImageVolumeSourceApplyConfiguration struct {
	// Required: Image or artifact reference to be used.
	// Behaves in the same way as pod.spec.containers[*].image.
	// Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets.
	// More info: https://kubernetes.io/docs/concepts/containers/images
	// This field is optional to allow higher level config management to default or override
	// container images in workload controllers like Deployments and StatefulSets.
	Reference *string `json:"reference,omitempty"`
	// Policy for pulling OCI objects. Possible values are:
	// Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails.
	// Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present.
	// IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
	PullPolicy *corev1.PullPolicy `json:"pullPolicy,omitempty"`
}

// ImageVolumeSourceApplyConfiguration constructs a declarative configuration of the ImageVolumeSource type for use with
// apply.
func ImageVolumeSource() *ImageVolumeSourceApplyConfiguration {
	return &ImageVolumeSourceApplyConfiguration{}
}

// WithReference sets the Reference field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reference field is set to the value of the last call.
func (b *ImageVolumeSourceApplyConfiguration) WithReference(value string) *ImageVolumeSourceApplyConfiguration {
	b.Reference = &value
	return b
}

// WithPullPolicy sets the PullPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PullPolicy field is set to the value of the last call.
func (b *ImageVolumeSourceApplyConfiguration) WithPullPolicy(value corev1.PullPolicy) *ImageVolumeSourceApplyConfiguration {
	b.PullPolicy = &value
	return b
}
