/* src/bazaar.p/bz-blocklist.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-blocklist.h"



struct _BzBlocklist
{
  GObject parent_instance;

  int priority;
  GListModel *conditions;
  GListModel *allow;
  GListModel *allow_regex;
  GListModel *block;
  GListModel *block_regex;
};

G_DEFINE_FINAL_TYPE (BzBlocklist, bz_blocklist, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_PRIORITY,
  PROP_CONDITIONS,
  PROP_ALLOW,
  PROP_ALLOW_REGEX,
  PROP_BLOCK,
  PROP_BLOCK_REGEX,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_blocklist_dispose (GObject *object)
{
  BzBlocklist *self = BZ_BLOCKLIST (object);

  g_clear_pointer (&self->conditions, g_object_unref);
  g_clear_pointer (&self->allow, g_object_unref);
  g_clear_pointer (&self->allow_regex, g_object_unref);
  g_clear_pointer (&self->block, g_object_unref);
  g_clear_pointer (&self->block_regex, g_object_unref);

  G_OBJECT_CLASS (bz_blocklist_parent_class)->dispose (object);
}

static void
bz_blocklist_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzBlocklist *self = BZ_BLOCKLIST (object);

  switch (prop_id)
    {
    case PROP_PRIORITY:
      g_value_set_int (value, bz_blocklist_get_priority (self));
      break;
    case PROP_CONDITIONS:
      g_value_set_object (value, bz_blocklist_get_conditions (self));
      break;
    case PROP_ALLOW:
      g_value_set_object (value, bz_blocklist_get_allow (self));
      break;
    case PROP_ALLOW_REGEX:
      g_value_set_object (value, bz_blocklist_get_allow_regex (self));
      break;
    case PROP_BLOCK:
      g_value_set_object (value, bz_blocklist_get_block (self));
      break;
    case PROP_BLOCK_REGEX:
      g_value_set_object (value, bz_blocklist_get_block_regex (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_blocklist_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzBlocklist *self = BZ_BLOCKLIST (object);

  switch (prop_id)
    {
    case PROP_PRIORITY:
      bz_blocklist_set_priority (self, g_value_get_int (value));
      break;
    case PROP_CONDITIONS:
      bz_blocklist_set_conditions (self, g_value_get_object (value));
      break;
    case PROP_ALLOW:
      bz_blocklist_set_allow (self, g_value_get_object (value));
      break;
    case PROP_ALLOW_REGEX:
      bz_blocklist_set_allow_regex (self, g_value_get_object (value));
      break;
    case PROP_BLOCK:
      bz_blocklist_set_block (self, g_value_get_object (value));
      break;
    case PROP_BLOCK_REGEX:
      bz_blocklist_set_block_regex (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_blocklist_class_init (BzBlocklistClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_ensure (BZ_TYPE_BLOCKLIST_CONDITION);

  object_class->set_property = bz_blocklist_set_property;
  object_class->get_property = bz_blocklist_get_property;
  object_class->dispose      = bz_blocklist_dispose;

  props[PROP_PRIORITY] =
      g_param_spec_int (
          "priority",
          NULL, NULL,
          G_MININT, G_MAXINT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CONDITIONS] =
      g_param_spec_object (
          "conditions",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ALLOW] =
      g_param_spec_object (
          "allow",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ALLOW_REGEX] =
      g_param_spec_object (
          "allow-regex",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BLOCK] =
      g_param_spec_object (
          "block",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_BLOCK_REGEX] =
      g_param_spec_object (
          "block-regex",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_blocklist_init (BzBlocklist *self)
{
}

BzBlocklist *
bz_blocklist_new (void){
  return g_object_new (BZ_TYPE_BLOCKLIST, NULL);
}

int
bz_blocklist_get_priority (BzBlocklist *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST (self), 0);
  return self->priority;
}

GListModel *
bz_blocklist_get_conditions (BzBlocklist *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST (self), NULL);
  return self->conditions;
}

GListModel *
bz_blocklist_get_allow (BzBlocklist *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST (self), NULL);
  return self->allow;
}

GListModel *
bz_blocklist_get_allow_regex (BzBlocklist *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST (self), NULL);
  return self->allow_regex;
}

GListModel *
bz_blocklist_get_block (BzBlocklist *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST (self), NULL);
  return self->block;
}

GListModel *
bz_blocklist_get_block_regex (BzBlocklist *self){
  g_return_val_if_fail (BZ_IS_BLOCKLIST (self), NULL);
  return self->block_regex;
}

void
bz_blocklist_set_priority (BzBlocklist *self,
    int priority){
  g_return_if_fail (BZ_IS_BLOCKLIST (self));

  if (priority == self->priority)
    return;

  self->priority = priority;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_PRIORITY]);
}

void
bz_blocklist_set_conditions (BzBlocklist *self,
    GListModel *conditions){
  g_return_if_fail (BZ_IS_BLOCKLIST (self));

  if (conditions == self->conditions)
    return;

  g_clear_pointer (&self->conditions, g_object_unref);
  if (conditions != NULL)
    self->conditions = g_object_ref (conditions);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CONDITIONS]);
}

void
bz_blocklist_set_allow (BzBlocklist *self,
    GListModel *allow){
  g_return_if_fail (BZ_IS_BLOCKLIST (self));

  if (allow == self->allow)
    return;

  g_clear_pointer (&self->allow, g_object_unref);
  if (allow != NULL)
    self->allow = g_object_ref (allow);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ALLOW]);
}

void
bz_blocklist_set_allow_regex (BzBlocklist *self,
    GListModel *allow_regex){
  g_return_if_fail (BZ_IS_BLOCKLIST (self));

  if (allow_regex == self->allow_regex)
    return;

  g_clear_pointer (&self->allow_regex, g_object_unref);
  if (allow_regex != NULL)
    self->allow_regex = g_object_ref (allow_regex);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ALLOW_REGEX]);
}

void
bz_blocklist_set_block (BzBlocklist *self,
    GListModel *block){
  g_return_if_fail (BZ_IS_BLOCKLIST (self));

  if (block == self->block)
    return;

  g_clear_pointer (&self->block, g_object_unref);
  if (block != NULL)
    self->block = g_object_ref (block);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BLOCK]);
}

void
bz_blocklist_set_block_regex (BzBlocklist *self,
    GListModel *block_regex){
  g_return_if_fail (BZ_IS_BLOCKLIST (self));

  if (block_regex == self->block_regex)
    return;

  g_clear_pointer (&self->block_regex, g_object_unref);
  if (block_regex != NULL)
    self->block_regex = g_object_ref (block_regex);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_BLOCK_REGEX]);
}

/* End of src/bazaar.p/bz-blocklist.c */
