// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/media/capture/native_screen_capture_picker.h"
#include "content/public/common/buildflags.h"
#if BUILDFLAG(IS_MAC)
#include "content/browser/media/capture/native_screen_capture_picker_mac.h"
#include "media/base/media_switches.h"
#endif

namespace content {

std::unique_ptr<NativeScreenCapturePicker>
MaybeCreateNativeScreenCapturePicker() {
#if BUILDFLAG(IS_MAC) && BUILDFLAG(ENABLE_SCREEN_CAPTURE)
  if (base::FeatureList::IsEnabled(media::kUseSCContentSharingPicker)) {
    return CreateNativeScreenCapturePickerMac();
  }
#endif
  return nullptr;
}

}  // namespace content
