// media/mojo/mojom/audio_decoder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/audio_decoder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_decoder.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool SupportedAudioDecoderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupportedAudioDecoderConfig_Data* object =
      static_cast<const SupportedAudioDecoderConfig_Data*>(data);


  if (!::media::mojom::internal::AudioCodec_Data
        ::Validate(object->codec, validation_context))
    return false;


  if (!::media::mojom::internal::AudioCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  return true;
}

SupportedAudioDecoderConfig_Data::SupportedAudioDecoderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_GetSupportedConfigs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_GetSupportedConfigs_Params_Data* object =
      static_cast<const AudioDecoder_GetSupportedConfigs_Params_Data*>(data);

  return true;
}

AudioDecoder_GetSupportedConfigs_Params_Data::AudioDecoder_GetSupportedConfigs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_GetSupportedConfigs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_GetSupportedConfigs_ResponseParams_Data* object =
      static_cast<const AudioDecoder_GetSupportedConfigs_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_configs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_configs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->supported_configs, validation_context,
                                         &supported_configs_validate_params)) {
    return false;
  }

  return true;
}

AudioDecoder_GetSupportedConfigs_ResponseParams_Data::AudioDecoder_GetSupportedConfigs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_Construct_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_Construct_Params_Data* object =
      static_cast<const AudioDecoder_Construct_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->media_log, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->media_log,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AudioDecoder_Construct_Params_Data::AudioDecoder_Construct_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_Initialize_Params_Data* object =
      static_cast<const AudioDecoder_Initialize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->config, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cdm_id, validation_context))
    return false;

  return true;
}

AudioDecoder_Initialize_Params_Data::AudioDecoder_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_Initialize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_Initialize_ResponseParams_Data* object =
      static_cast<const AudioDecoder_Initialize_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->success, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->success, validation_context))
    return false;


  if (!::media::mojom::internal::AudioDecoderType_Data
        ::Validate(object->decoder_type, validation_context))
    return false;

  return true;
}

AudioDecoder_Initialize_ResponseParams_Data::AudioDecoder_Initialize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_SetDataSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_SetDataSource_Params_Data* object =
      static_cast<const AudioDecoder_SetDataSource_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receive_pipe, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receive_pipe,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AudioDecoder_SetDataSource_Params_Data::AudioDecoder_SetDataSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_Decode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_Decode_Params_Data* object =
      static_cast<const AudioDecoder_Decode_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buffer, validation_context))
    return false;

  return true;
}

AudioDecoder_Decode_Params_Data::AudioDecoder_Decode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_Decode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_Decode_ResponseParams_Data* object =
      static_cast<const AudioDecoder_Decode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

AudioDecoder_Decode_ResponseParams_Data::AudioDecoder_Decode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_Reset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_Reset_Params_Data* object =
      static_cast<const AudioDecoder_Reset_Params_Data*>(data);

  return true;
}

AudioDecoder_Reset_Params_Data::AudioDecoder_Reset_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoder_Reset_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoder_Reset_ResponseParams_Data* object =
      static_cast<const AudioDecoder_Reset_ResponseParams_Data*>(data);

  return true;
}

AudioDecoder_Reset_ResponseParams_Data::AudioDecoder_Reset_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoderClient_OnBufferDecoded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoderClient_OnBufferDecoded_Params_Data* object =
      static_cast<const AudioDecoderClient_OnBufferDecoded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->buffer, validation_context))
    return false;

  return true;
}

AudioDecoderClient_OnBufferDecoded_Params_Data::AudioDecoderClient_OnBufferDecoded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoderClient_OnWaiting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoderClient_OnWaiting_Params_Data* object =
      static_cast<const AudioDecoderClient_OnWaiting_Params_Data*>(data);


  if (!::media::mojom::internal::WaitingReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

AudioDecoderClient_OnWaiting_Params_Data::AudioDecoderClient_OnWaiting_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media