// media/mojo/mojom/audio_data_pipe.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_data_pipe.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class ReadWriteAudioDataPipeDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::ReadWriteAudioDataPipeDataView> {
  using Data = ::media::mojom::internal::ReadWriteAudioDataPipe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


class ReadWriteAudioDataPipeDataView {
 public:
  ReadWriteAudioDataPipeDataView() = default;

  ReadWriteAudioDataPipeDataView(
      internal::ReadWriteAudioDataPipe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSharedMemoryDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemory(UserType* output) {
    
    auto* pointer = data_->shared_memory.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  mojo::PlatformHandle TakeSocket() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->socket, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ReadWriteAudioDataPipe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ReadWriteAudioDataPipeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ReadWriteAudioDataPipeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ReadWriteAudioDataPipe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::shared_memory(input)) in_shared_memory = Traits::shared_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_memory)::BaseType> shared_memory_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        in_shared_memory, shared_memory_fragment);
    fragment->shared_memory.Set(
        shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->shared_memory.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_memory in ReadWriteAudioDataPipe struct");
    decltype(Traits::socket(input)) in_socket = Traits::socket(input);
    mojo::internal::Serialize<mojo::PlatformHandle>(
        in_socket, &fragment->socket, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->socket),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid socket in ReadWriteAudioDataPipe struct");
  }

  static bool Deserialize(::media::mojom::internal::ReadWriteAudioDataPipe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::ReadWriteAudioDataPipeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void ReadWriteAudioDataPipeDataView::GetSharedMemoryDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) {
  auto pointer = data_->shared_memory.Get();
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DATA_PIPE_MOJOM_SHARED_H_