// components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CLIENT_STATE_CHECKER_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CLIENT_STATE_CHECKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class IndexedDBClientStateCheckerProxy;

template <typename ImplRefTraits>
class IndexedDBClientStateCheckerStub;

class IndexedDBClientStateCheckerRequestValidator;
class IndexedDBClientStateCheckerResponseValidator;


class IndexedDBClientStateChecker
    : public IndexedDBClientStateCheckerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IndexedDBClientStateCheckerInterfaceBase;
  using Proxy_ = IndexedDBClientStateCheckerProxy;

  template <typename ImplRefTraits>
  using Stub_ = IndexedDBClientStateCheckerStub<ImplRefTraits>;

  using RequestValidator_ = IndexedDBClientStateCheckerRequestValidator;
  using ResponseValidator_ = IndexedDBClientStateCheckerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDisallowInactiveClientMinVersion = 0,
    kMakeCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DisallowInactiveClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeClone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IndexedDBClientStateChecker() = default;


  using DisallowInactiveClientCallback = base::OnceCallback<void(bool)>;
  
  virtual void DisallowInactiveClient(DisallowInactiveClientReason reason, ::mojo::PendingReceiver<IndexedDBClientKeepActive> keep_active, DisallowInactiveClientCallback callback) = 0;

  
  virtual void MakeClone(::mojo::PendingReceiver<IndexedDBClientStateChecker> receiver) = 0;
};

class IndexedDBClientKeepActiveProxy;

template <typename ImplRefTraits>
class IndexedDBClientKeepActiveStub;

class IndexedDBClientKeepActiveRequestValidator;


class IndexedDBClientKeepActive
    : public IndexedDBClientKeepActiveInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IndexedDBClientKeepActiveInterfaceBase;
  using Proxy_ = IndexedDBClientKeepActiveProxy;

  template <typename ImplRefTraits>
  using Stub_ = IndexedDBClientKeepActiveStub<ImplRefTraits>;

  using RequestValidator_ = IndexedDBClientKeepActiveRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IndexedDBClientKeepActive() = default;
};



class  IndexedDBClientStateCheckerProxy
    : public IndexedDBClientStateChecker {
 public:
  using InterfaceType = IndexedDBClientStateChecker;

  explicit IndexedDBClientStateCheckerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DisallowInactiveClient(DisallowInactiveClientReason reason, ::mojo::PendingReceiver<IndexedDBClientKeepActive> keep_active, DisallowInactiveClientCallback callback) final;
  
  void MakeClone(::mojo::PendingReceiver<IndexedDBClientStateChecker> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  IndexedDBClientKeepActiveProxy
    : public IndexedDBClientKeepActive {
 public:
  using InterfaceType = IndexedDBClientKeepActive;

  explicit IndexedDBClientKeepActiveProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  IndexedDBClientStateCheckerStubDispatch {
 public:
  static bool Accept(IndexedDBClientStateChecker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IndexedDBClientStateChecker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IndexedDBClientStateChecker>>
class IndexedDBClientStateCheckerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IndexedDBClientStateCheckerStub() = default;
  ~IndexedDBClientStateCheckerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBClientStateCheckerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBClientStateCheckerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  IndexedDBClientKeepActiveStubDispatch {
 public:
  static bool Accept(IndexedDBClientKeepActive* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IndexedDBClientKeepActive* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IndexedDBClientKeepActive>>
class IndexedDBClientKeepActiveStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IndexedDBClientKeepActiveStub() = default;
  ~IndexedDBClientKeepActiveStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBClientKeepActiveStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBClientKeepActiveStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  IndexedDBClientStateCheckerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBClientKeepActiveRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBClientStateCheckerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_CLIENT_STATE_CHECKER_MOJOM_H_