// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{
    Accessible, Align, Allocation, Buildable, ConstraintTarget, DirectionType, EventController,
    LayoutManager, Native, Orientation, Overflow, PickFlags, Requisition, Root, Settings,
    SizeRequestMode, Snapshot, StateFlags, StyleContext, TextDirection, Tooltip, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkWidget")]
    pub struct Widget(Object<ffi::GtkWidget, ffi::GtkWidgetClass>) @implements Accessible, Buildable, ConstraintTarget;

    match fn {
        type_ => || ffi::gtk_widget_get_type(),
    }
}

impl Widget {
    pub const NONE: Option<&'static Widget> = None;

    #[doc(alias = "gtk_widget_get_default_direction")]
    #[doc(alias = "get_default_direction")]
    pub fn default_direction() -> TextDirection {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::gtk_widget_get_default_direction()) }
    }

    #[doc(alias = "gtk_widget_set_default_direction")]
    pub fn set_default_direction(dir: TextDirection) {
        assert_initialized_main_thread!();
        unsafe {
            ffi::gtk_widget_set_default_direction(dir.into_glib());
        }
    }
}

impl std::fmt::Display for Widget {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&WidgetExt::widget_name(self))
    }
}

pub trait WidgetExt: IsA<Widget> + 'static {
    #[doc(alias = "gtk_widget_action_set_enabled")]
    fn action_set_enabled(&self, action_name: &str, enabled: bool) {
        unsafe {
            ffi::gtk_widget_action_set_enabled(
                self.as_ref().to_glib_none().0,
                action_name.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_widget_activate")]
    fn activate(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_activate(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_activate_action_variant")]
    #[doc(alias = "activate_action_variant")]
    fn activate_action(
        &self,
        name: &str,
        args: Option<&glib::Variant>,
    ) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gtk_widget_activate_action_variant(
                    self.as_ref().to_glib_none().0,
                    name.to_glib_none().0,
                    args.to_glib_none().0
                ),
                "Action does not exist"
            )
        }
    }

    #[doc(alias = "gtk_widget_activate_default")]
    fn activate_default(&self) {
        unsafe {
            ffi::gtk_widget_activate_default(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_add_controller")]
    fn add_controller(&self, controller: impl IsA<EventController>) {
        unsafe {
            ffi::gtk_widget_add_controller(
                self.as_ref().to_glib_none().0,
                controller.upcast().into_glib_ptr(),
            );
        }
    }

    #[doc(alias = "gtk_widget_add_css_class")]
    fn add_css_class(&self, css_class: &str) {
        unsafe {
            ffi::gtk_widget_add_css_class(
                self.as_ref().to_glib_none().0,
                css_class.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_add_mnemonic_label")]
    fn add_mnemonic_label(&self, label: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_add_mnemonic_label(
                self.as_ref().to_glib_none().0,
                label.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_allocate")]
    fn allocate(&self, width: i32, height: i32, baseline: i32, transform: Option<gsk::Transform>) {
        unsafe {
            ffi::gtk_widget_allocate(
                self.as_ref().to_glib_none().0,
                width,
                height,
                baseline,
                transform.into_glib_ptr(),
            );
        }
    }

    #[doc(alias = "gtk_widget_child_focus")]
    fn child_focus(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_child_focus(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_widget_compute_bounds")]
    fn compute_bounds(&self, target: &impl IsA<Widget>) -> Option<graphene::Rect> {
        unsafe {
            let mut out_bounds = graphene::Rect::uninitialized();
            let ret = from_glib(ffi::gtk_widget_compute_bounds(
                self.as_ref().to_glib_none().0,
                target.as_ref().to_glib_none().0,
                out_bounds.to_glib_none_mut().0,
            ));
            if ret { Some(out_bounds) } else { None }
        }
    }

    #[doc(alias = "gtk_widget_compute_expand")]
    fn compute_expand(&self, orientation: Orientation) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_compute_expand(
                self.as_ref().to_glib_none().0,
                orientation.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_widget_compute_point")]
    fn compute_point(
        &self,
        target: &impl IsA<Widget>,
        point: &graphene::Point,
    ) -> Option<graphene::Point> {
        unsafe {
            let mut out_point = graphene::Point::uninitialized();
            let ret = from_glib(ffi::gtk_widget_compute_point(
                self.as_ref().to_glib_none().0,
                target.as_ref().to_glib_none().0,
                point.to_glib_none().0,
                out_point.to_glib_none_mut().0,
            ));
            if ret { Some(out_point) } else { None }
        }
    }

    #[doc(alias = "gtk_widget_compute_transform")]
    fn compute_transform(&self, target: &impl IsA<Widget>) -> Option<graphene::Matrix> {
        unsafe {
            let mut out_transform = graphene::Matrix::uninitialized();
            let ret = from_glib(ffi::gtk_widget_compute_transform(
                self.as_ref().to_glib_none().0,
                target.as_ref().to_glib_none().0,
                out_transform.to_glib_none_mut().0,
            ));
            if ret { Some(out_transform) } else { None }
        }
    }

    #[doc(alias = "gtk_widget_contains")]
    fn contains(&self, x: f64, y: f64) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_contains(
                self.as_ref().to_glib_none().0,
                x,
                y,
            ))
        }
    }

    #[doc(alias = "gtk_widget_create_pango_context")]
    fn create_pango_context(&self) -> pango::Context {
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_create_pango_layout")]
    fn create_pango_layout(&self, text: Option<&str>) -> pango::Layout {
        unsafe {
            from_glib_full(ffi::gtk_widget_create_pango_layout(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_drag_check_threshold")]
    fn drag_check_threshold(
        &self,
        start_x: i32,
        start_y: i32,
        current_x: i32,
        current_y: i32,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_drag_check_threshold(
                self.as_ref().to_glib_none().0,
                start_x,
                start_y,
                current_x,
                current_y,
            ))
        }
    }

    #[doc(alias = "gtk_widget_error_bell")]
    fn error_bell(&self) {
        unsafe {
            ffi::gtk_widget_error_bell(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_12", deprecated = "Since 4.12")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_get_allocated_baseline")]
    #[doc(alias = "get_allocated_baseline")]
    fn allocated_baseline(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_baseline(self.as_ref().to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_12", deprecated = "Since 4.12")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_get_allocated_height")]
    #[doc(alias = "get_allocated_height")]
    fn allocated_height(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_height(self.as_ref().to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_12", deprecated = "Since 4.12")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_get_allocated_width")]
    #[doc(alias = "get_allocated_width")]
    fn allocated_width(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_allocated_width(self.as_ref().to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_12", deprecated = "Since 4.12")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_get_allocation")]
    #[doc(alias = "get_allocation")]
    fn allocation(&self) -> Allocation {
        unsafe {
            let mut allocation = Allocation::uninitialized();
            ffi::gtk_widget_get_allocation(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none_mut().0,
            );
            allocation
        }
    }

    #[doc(alias = "gtk_widget_get_ancestor")]
    #[doc(alias = "get_ancestor")]
    #[must_use]
    fn ancestor(&self, widget_type: glib::types::Type) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_ancestor(
                self.as_ref().to_glib_none().0,
                widget_type.into_glib(),
            ))
        }
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "gtk_widget_get_baseline")]
    #[doc(alias = "get_baseline")]
    fn baseline(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_baseline(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_can_focus")]
    #[doc(alias = "get_can_focus")]
    #[doc(alias = "can-focus")]
    fn can_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_can_target")]
    #[doc(alias = "get_can_target")]
    #[doc(alias = "can-target")]
    fn can_target(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_can_target(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_child_visible")]
    #[doc(alias = "get_child_visible")]
    fn is_child_visible(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_child_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_clipboard")]
    #[doc(alias = "get_clipboard")]
    fn clipboard(&self) -> gdk::Clipboard {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_clipboard(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "gtk_widget_get_color")]
    #[doc(alias = "get_color")]
    fn color(&self) -> gdk::RGBA {
        unsafe {
            let mut color = gdk::RGBA::uninitialized();
            ffi::gtk_widget_get_color(self.as_ref().to_glib_none().0, color.to_glib_none_mut().0);
            color
        }
    }

    #[doc(alias = "gtk_widget_get_css_classes")]
    #[doc(alias = "get_css_classes")]
    #[doc(alias = "css-classes")]
    fn css_classes(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_widget_get_css_classes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_css_name")]
    #[doc(alias = "get_css_name")]
    #[doc(alias = "css-name")]
    fn css_name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_widget_get_css_name(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_cursor")]
    #[doc(alias = "get_cursor")]
    fn cursor(&self) -> Option<gdk::Cursor> {
        unsafe { from_glib_none(ffi::gtk_widget_get_cursor(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_direction")]
    #[doc(alias = "get_direction")]
    fn direction(&self) -> TextDirection {
        unsafe {
            from_glib(ffi::gtk_widget_get_direction(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_display")]
    #[doc(alias = "get_display")]
    fn display(&self) -> gdk::Display {
        unsafe { from_glib_none(ffi::gtk_widget_get_display(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_first_child")]
    #[doc(alias = "get_first_child")]
    #[must_use]
    fn first_child(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_first_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_focus_child")]
    #[doc(alias = "get_focus_child")]
    #[must_use]
    fn focus_child(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_focus_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_focus_on_click")]
    #[doc(alias = "get_focus_on_click")]
    #[doc(alias = "focus-on-click")]
    fn gets_focus_on_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_focus_on_click(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_focusable")]
    #[doc(alias = "get_focusable")]
    #[doc(alias = "focusable")]
    fn is_focusable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_focusable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_font_map")]
    #[doc(alias = "get_font_map")]
    fn font_map(&self) -> Option<pango::FontMap> {
        unsafe { from_glib_none(ffi::gtk_widget_get_font_map(self.as_ref().to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v4_16", deprecated = "Since 4.16")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_get_font_options")]
    #[doc(alias = "get_font_options")]
    fn font_options(&self) -> Option<cairo::FontOptions> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_font_options(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_frame_clock")]
    #[doc(alias = "get_frame_clock")]
    fn frame_clock(&self) -> Option<gdk::FrameClock> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_frame_clock(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_halign")]
    #[doc(alias = "get_halign")]
    fn halign(&self) -> Align {
        unsafe { from_glib(ffi::gtk_widget_get_halign(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_has_tooltip")]
    #[doc(alias = "get_has_tooltip")]
    #[doc(alias = "has-tooltip")]
    fn has_tooltip(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_has_tooltip(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_height")]
    #[doc(alias = "get_height")]
    fn height(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_height(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_hexpand")]
    #[doc(alias = "get_hexpand")]
    #[doc(alias = "hexpand")]
    fn hexpands(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_hexpand(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_hexpand_set")]
    #[doc(alias = "get_hexpand_set")]
    #[doc(alias = "hexpand-set")]
    fn is_hexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_hexpand_set(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_last_child")]
    #[doc(alias = "get_last_child")]
    #[must_use]
    fn last_child(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_last_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_layout_manager")]
    #[doc(alias = "get_layout_manager")]
    #[doc(alias = "layout-manager")]
    fn layout_manager(&self) -> Option<LayoutManager> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_layout_manager(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    #[doc(alias = "gtk_widget_get_limit_events")]
    #[doc(alias = "get_limit_events")]
    #[doc(alias = "limit-events")]
    fn is_limit_events(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_limit_events(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_mapped")]
    #[doc(alias = "get_mapped")]
    fn is_mapped(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_mapped(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_margin_bottom")]
    #[doc(alias = "get_margin_bottom")]
    #[doc(alias = "margin-bottom")]
    fn margin_bottom(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_bottom(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_margin_end")]
    #[doc(alias = "get_margin_end")]
    #[doc(alias = "margin-end")]
    fn margin_end(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_end(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_margin_start")]
    #[doc(alias = "get_margin_start")]
    #[doc(alias = "margin-start")]
    fn margin_start(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_start(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_margin_top")]
    #[doc(alias = "get_margin_top")]
    #[doc(alias = "margin-top")]
    fn margin_top(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_margin_top(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_name")]
    #[doc(alias = "get_name")]
    #[doc(alias = "name")]
    fn widget_name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_widget_get_name(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_native")]
    #[doc(alias = "get_native")]
    fn native(&self) -> Option<Native> {
        unsafe { from_glib_none(ffi::gtk_widget_get_native(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_next_sibling")]
    #[doc(alias = "get_next_sibling")]
    #[must_use]
    fn next_sibling(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_next_sibling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_opacity")]
    #[doc(alias = "get_opacity")]
    fn opacity(&self) -> f64 {
        unsafe { ffi::gtk_widget_get_opacity(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_overflow")]
    #[doc(alias = "get_overflow")]
    fn overflow(&self) -> Overflow {
        unsafe { from_glib(ffi::gtk_widget_get_overflow(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_pango_context")]
    #[doc(alias = "get_pango_context")]
    fn pango_context(&self) -> pango::Context {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_pango_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_parent")]
    #[doc(alias = "get_parent")]
    #[must_use]
    fn parent(&self) -> Option<Widget> {
        unsafe { from_glib_none(ffi::gtk_widget_get_parent(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_preferred_size")]
    #[doc(alias = "get_preferred_size")]
    fn preferred_size(&self) -> (Requisition, Requisition) {
        unsafe {
            let mut minimum_size = Requisition::uninitialized();
            let mut natural_size = Requisition::uninitialized();
            ffi::gtk_widget_get_preferred_size(
                self.as_ref().to_glib_none().0,
                minimum_size.to_glib_none_mut().0,
                natural_size.to_glib_none_mut().0,
            );
            (minimum_size, natural_size)
        }
    }

    #[doc(alias = "gtk_widget_get_prev_sibling")]
    #[doc(alias = "get_prev_sibling")]
    #[must_use]
    fn prev_sibling(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_prev_sibling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_primary_clipboard")]
    #[doc(alias = "get_primary_clipboard")]
    fn primary_clipboard(&self) -> gdk::Clipboard {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_primary_clipboard(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_realized")]
    #[doc(alias = "get_realized")]
    fn is_realized(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_realized(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_receives_default")]
    #[doc(alias = "get_receives_default")]
    #[doc(alias = "receives-default")]
    fn receives_default(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_receives_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_request_mode")]
    #[doc(alias = "get_request_mode")]
    fn request_mode(&self) -> SizeRequestMode {
        unsafe {
            from_glib(ffi::gtk_widget_get_request_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_root")]
    #[doc(alias = "get_root")]
    fn root(&self) -> Option<Root> {
        unsafe { from_glib_none(ffi::gtk_widget_get_root(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_scale_factor")]
    #[doc(alias = "get_scale_factor")]
    #[doc(alias = "scale-factor")]
    fn scale_factor(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_scale_factor(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_get_sensitive")]
    #[doc(alias = "sensitive")]
    fn get_sensitive(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_sensitive(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_settings")]
    #[doc(alias = "get_settings")]
    fn settings(&self) -> Settings {
        unsafe { from_glib_none(ffi::gtk_widget_get_settings(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_size")]
    #[doc(alias = "get_size")]
    fn size(&self, orientation: Orientation) -> i32 {
        unsafe { ffi::gtk_widget_get_size(self.as_ref().to_glib_none().0, orientation.into_glib()) }
    }

    #[doc(alias = "gtk_widget_get_size_request")]
    #[doc(alias = "get_size_request")]
    fn size_request(&self) -> (i32, i32) {
        unsafe {
            let mut width = std::mem::MaybeUninit::uninit();
            let mut height = std::mem::MaybeUninit::uninit();
            ffi::gtk_widget_get_size_request(
                self.as_ref().to_glib_none().0,
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            (width.assume_init(), height.assume_init())
        }
    }

    #[doc(alias = "gtk_widget_get_state_flags")]
    #[doc(alias = "get_state_flags")]
    fn state_flags(&self) -> StateFlags {
        unsafe {
            from_glib(ffi::gtk_widget_get_state_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_get_style_context")]
    #[doc(alias = "get_style_context")]
    fn style_context(&self) -> StyleContext {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_style_context(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_tooltip_markup")]
    #[doc(alias = "get_tooltip_markup")]
    #[doc(alias = "tooltip-markup")]
    fn tooltip_markup(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_tooltip_markup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_tooltip_text")]
    #[doc(alias = "get_tooltip_text")]
    #[doc(alias = "tooltip-text")]
    fn tooltip_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_widget_get_tooltip_text(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_valign")]
    #[doc(alias = "get_valign")]
    fn valign(&self) -> Align {
        unsafe { from_glib(ffi::gtk_widget_get_valign(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_vexpand")]
    #[doc(alias = "get_vexpand")]
    #[doc(alias = "vexpand")]
    fn vexpands(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_vexpand(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_vexpand_set")]
    #[doc(alias = "get_vexpand_set")]
    #[doc(alias = "vexpand-set")]
    fn is_vexpand_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_get_vexpand_set(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_get_visible")]
    #[doc(alias = "visible")]
    fn get_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_get_visible(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_get_width")]
    #[doc(alias = "get_width")]
    fn width(&self) -> i32 {
        unsafe { ffi::gtk_widget_get_width(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "gtk_widget_grab_focus")]
    fn grab_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_grab_focus(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_has_css_class")]
    fn has_css_class(&self, css_class: &str) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_css_class(
                self.as_ref().to_glib_none().0,
                css_class.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_has_default")]
    #[doc(alias = "has-default")]
    fn has_default(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_default(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_has_focus")]
    #[doc(alias = "has-focus")]
    fn has_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_has_focus(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_has_visible_focus")]
    fn has_visible_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_has_visible_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_hide")]
    fn hide(&self) {
        unsafe {
            ffi::gtk_widget_hide(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_in_destruction")]
    fn in_destruction(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_in_destruction(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_insert_action_group")]
    fn insert_action_group(&self, name: &str, group: Option<&impl IsA<gio::ActionGroup>>) {
        unsafe {
            ffi::gtk_widget_insert_action_group(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                group.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_insert_after")]
    fn insert_after(&self, parent: &impl IsA<Widget>, previous_sibling: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_widget_insert_after(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
                previous_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_insert_before")]
    fn insert_before(&self, parent: &impl IsA<Widget>, next_sibling: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_widget_insert_before(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
                next_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_is_ancestor")]
    fn is_ancestor(&self, ancestor: &impl IsA<Widget>) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_is_ancestor(
                self.as_ref().to_glib_none().0,
                ancestor.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_is_drawable")]
    fn is_drawable(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_drawable(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_is_focus")]
    fn is_focus(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_focus(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_is_sensitive")]
    fn is_sensitive(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_sensitive(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_is_visible")]
    fn is_visible(&self) -> bool {
        unsafe { from_glib(ffi::gtk_widget_is_visible(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_widget_keynav_failed")]
    fn keynav_failed(&self, direction: DirectionType) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_keynav_failed(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_widget_list_mnemonic_labels")]
    fn list_mnemonic_labels(&self) -> Vec<Widget> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_widget_list_mnemonic_labels(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_map")]
    fn map(&self) {
        unsafe {
            ffi::gtk_widget_map(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_measure")]
    fn measure(&self, orientation: Orientation, for_size: i32) -> (i32, i32, i32, i32) {
        unsafe {
            let mut minimum = std::mem::MaybeUninit::uninit();
            let mut natural = std::mem::MaybeUninit::uninit();
            let mut minimum_baseline = std::mem::MaybeUninit::uninit();
            let mut natural_baseline = std::mem::MaybeUninit::uninit();
            ffi::gtk_widget_measure(
                self.as_ref().to_glib_none().0,
                orientation.into_glib(),
                for_size,
                minimum.as_mut_ptr(),
                natural.as_mut_ptr(),
                minimum_baseline.as_mut_ptr(),
                natural_baseline.as_mut_ptr(),
            );
            (
                minimum.assume_init(),
                natural.assume_init(),
                minimum_baseline.assume_init(),
                natural_baseline.assume_init(),
            )
        }
    }

    #[doc(alias = "gtk_widget_mnemonic_activate")]
    fn mnemonic_activate(&self, group_cycling: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_mnemonic_activate(
                self.as_ref().to_glib_none().0,
                group_cycling.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_widget_observe_children")]
    fn observe_children(&self) -> gio::ListModel {
        unsafe {
            from_glib_full(ffi::gtk_widget_observe_children(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_observe_controllers")]
    fn observe_controllers(&self) -> gio::ListModel {
        unsafe {
            from_glib_full(ffi::gtk_widget_observe_controllers(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_widget_pick")]
    #[must_use]
    fn pick(&self, x: f64, y: f64, flags: PickFlags) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_widget_pick(
                self.as_ref().to_glib_none().0,
                x,
                y,
                flags.into_glib(),
            ))
        }
    }

    #[doc(alias = "gtk_widget_queue_allocate")]
    fn queue_allocate(&self) {
        unsafe {
            ffi::gtk_widget_queue_allocate(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_queue_draw")]
    fn queue_draw(&self) {
        unsafe {
            ffi::gtk_widget_queue_draw(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_queue_resize")]
    fn queue_resize(&self) {
        unsafe {
            ffi::gtk_widget_queue_resize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_realize")]
    fn realize(&self) {
        unsafe {
            ffi::gtk_widget_realize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_remove_controller")]
    fn remove_controller(&self, controller: &impl IsA<EventController>) {
        unsafe {
            ffi::gtk_widget_remove_controller(
                self.as_ref().to_glib_none().0,
                controller.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_remove_css_class")]
    fn remove_css_class(&self, css_class: &str) {
        unsafe {
            ffi::gtk_widget_remove_css_class(
                self.as_ref().to_glib_none().0,
                css_class.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_remove_mnemonic_label")]
    fn remove_mnemonic_label(&self, label: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_remove_mnemonic_label(
                self.as_ref().to_glib_none().0,
                label.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_set_can_focus")]
    #[doc(alias = "can-focus")]
    fn set_can_focus(&self, can_focus: bool) {
        unsafe {
            ffi::gtk_widget_set_can_focus(self.as_ref().to_glib_none().0, can_focus.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_can_target")]
    #[doc(alias = "can-target")]
    fn set_can_target(&self, can_target: bool) {
        unsafe {
            ffi::gtk_widget_set_can_target(self.as_ref().to_glib_none().0, can_target.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_child_visible")]
    fn set_child_visible(&self, child_visible: bool) {
        unsafe {
            ffi::gtk_widget_set_child_visible(
                self.as_ref().to_glib_none().0,
                child_visible.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_widget_set_css_classes")]
    #[doc(alias = "css-classes")]
    fn set_css_classes(&self, classes: &[&str]) {
        unsafe {
            ffi::gtk_widget_set_css_classes(
                self.as_ref().to_glib_none().0,
                classes.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_set_cursor")]
    #[doc(alias = "cursor")]
    fn set_cursor(&self, cursor: Option<&gdk::Cursor>) {
        unsafe {
            ffi::gtk_widget_set_cursor(self.as_ref().to_glib_none().0, cursor.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_set_cursor_from_name")]
    fn set_cursor_from_name(&self, name: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_cursor_from_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_set_direction")]
    fn set_direction(&self, dir: TextDirection) {
        unsafe {
            ffi::gtk_widget_set_direction(self.as_ref().to_glib_none().0, dir.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_focus_child")]
    fn set_focus_child(&self, child: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_widget_set_focus_child(
                self.as_ref().to_glib_none().0,
                child.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_set_focus_on_click")]
    #[doc(alias = "focus-on-click")]
    fn set_focus_on_click(&self, focus_on_click: bool) {
        unsafe {
            ffi::gtk_widget_set_focus_on_click(
                self.as_ref().to_glib_none().0,
                focus_on_click.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_widget_set_focusable")]
    #[doc(alias = "focusable")]
    fn set_focusable(&self, focusable: bool) {
        unsafe {
            ffi::gtk_widget_set_focusable(self.as_ref().to_glib_none().0, focusable.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_font_map")]
    fn set_font_map(&self, font_map: Option<&impl IsA<pango::FontMap>>) {
        unsafe {
            ffi::gtk_widget_set_font_map(
                self.as_ref().to_glib_none().0,
                font_map.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg_attr(feature = "v4_16", deprecated = "Since 4.16")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_set_font_options")]
    fn set_font_options(&self, options: Option<&cairo::FontOptions>) {
        unsafe {
            ffi::gtk_widget_set_font_options(
                self.as_ref().to_glib_none().0,
                options.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_set_halign")]
    #[doc(alias = "halign")]
    fn set_halign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_halign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_has_tooltip")]
    #[doc(alias = "has-tooltip")]
    fn set_has_tooltip(&self, has_tooltip: bool) {
        unsafe {
            ffi::gtk_widget_set_has_tooltip(
                self.as_ref().to_glib_none().0,
                has_tooltip.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_widget_set_hexpand")]
    #[doc(alias = "hexpand")]
    fn set_hexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_hexpand_set")]
    #[doc(alias = "hexpand-set")]
    fn set_hexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_hexpand_set(self.as_ref().to_glib_none().0, set.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_layout_manager")]
    #[doc(alias = "layout-manager")]
    fn set_layout_manager(&self, layout_manager: Option<impl IsA<LayoutManager>>) {
        unsafe {
            ffi::gtk_widget_set_layout_manager(
                self.as_ref().to_glib_none().0,
                layout_manager.map(|p| p.upcast()).into_glib_ptr(),
            );
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    #[doc(alias = "gtk_widget_set_limit_events")]
    #[doc(alias = "limit-events")]
    fn set_limit_events(&self, limit_events: bool) {
        unsafe {
            ffi::gtk_widget_set_limit_events(
                self.as_ref().to_glib_none().0,
                limit_events.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_widget_set_margin_bottom")]
    #[doc(alias = "margin-bottom")]
    fn set_margin_bottom(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_bottom(self.as_ref().to_glib_none().0, margin);
        }
    }

    #[doc(alias = "gtk_widget_set_margin_end")]
    #[doc(alias = "margin-end")]
    fn set_margin_end(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_end(self.as_ref().to_glib_none().0, margin);
        }
    }

    #[doc(alias = "gtk_widget_set_margin_start")]
    #[doc(alias = "margin-start")]
    fn set_margin_start(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_start(self.as_ref().to_glib_none().0, margin);
        }
    }

    #[doc(alias = "gtk_widget_set_margin_top")]
    #[doc(alias = "margin-top")]
    fn set_margin_top(&self, margin: i32) {
        unsafe {
            ffi::gtk_widget_set_margin_top(self.as_ref().to_glib_none().0, margin);
        }
    }

    #[doc(alias = "gtk_widget_set_name")]
    #[doc(alias = "set_name")]
    #[doc(alias = "name")]
    fn set_widget_name(&self, name: &str) {
        unsafe {
            ffi::gtk_widget_set_name(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_set_opacity")]
    #[doc(alias = "opacity")]
    fn set_opacity(&self, opacity: f64) {
        unsafe {
            ffi::gtk_widget_set_opacity(self.as_ref().to_glib_none().0, opacity);
        }
    }

    #[doc(alias = "gtk_widget_set_overflow")]
    #[doc(alias = "overflow")]
    fn set_overflow(&self, overflow: Overflow) {
        unsafe {
            ffi::gtk_widget_set_overflow(self.as_ref().to_glib_none().0, overflow.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_parent")]
    fn set_parent(&self, parent: &impl IsA<Widget>) {
        unsafe {
            ffi::gtk_widget_set_parent(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_set_receives_default")]
    #[doc(alias = "receives-default")]
    fn set_receives_default(&self, receives_default: bool) {
        unsafe {
            ffi::gtk_widget_set_receives_default(
                self.as_ref().to_glib_none().0,
                receives_default.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_widget_set_sensitive")]
    #[doc(alias = "sensitive")]
    fn set_sensitive(&self, sensitive: bool) {
        unsafe {
            ffi::gtk_widget_set_sensitive(self.as_ref().to_glib_none().0, sensitive.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_size_request")]
    fn set_size_request(&self, width: i32, height: i32) {
        unsafe {
            ffi::gtk_widget_set_size_request(self.as_ref().to_glib_none().0, width, height);
        }
    }

    #[doc(alias = "gtk_widget_set_state_flags")]
    fn set_state_flags(&self, flags: StateFlags, clear: bool) {
        unsafe {
            ffi::gtk_widget_set_state_flags(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                clear.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_widget_set_tooltip_markup")]
    #[doc(alias = "tooltip-markup")]
    fn set_tooltip_markup(&self, markup: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_tooltip_markup(
                self.as_ref().to_glib_none().0,
                markup.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_widget_set_tooltip_text")]
    #[doc(alias = "tooltip-text")]
    fn set_tooltip_text(&self, text: Option<&str>) {
        unsafe {
            ffi::gtk_widget_set_tooltip_text(self.as_ref().to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_set_valign")]
    #[doc(alias = "valign")]
    fn set_valign(&self, align: Align) {
        unsafe {
            ffi::gtk_widget_set_valign(self.as_ref().to_glib_none().0, align.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_vexpand")]
    #[doc(alias = "vexpand")]
    fn set_vexpand(&self, expand: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand(self.as_ref().to_glib_none().0, expand.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_vexpand_set")]
    #[doc(alias = "vexpand-set")]
    fn set_vexpand_set(&self, set: bool) {
        unsafe {
            ffi::gtk_widget_set_vexpand_set(self.as_ref().to_glib_none().0, set.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_set_visible")]
    #[doc(alias = "visible")]
    fn set_visible(&self, visible: bool) {
        unsafe {
            ffi::gtk_widget_set_visible(self.as_ref().to_glib_none().0, visible.into_glib());
        }
    }

    #[doc(alias = "gtk_widget_should_layout")]
    fn should_layout(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_widget_should_layout(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_show")]
    fn show(&self) {
        unsafe {
            ffi::gtk_widget_show(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_size_allocate")]
    fn size_allocate(&self, allocation: &Allocation, baseline: i32) {
        unsafe {
            ffi::gtk_widget_size_allocate(
                self.as_ref().to_glib_none().0,
                allocation.to_glib_none().0,
                baseline,
            );
        }
    }

    #[doc(alias = "gtk_widget_snapshot_child")]
    fn snapshot_child(&self, child: &impl IsA<Widget>, snapshot: &impl IsA<Snapshot>) {
        unsafe {
            ffi::gtk_widget_snapshot_child(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                snapshot.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg_attr(feature = "v4_12", deprecated = "Since 4.12")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_widget_translate_coordinates")]
    fn translate_coordinates(
        &self,
        dest_widget: &impl IsA<Widget>,
        src_x: f64,
        src_y: f64,
    ) -> Option<(f64, f64)> {
        unsafe {
            let mut dest_x = std::mem::MaybeUninit::uninit();
            let mut dest_y = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_widget_translate_coordinates(
                self.as_ref().to_glib_none().0,
                dest_widget.as_ref().to_glib_none().0,
                src_x,
                src_y,
                dest_x.as_mut_ptr(),
                dest_y.as_mut_ptr(),
            ));
            if ret {
                Some((dest_x.assume_init(), dest_y.assume_init()))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_widget_trigger_tooltip_query")]
    fn trigger_tooltip_query(&self) {
        unsafe {
            ffi::gtk_widget_trigger_tooltip_query(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_unmap")]
    fn unmap(&self) {
        unsafe {
            ffi::gtk_widget_unmap(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_unparent")]
    fn unparent(&self) {
        unsafe {
            ffi::gtk_widget_unparent(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_unrealize")]
    fn unrealize(&self) {
        unsafe {
            ffi::gtk_widget_unrealize(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_widget_unset_state_flags")]
    fn unset_state_flags(&self, flags: StateFlags) {
        unsafe {
            ffi::gtk_widget_unset_state_flags(self.as_ref().to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "height-request")]
    fn height_request(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "height-request")
    }

    #[doc(alias = "height-request")]
    fn set_height_request(&self, height_request: i32) {
        ObjectExt::set_property(self.as_ref(), "height-request", height_request)
    }

    #[doc(alias = "width-request")]
    fn width_request(&self) -> i32 {
        ObjectExt::property(self.as_ref(), "width-request")
    }

    #[doc(alias = "width-request")]
    fn set_width_request(&self, width_request: i32) {
        ObjectExt::set_property(self.as_ref(), "width-request", width_request)
    }

    #[doc(alias = "destroy")]
    fn connect_destroy<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn destroy_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"destroy".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    destroy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "direction-changed")]
    fn connect_direction_changed<F: Fn(&Self, TextDirection) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn direction_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, TextDirection) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            previous_direction: ffi::GtkTextDirection,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Widget::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(previous_direction),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"direction-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    direction_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hide")]
    fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn hide_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"hide".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    hide_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "keynav-failed")]
    fn connect_keynav_failed<F: Fn(&Self, DirectionType) -> glib::Propagation + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn keynav_failed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, DirectionType) -> glib::Propagation + 'static,
        >(
            this: *mut ffi::GtkWidget,
            direction: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Widget::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(direction),
                )
                .into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"keynav-failed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    keynav_failed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "map")]
    fn connect_map<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn map_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"map".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    map_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mnemonic-activate")]
    fn connect_mnemonic_activate<F: Fn(&Self, bool) -> glib::Propagation + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn mnemonic_activate_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, bool) -> glib::Propagation + 'static,
        >(
            this: *mut ffi::GtkWidget,
            group_cycling: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Widget::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(group_cycling),
                )
                .into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"mnemonic-activate".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    mnemonic_activate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "move-focus")]
    fn connect_move_focus<F: Fn(&Self, DirectionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, DirectionType) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            direction: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Widget::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(direction),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"move-focus".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    move_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_focus(&self, direction: DirectionType) {
        self.emit_by_name::<()>("move-focus", &[&direction]);
    }

    #[doc(alias = "query-tooltip")]
    fn connect_query_tooltip<F: Fn(&Self, i32, i32, bool, &Tooltip) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn query_tooltip_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, i32, i32, bool, &Tooltip) -> bool + 'static,
        >(
            this: *mut ffi::GtkWidget,
            x: std::ffi::c_int,
            y: std::ffi::c_int,
            keyboard_mode: glib::ffi::gboolean,
            tooltip: *mut ffi::GtkTooltip,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Widget::from_glib_borrow(this).unsafe_cast_ref(),
                    x,
                    y,
                    from_glib(keyboard_mode),
                    &from_glib_borrow(tooltip),
                )
                .into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"query-tooltip".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    query_tooltip_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "realize")]
    fn connect_realize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn realize_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"realize".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    realize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show")]
    fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn show_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"show".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    show_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state-flags-changed")]
    fn connect_state_flags_changed<F: Fn(&Self, StateFlags) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn state_flags_changed_trampoline<
            P: IsA<Widget>,
            F: Fn(&P, StateFlags) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            flags: ffi::GtkStateFlags,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    Widget::from_glib_borrow(this).unsafe_cast_ref(),
                    from_glib(flags),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"state-flags-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    state_flags_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "unmap")]
    fn connect_unmap<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unmap_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"unmap".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    unmap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "unrealize")]
    fn connect_unrealize<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unrealize_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"unrealize".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    unrealize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "can-focus")]
    fn connect_can_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::can-focus".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_can_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "can-target")]
    fn connect_can_target_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_target_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::can-target".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_can_target_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "css-classes")]
    fn connect_css_classes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_css_classes_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::css-classes".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_css_classes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "cursor")]
    fn connect_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::cursor".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focus-on-click")]
    fn connect_focus_on_click_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_on_click_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::focus-on-click".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_focus_on_click_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focusable")]
    fn connect_focusable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focusable_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::focusable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_focusable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "halign")]
    fn connect_halign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_halign_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::halign".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_halign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-default")]
    fn connect_has_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_default_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::has-default".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_has_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-focus")]
    fn connect_has_focus_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_focus_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::has-focus".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_has_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "has-tooltip")]
    fn connect_has_tooltip_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_tooltip_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::has-tooltip".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_has_tooltip_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "height-request")]
    fn connect_height_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_height_request_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::height-request".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_height_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hexpand")]
    fn connect_hexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hexpand_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::hexpand".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_hexpand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hexpand-set")]
    fn connect_hexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hexpand_set_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::hexpand-set".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_hexpand_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "layout-manager")]
    fn connect_layout_manager_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_layout_manager_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::layout-manager".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_layout_manager_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    #[doc(alias = "limit-events")]
    fn connect_limit_events_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_limit_events_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::limit-events".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_limit_events_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "margin-bottom")]
    fn connect_margin_bottom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_bottom_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::margin-bottom".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_margin_bottom_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "margin-end")]
    fn connect_margin_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_end_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::margin-end".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_margin_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "margin-start")]
    fn connect_margin_start_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_start_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::margin-start".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_margin_start_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "margin-top")]
    fn connect_margin_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_top_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::margin-top".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_margin_top_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "name")]
    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_name_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "opacity")]
    fn connect_opacity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_opacity_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::opacity".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_opacity_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "overflow")]
    fn connect_overflow_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overflow_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::overflow".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_overflow_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "parent")]
    fn connect_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_parent_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::parent".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_parent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "receives-default")]
    fn connect_receives_default_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_receives_default_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::receives-default".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_receives_default_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "root")]
    fn connect_root_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_root_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::root".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_root_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scale-factor")]
    fn connect_scale_factor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_factor_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::scale-factor".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scale_factor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "sensitive")]
    fn connect_sensitive_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sensitive_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::sensitive".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_sensitive_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tooltip-markup")]
    fn connect_tooltip_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_markup_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tooltip-markup".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tooltip_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tooltip-text")]
    fn connect_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_text_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tooltip-text".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tooltip_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "valign")]
    fn connect_valign_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_valign_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::valign".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_valign_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vexpand")]
    fn connect_vexpand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vexpand_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::vexpand".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_vexpand_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vexpand-set")]
    fn connect_vexpand_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vexpand_set_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::vexpand-set".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_vexpand_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visible")]
    fn connect_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::visible".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_visible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "width-request")]
    fn connect_width_request_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_request_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(Widget::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::width-request".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_width_request_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Widget>> WidgetExt for O {}
