/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkClientConnectionStrategy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile ZkCredentialsProvider zkCredentialsToAddAutomatically;
    private volatile boolean zkCredentialsToAddAutomaticallyUsed = false;
    private List<DisconnectedListener> disconnectedListeners = new ArrayList<DisconnectedListener>();
    private List<ConnectedListener> connectedListeners = new ArrayList<ConnectedListener>();

    public abstract void connect(String var1, int var2, Watcher var3, ZkUpdate var4) throws IOException, InterruptedException, TimeoutException;

    public abstract void reconnect(String var1, int var2, Watcher var3, ZkUpdate var4) throws IOException, InterruptedException, TimeoutException;

    public synchronized void disconnected() {
        for (DisconnectedListener listener : this.disconnectedListeners) {
            try {
                listener.disconnected();
            }
            catch (Exception e) {
                log.error("Exception on disconnected for listener: {}", (Object)listener, (Object)e);
            }
        }
    }

    public synchronized void connected() {
        for (ConnectedListener listener : this.connectedListeners) {
            try {
                listener.connected();
            }
            catch (Exception e) {
                log.error("Exception on connected for listener: {}", (Object)listener, (Object)e);
            }
        }
    }

    public synchronized void addDisconnectedListener(DisconnectedListener listener) {
        this.disconnectedListeners.add(listener);
    }

    public synchronized void removeDisconnectedListener(DisconnectedListener listener) {
        this.disconnectedListeners.remove(listener);
    }

    public synchronized void addConnectedListener(ConnectedListener listener) {
        this.connectedListeners.add(listener);
    }

    public void setZkCredentialsToAddAutomatically(ZkCredentialsProvider zkCredentialsToAddAutomatically) {
        if (this.zkCredentialsToAddAutomaticallyUsed || zkCredentialsToAddAutomatically == null) {
            throw new RuntimeException("Cannot change zkCredentialsToAddAutomatically after it has been (connect or reconnect was called) used or to null");
        }
        this.zkCredentialsToAddAutomatically = zkCredentialsToAddAutomatically;
    }

    public boolean hasZkCredentialsToAddAutomatically() {
        return this.zkCredentialsToAddAutomatically != null;
    }

    public ZkCredentialsProvider getZkCredentialsToAddAutomatically() {
        return this.zkCredentialsToAddAutomatically;
    }

    protected ZooKeeper createZooKeeper(String serverAddress, int zkClientTimeout, Watcher watcher) throws IOException {
        ZooKeeper result = this.newZooKeeperInstance(serverAddress, zkClientTimeout, watcher);
        this.zkCredentialsToAddAutomaticallyUsed = true;
        for (ZkCredentialsProvider.ZkCredentials zkCredentials : this.zkCredentialsToAddAutomatically.getCredentials()) {
            result.addAuthInfo(zkCredentials.getScheme(), zkCredentials.getAuth());
        }
        return result;
    }

    protected ZooKeeper newZooKeeperInstance(String serverAddress, int zkClientTimeout, Watcher watcher) throws IOException {
        return new ZooKeeper(serverAddress, zkClientTimeout, watcher);
    }

    public static ZkClientConnectionStrategy forName(String name, ZkClientConnectionStrategy def) {
        log.debug("Attempting to load zk connection strategy '{}'", (Object)name);
        if (name == null) {
            return def;
        }
        try {
            return Class.forName(name).asSubclass(ZkClientConnectionStrategy.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.warn("Exception when loading '{}' ZK connection strategy.", (Object)name, (Object)e);
            return def;
        }
    }

    public static interface ZkUpdate {
        public void update(ZooKeeper var1) throws InterruptedException, TimeoutException, IOException;
    }

    public static interface ConnectedListener {
        public void connected();
    }

    public static interface DisconnectedListener {
        public void disconnected();
    }
}

