/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;

abstract class PropertyMap<V>
extends AbstractMap<String, V> {
    final PropertyAccessor accessor;
    final KeyNamePolicy keyPolicy;
    transient Set<Map.Entry<String, V>> entrySet;

    PropertyMap(PropertyAccessor propertyAccessor, KeyNamePolicy keyNamePolicy) {
        this.accessor = propertyAccessor;
        this.keyPolicy = keyNamePolicy;
    }

    @Override
    public int size() {
        return this.accessor.count();
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof String && this.accessor.indexOf((String)object, false) >= 0;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new Entries();
        }
        return this.entrySet;
    }

    abstract Iterator<Map.Entry<String, V>> iterator();

    class Entries
    extends AbstractSet<Map.Entry<String, V>> {
        Entries() {
        }

        @Override
        public final boolean isEmpty() {
            return PropertyMap.this.isEmpty();
        }

        @Override
        public final int size() {
            return PropertyMap.this.size();
        }

        @Override
        public final Iterator<Map.Entry<String, V>> iterator() {
            return PropertyMap.this.iterator();
        }
    }

    abstract class Iter
    implements Iterator<Map.Entry<String, V>> {
        int index;

        Iter() {
        }

        @Override
        public final boolean hasNext() {
            return this.index < PropertyMap.this.accessor.count();
        }
    }
}

