/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetQuery;

public class BitDocSet
extends DocSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BitDocSet.class) + RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    private final FixedBitSet bits;
    int size;

    public BitDocSet() {
        this.bits = new FixedBitSet(64);
    }

    public BitDocSet(FixedBitSet bits) {
        this.bits = bits;
        this.size = -1;
    }

    public BitDocSet(FixedBitSet bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    @Override
    public DocIterator iterator() {
        return new DocIterator(){
            private final BitSetIterator iter;
            private int pos;
            {
                this.iter = new BitSetIterator((BitSet)BitDocSet.this.bits, 0L);
                this.pos = this.iter.nextDoc();
            }

            @Override
            public boolean hasNext() {
                return this.pos != Integer.MAX_VALUE;
            }

            @Override
            public Integer next() {
                return this.nextDoc();
            }

            @Override
            public void remove() {
                BitDocSet.this.bits.clear(this.pos);
            }

            @Override
            public int nextDoc() {
                int old = this.pos;
                this.pos = this.iter.nextDoc();
                return old;
            }

            @Override
            public float score() {
                return 0.0f;
            }
        };
    }

    public FixedBitSet getBits() {
        return this.bits;
    }

    @Override
    protected FixedBitSet getFixedBitSet() {
        return this.bits;
    }

    @Override
    protected FixedBitSet getFixedBitSetClone() {
        return this.bits.clone();
    }

    @Override
    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        this.size = this.bits.cardinality();
        return this.size;
    }

    @Override
    public boolean exists(int doc) {
        return this.bits.get(doc);
    }

    @Override
    public DocSet intersection(DocSet other) {
        if (!(other instanceof BitDocSet)) {
            return other.intersection(this);
        }
        FixedBitSet newbits = this.getFixedBitSetClone();
        newbits.and(other.getFixedBitSet());
        return new BitDocSet(newbits);
    }

    @Override
    public int intersectionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)FixedBitSet.intersectionCount((FixedBitSet)this.bits, (FixedBitSet)((BitDocSet)other).bits);
        }
        return other.intersectionSize(this);
    }

    @Override
    public boolean intersects(DocSet other) {
        if (other instanceof BitDocSet) {
            return this.bits.intersects(((BitDocSet)other).bits);
        }
        return other.intersects(this);
    }

    @Override
    public int unionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)FixedBitSet.unionCount((FixedBitSet)this.bits, (FixedBitSet)((BitDocSet)other).bits);
        }
        return other.unionSize(this);
    }

    @Override
    public int andNotSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)FixedBitSet.andNotCount((FixedBitSet)this.bits, (FixedBitSet)((BitDocSet)other).bits);
        }
        return super.andNotSize(other);
    }

    @Override
    public void addAllTo(FixedBitSet target) {
        target.or(this.bits);
    }

    @Override
    public DocSet andNot(DocSet other) {
        FixedBitSet newbits = this.getFixedBitSetClone();
        BitDocSet.andNot(newbits, other);
        return new BitDocSet(newbits);
    }

    protected static void andNot(FixedBitSet bits, DocSet other) {
        if (other instanceof BitDocSet) {
            bits.andNot(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                int doc = iter.nextDoc();
                if (doc >= bits.length()) continue;
                bits.clear(doc);
            }
        }
    }

    @Override
    public DocSet union(DocSet other) {
        FixedBitSet newbits = this.bits.clone();
        if (other instanceof BitDocSet) {
            BitDocSet otherDocSet = (BitDocSet)other;
            newbits = FixedBitSet.ensureCapacity((FixedBitSet)newbits, (int)otherDocSet.bits.length());
            newbits.or(otherDocSet.bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                int doc = iter.nextDoc();
                newbits = FixedBitSet.ensureCapacity((FixedBitSet)newbits, (int)doc);
                newbits.set(doc);
            }
        }
        return new BitDocSet(newbits);
    }

    @Override
    public BitDocSet clone() {
        return new BitDocSet(this.bits.clone(), this.size);
    }

    @Override
    public DocIdSetIterator iterator(LeafReaderContext context) {
        if (context.isTopLevel) {
            switch (this.size) {
                case -1: {
                    int maxSize = this.bits.length();
                    if (maxSize < 1) {
                        return null;
                    }
                    return new BitSetIterator((BitSet)this.bits, (long)maxSize);
                }
                case 0: {
                    return null;
                }
            }
            return new BitSetIterator((BitSet)this.bits, (long)this.size);
        }
        int maxDoc = context.reader().maxDoc();
        if (maxDoc < 1) {
            return null;
        }
        final int base = context.docBase;
        final int max = base + maxDoc;
        final FixedBitSet bs = this.bits;
        return new DocIdSetIterator(){
            int pos;
            int adjustedDoc;
            {
                this.pos = base - 1;
                this.adjustedDoc = -1;
            }

            public int docID() {
                return this.adjustedDoc;
            }

            public int nextDoc() {
                int next = this.pos + 1;
                if (next >= max) {
                    this.adjustedDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.pos = bs.nextSetBit(next);
                this.adjustedDoc = this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                return this.adjustedDoc;
            }

            public int advance(int target) {
                if (target == Integer.MAX_VALUE) {
                    this.adjustedDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                int adjusted = target + base;
                if (adjusted >= max) {
                    this.adjustedDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.pos = bs.nextSetBit(adjusted);
                this.adjustedDoc = this.pos < max ? this.pos - base : Integer.MAX_VALUE;
                return this.adjustedDoc;
            }

            public long cost() {
                int maxDoc = max - base;
                if (BitDocSet.this.size != -1) {
                    return (long)((float)BitDocSet.this.size * ((float)(FixedBitSet.bits2words((int)maxDoc) << 6) / (float)bs.length()));
                }
                return maxDoc;
            }
        };
    }

    @Override
    public DocSetQuery makeQuery() {
        return new DocSetQuery(this);
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + ((long)this.bits.getBits().length << 3);
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return "BitDocSet{size=" + this.size() + ",ramUsed=" + RamUsageEstimator.humanReadableUnits((long)this.ramBytesUsed()) + "}";
    }
}

