/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.CollectionRequiringSolrRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class LukeRequest
extends CollectionRequiringSolrRequest<LukeResponse> {
    private List<String> fields;
    private int numTerms = -1;
    private boolean showSchema = false;
    private Boolean includeIndexFieldFlags = null;

    public LukeRequest() {
        super(SolrRequest.METHOD.GET, "/admin/luke");
    }

    public LukeRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    public void addField(String f) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(f);
    }

    public void setFields(List<String> f) {
        this.fields = f;
    }

    public boolean isShowSchema() {
        return this.showSchema;
    }

    public void setShowSchema(boolean showSchema) {
        this.showSchema = showSchema;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public void setNumTerms(int count) {
        this.numTerms = count;
    }

    public void setIncludeIndexFieldFlags(boolean shouldInclude) {
        this.includeIndexFieldFlags = shouldInclude;
    }

    public boolean getIncludeIndexFieldFlags() {
        return this.includeIndexFieldFlags;
    }

    @Override
    protected LukeResponse createResponse(SolrClient client) {
        return new LukeResponse();
    }

    @Override
    public SolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (this.fields != null && this.fields.size() > 0) {
            params.add("fl", this.fields.toArray(new String[0]));
        }
        if (this.numTerms >= 0) {
            params.add("numTerms", "" + this.numTerms);
        }
        if (this.showSchema) {
            params.add("show", "schema");
        }
        if (this.includeIndexFieldFlags != null) {
            params.add("includeIndexFieldFlags", this.includeIndexFieldFlags.toString());
        }
        return params;
    }

    @Override
    public String getRequestType() {
        return SolrRequest.SolrRequestType.ADMIN.toString();
    }
}

