/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.associations;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import schemacrawler.ermodel.associations.ImplicitColumnReference;
import schemacrawler.ermodel.associations.TableConstraintColumnWrapper;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Identifiers;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.TableReference;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Utility;

public final class ImplicitAssociation
implements TableReference {
    private static final long serialVersionUID = -246830743604473724L;
    private static final String REMARKS_ATTRIBUTE = "REMARKS";
    private final String name;
    private transient String fullName;
    private final Schema schema;
    private transient NamedObjectKey key;
    private final Table fkTable;
    private final Table pkTable;
    private final ImplicitColumnReference columnReference;
    private final TableConstraintColumn tableConstraintColumn;
    private final boolean isSelfReferencing;
    private final boolean isOptional;
    private final Map<String, Object> attributeMap;

    public ImplicitAssociation(ImplicitColumnReference columnReference) {
        this.columnReference = Objects.requireNonNull(columnReference, "No column reference provided");
        Column fkColumn = columnReference.getForeignKeyColumn();
        Column pkColumn = columnReference.getPrimaryKeyColumn();
        this.fkTable = (Table)fkColumn.getParent();
        this.pkTable = (Table)pkColumn.getParent();
        this.name = "SCHCRWLR_%1$08X_%2$08X".formatted(this.fkTable.getFullName().hashCode(), this.pkTable.getFullName().hashCode());
        this.schema = this.fkTable.getSchema();
        this.tableConstraintColumn = TableConstraintColumnWrapper.createConstrainedColumn(fkColumn, this);
        this.isSelfReferencing = this.getParent().equals(this.pkTable);
        this.isOptional = !MetaDataUtility.isPartial(fkColumn) && fkColumn.isNullable();
        this.attributeMap = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        if (obj instanceof TableReference) {
            TableReference other = (TableReference)obj;
            List<ColumnReference> thisColumnReferences = this.getColumnReferences();
            List<ColumnReference> otherColumnReferences = other.getColumnReferences();
            return CollectionsUtility.compareLists(thisColumnReferences, otherColumnReferences);
        }
        if (obj instanceof NamedObject) {
            NamedObject other = obj;
            return this.key().compareTo(other.key());
        }
        return -1;
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) throws ClassCastException {
        return (T)this.attributeMap.getOrDefault(name, defaultValue);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Map.copyOf(this.attributeMap);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return List.of(this.columnReference);
    }

    @Override
    public List<TableConstraintColumn> getConstrainedColumns() {
        return List.of(this.tableConstraintColumn);
    }

    @Override
    public String getDefinition() {
        return "";
    }

    @Override
    public Table getForeignKeyTable() {
        return this.fkTable;
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Table getParent() {
        return this.getForeignKeyTable();
    }

    @Override
    public Table getPrimaryKeyTable() {
        return this.pkTable;
    }

    @Override
    public String getRemarks() {
        Object remarks = this.attributeMap.get(REMARKS_ATTRIBUTE);
        if (remarks == null) {
            return "";
        }
        return String.valueOf(remarks);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public TableConstraintType getType() {
        return TableConstraintType.unknown;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    @Override
    public boolean hasDefinition() {
        return false;
    }

    public int hashCode() {
        return this.columnReference.hashCode();
    }

    @Override
    public boolean hasRemarks() {
        return this.hasAttribute(REMARKS_ATTRIBUTE) && !Utility.isBlank(this.getRemarks());
    }

    @Override
    public boolean isDeferrable() {
        return false;
    }

    @Override
    public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean isParentPartial() {
        return MetaDataUtility.isPartial(this.fkTable);
    }

    @Override
    public boolean isSelfReferencing() {
        return this.isSelfReferencing;
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.getColumnReferences().iterator();
    }

    @Override
    public NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    @Override
    public <T> Optional<T> lookupAttribute(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getAttribute(name));
    }

    @Override
    public void removeAttribute(String name) {
        if (!Utility.isBlank(name)) {
            this.attributeMap.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    @Override
    public void setRemarks(String remarks) {
        this.setAttribute(REMARKS_ATTRIBUTE, Utility.trimToEmpty(remarks));
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public void withQuoting(Identifiers identifiers) {
        if (identifiers == null) {
            return;
        }
        this.fullName = identifiers.quoteFullName(this);
    }

    private void buildFullName() {
        if (this.fullName != null) {
            return;
        }
        this.fullName = Identifiers.STANDARD.quoteFullName(this);
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = this.schema.key().with(this.name);
    }
}

