/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TablePointer;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Utility;

class MutableIndex
extends AbstractDependantObject<Table>
implements Index {
    private static final long serialVersionUID = 4051326747138079028L;
    private final NamedObjectList<MutableIndexColumn> columns = new NamedObjectList();
    private String definition = "";
    private long cardinality;
    private IndexType indexType = IndexType.unknown;
    private boolean isUnique;
    private long pages;
    private String filterCondition = "";

    MutableIndex(Table parent, String name) {
        super(new TablePointer(parent), name);
    }

    @Override
    public final int compareTo(NamedObject obj) {
        if (obj == null || !(obj instanceof Index)) {
            return -1;
        }
        Index that = (Index)obj;
        int compareTo = 0;
        if (compareTo == 0) {
            List<IndexColumn> thisColumns = this.getColumns();
            List<IndexColumn> thatColumns = that.getColumns();
            compareTo = CollectionsUtility.compareLists(thisColumns, thatColumns);
        }
        if (compareTo == 0 && this.isUnique != that.isUnique()) {
            int n = compareTo = this.isUnique ? -1 : 1;
        }
        if (compareTo == 0) {
            compareTo = this.indexType.ordinal() - that.getIndexType().ordinal();
        }
        if (compareTo == 0) {
            compareTo = super.compareTo(obj);
        }
        return compareTo;
    }

    @Override
    public final long getCardinality() {
        return this.cardinality;
    }

    @Override
    public final List<IndexColumn> getColumns() {
        return List.copyOf(this.columns.values());
    }

    @Override
    public final String getDefinition() {
        return this.definition;
    }

    @Override
    public final String getFilterCondition() {
        return this.filterCondition;
    }

    @Override
    public final IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public final long getPages() {
        return this.pages;
    }

    @Override
    public final IndexType getType() {
        return this.getIndexType();
    }

    @Override
    public final boolean hasDefinition() {
        return !Utility.isBlank(this.definition);
    }

    @Override
    public final boolean hasFilterCondition() {
        return !Utility.isBlank(this.filterCondition);
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public final Iterator<IndexColumn> iterator() {
        return this.getColumns().iterator();
    }

    public final Optional<MutableIndexColumn> lookupColumn(String name) {
        return this.columns.lookup((NamedObject)this.getParent(), name);
    }

    final void addColumn(MutableIndexColumn column) {
        this.columns.add(column);
    }

    final void setCardinality(long cardinality) {
        this.cardinality = cardinality;
    }

    final void setDefinition(String definition) {
        if (!this.hasDefinition() && !Utility.isBlank(definition)) {
            this.definition = definition;
        }
    }

    final void setFilterCondition(String filterCondition) {
        if (!this.hasFilterCondition() && !Utility.isBlank(filterCondition)) {
            this.filterCondition = filterCondition;
        }
    }

    final void setIndexType(IndexType indexType) {
        this.indexType = Objects.requireNonNull(indexType, "Null index type");
    }

    final void setPages(long pages) {
        this.pages = pages;
    }

    final void setUnique(boolean unique) {
        this.isUnique = unique;
    }
}

