/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models;

import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.Constants;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.IClassification;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PDQBaseModel;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PackageClassification;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PackageModel;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.StatementClassification;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.StatementModel;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.repository.HTMLTemplateLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PackageContainer {
    private PackageModel pkg = null;
    private Map<IClassification, Collection<StatementModel>> stmtClassify = new LinkedHashMap<IClassification, Collection<StatementModel>>();
    private PackageClassification pkgCategory = null;
    private Integer sqlAddedCount;
    private Integer sqlChangedCount;
    private Integer sqlUnchangedCount;
    private Integer sqlRemovedCount;

    protected PackageContainer(PackageModel packageModel, PackageClassification packageClassification) {
        this.stmtClassify.put(StatementClassification.INCLUDED_SQL, new ArrayList());
        switch (packageClassification) {
            case CHANGEDMETADATA_PACKAGES: 
            case REBIND_PACKAGES: {
                this.stmtClassify.put(StatementClassification.DELETED_SQL, new ArrayList());
                this.stmtClassify.put(StatementClassification.CHANGEDMETADATA_SQL, new ArrayList());
                this.stmtClassify.put(StatementClassification.UNCHANGEDMETADATA_SQL, new ArrayList());
                break;
            }
        }
        this.pkg = packageModel;
        this.pkgCategory = packageClassification;
    }

    protected PackageModel getPackageModel() {
        return this.pkg;
    }

    protected PackageClassification getPackageCategory() {
        return this.pkgCategory;
    }

    protected String getSqlAddedCount() {
        if (this.sqlAddedCount == null) {
            switch (this.pkgCategory) {
                case CHANGEDMETADATA_PACKAGES: 
                case REBIND_PACKAGES: 
                case NEW_PACKAGES: {
                    this.sqlAddedCount = this.stmtClassify.get(StatementClassification.INCLUDED_SQL).size();
                    break;
                }
                default: {
                    this.sqlAddedCount = 0;
                }
            }
        }
        return this.sqlAddedCount.toString();
    }

    protected String getSqlRemovedCount() {
        if (this.sqlRemovedCount == null) {
            switch (this.pkgCategory) {
                case DELETED_PACKAGES: {
                    this.sqlRemovedCount = this.stmtClassify.get(StatementClassification.INCLUDED_SQL).size();
                    break;
                }
                case CHANGEDMETADATA_PACKAGES: 
                case REBIND_PACKAGES: {
                    this.sqlRemovedCount = this.stmtClassify.get(StatementClassification.DELETED_SQL).size();
                    break;
                }
                default: {
                    this.sqlRemovedCount = 0;
                }
            }
        }
        return this.sqlRemovedCount.toString();
    }

    protected String getSqlChangedCount() {
        if (this.sqlChangedCount == null) {
            switch (this.pkgCategory) {
                case CHANGEDMETADATA_PACKAGES: 
                case REBIND_PACKAGES: {
                    this.sqlChangedCount = this.stmtClassify.get(StatementClassification.CHANGEDMETADATA_SQL).size();
                    break;
                }
                default: {
                    this.sqlChangedCount = 0;
                }
            }
        }
        return this.sqlChangedCount.toString();
    }

    protected String getSqlUnchangedCount() {
        if (this.sqlUnchangedCount == null) {
            switch (this.pkgCategory) {
                case REBIND_PACKAGES: 
                case UNCHANGED_PACKAGES: {
                    if (this.stmtClassify.get(StatementClassification.UNCHANGEDMETADATA_SQL) != null) {
                        this.sqlUnchangedCount = this.stmtClassify.get(StatementClassification.UNCHANGEDMETADATA_SQL).size();
                        break;
                    }
                    if (this.stmtClassify.get(StatementClassification.INCLUDED_SQL) != null) {
                        this.sqlUnchangedCount = this.stmtClassify.get(StatementClassification.INCLUDED_SQL).size();
                        break;
                    }
                    this.sqlUnchangedCount = 0;
                    break;
                }
                default: {
                    this.sqlUnchangedCount = 0;
                }
            }
        }
        return this.sqlUnchangedCount.toString();
    }

    protected String isBindNeeded() {
        String string;
        switch (this.pkgCategory) {
            case REBIND_PACKAGES: 
            case NEW_PACKAGES: {
                string = Constants.getYesOrNoValue(this.pkg.isBindable());
                break;
            }
            case DELETED_PACKAGES: {
                string = Messages.getText("MSG_DIFFERENCE_REPORT_N_A", new Object[0]);
                break;
            }
            default: {
                string = Constants.getYesOrNoValue(false);
            }
        }
        return string;
    }

    protected String getBindExplain() {
        String string = null;
        String string2 = this.isBindNeeded();
        if (!this.pkg.isBindable() && Messages.getText("MSG_DIFFERENCE_REPORT_NO", new Object[0]).equalsIgnoreCase(string2)) {
            string = Messages.getText("MSG_DIFFERENCE_REPORT_BIND_EXPLAIN", new Object[0]);
        }
        return string;
    }

    protected void classifyStatement(PDQBaseModel.StatementSetModel statementSetModel, String string, String string2, String string3, String string4) {
        StatementModel statementModel = new StatementModel(string, string2, string3, string4);
        switch (this.pkgCategory) {
            case NEW_PACKAGES: 
            case UNCHANGED_PACKAGES: {
                this.addToCategory(StatementClassification.INCLUDED_SQL, statementModel);
                break;
            }
            case CHANGEDMETADATA_PACKAGES: 
            case REBIND_PACKAGES: {
                Collection<StatementModel> collection = statementSetModel.getStatements();
                boolean bl2 = true;
                for (StatementModel statementModel2 : collection) {
                    if (!statementModel2.getSql().equals(string)) continue;
                    if (statementModel2.getLastUpdated().equals(string2)) {
                        this.addToCategory(StatementClassification.UNCHANGEDMETADATA_SQL, statementModel);
                    } else {
                        this.addToCategory(StatementClassification.CHANGEDMETADATA_SQL, statementModel);
                    }
                    bl2 = false;
                    break;
                }
                if (!bl2) break;
                this.addToCategory(StatementClassification.INCLUDED_SQL, statementModel);
                break;
            }
            default: {
                String string5 = Messages.getText("MSG_DIFFERENCE_REPORT_UNABLE_TO_CLASSIFY_STMT", string, statementSetModel.getPackageModel().getPkgNameRoot());
                throw new RuntimeException(string5);
            }
        }
    }

    protected void addToCategory(IClassification iClassification, Object object) {
        this.stmtClassify.get(iClassification).add((StatementModel)object);
    }

    protected boolean isSqlInGroup(IClassification iClassification, String string) {
        boolean bl2 = false;
        Collection<StatementModel> collection = this.stmtClassify.get(iClassification);
        for (StatementModel statementModel : collection) {
            if (!statementModel.getSql().equals(string)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    protected StringBuilder printHtml(HTMLTemplateLoader hTMLTemplateLoader) throws Exception {
        Object object;
        Set<IClassification> set = this.stmtClassify.keySet();
        StringBuilder stringBuilder = this.printTableSubsection(hTMLTemplateLoader);
        StringBuilder stringBuilder2 = this.pkg.printHtml(hTMLTemplateLoader);
        StringBuilder stringBuilder3 = this.pkgHeaderRow(hTMLTemplateLoader);
        StringBuilder stringBuilder4 = new StringBuilder();
        for (IClassification object22 : set) {
            object = this.stmtClassify.get(object22);
            Iterator<StatementModel> iterator = object.iterator();
            while (iterator.hasNext()) {
                StatementModel statementModel = iterator.next();
                StringBuilder stringBuilder5 = this.pkgTableDataRow(hTMLTemplateLoader, statementModel, (StatementClassification)object22);
                stringBuilder4.append((CharSequence)stringBuilder5);
            }
        }
        String string = this.pkg.getPacakgeId();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("title", this.pkg.getPkgNameRoot());
        hashtable.put("id", string);
        hashtable.put("table", Constants.getTableHtml(hTMLTemplateLoader, stringBuilder3, stringBuilder4).toString());
        hashtable.put("sub_sec", stringBuilder.toString());
        hashtable.put("sub_desc", stringBuilder2.toString());
        hashtable.put("backtotop_title", Messages.getText("MSG_DIFFERENCE_REPORT_BACKTOTOP", new Object[0]));
        hashtable.put("backtotop_id", "BackToTop");
        object = new StringBuilder();
        ((StringBuilder)object).append(hTMLTemplateLoader.load("tableLayout", hashtable));
        return object;
    }

    private StringBuilder pkgHeaderRow(HTMLTemplateLoader hTMLTemplateLoader) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        hashtable.put("width", "5");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_SECTION_NUMBER", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "55");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_SQL", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_EXECUTION_COUNT", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "20");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_LAST_USED", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_STATUS", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.clear();
        hashtable.put("class", "trHeader");
        hashtable.put("table_row", stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder().append(hTMLTemplateLoader.load("tableRow", hashtable));
        return stringBuilder2;
    }

    private StringBuilder pkgTableDataRow(HTMLTemplateLoader hTMLTemplateLoader, StatementModel statementModel, StatementClassification statementClassification) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)statementModel.printHtml(hTMLTemplateLoader));
        hashtable.put("column_data", statementClassification.getChangeValue(this.pkgCategory));
        stringBuilder.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
        hashtable.clear();
        hashtable.put("class", "trCellWhite");
        hashtable.put("table_row", stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder().append(hTMLTemplateLoader.load("tableRow", hashtable));
        return stringBuilder2;
    }

    private StringBuilder printTableSubsection(HTMLTemplateLoader hTMLTemplateLoader) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_COLLECTION", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", this.pkg.getCollectionId()));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_VERSION", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", this.pkg.getDbPkgVersion()));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_STATUS", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", this.pkgCategory.getChangeValue()));
        stringBuilder3.append(String.format("%s:<br />", Constants.getRefNameHtml(this.pkg.getPacakgeDescriptionSectionId(), Messages.getText("MSG_DIFFERENCE_REPORT_BIND_REQUIRED", new Object[0]))));
        String string = this.isBindNeeded();
        String string2 = this.getBindExplain();
        if (string2 != null) {
            string = string + " (" + string2 + ")";
        }
        stringBuilder4.append(String.format("%s<br />", string));
        stringBuilder3.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_ADDED", new Object[0])));
        stringBuilder4.append(String.format("%s<br />", this.getSqlAddedCount()));
        stringBuilder3.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_CHANGED", new Object[0])));
        stringBuilder4.append(String.format("%s<br />", this.getSqlChangedCount()));
        stringBuilder3.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_REMOVED", new Object[0])));
        stringBuilder4.append(String.format("%s<br />", this.getSqlRemovedCount()));
        stringBuilder3.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_UNCHANGED", new Object[0])));
        stringBuilder4.append(String.format("%s<br />", this.getSqlUnchangedCount()));
        hashtable.put("headers1", stringBuilder.toString());
        hashtable.put("values1", stringBuilder2.toString());
        hashtable.put("headers2", stringBuilder3.toString());
        hashtable.put("values2", stringBuilder4.toString());
        hashtable.put("div_class", "subSection");
        hashtable.put("table_class", "subSecTable");
        hashtable.put("td_class1", "sub1DescrBold");
        hashtable.put("td_class2", "sub1Descr");
        StringBuilder stringBuilder5 = new StringBuilder();
        stringBuilder5.append(hTMLTemplateLoader.load("packageTableSubsection", hashtable));
        return stringBuilder5;
    }
}

