/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=BackendNativePointerLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=InteropLibrary.class)})
final class NativePointer
implements TruffleObject {
    static final NativePointer NULL = new NativePointer(0L);
    final long nativePointer;

    NativePointer(long nativePointer) {
        this.nativePointer = nativePointer;
    }

    static Object create(long nativePointer) {
        return new NativePointer(nativePointer);
    }

    public String toString() {
        return String.valueOf(this.nativePointer);
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer;
    }

    @ExportMessage
    boolean isNull() {
        return this.nativePointer == 0L;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return PanamaNFILanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "NativePointer(" + this.nativePointer + ")";
    }
}

