/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

class RestrictedLock
implements Lock {
    private final ReentrantLock wrappedLock;
    private final Condition unrestrictedCondition;
    private volatile Mode lockMode = Mode.UNRESTRICTED;
    private final Queue<AsyncTask> taskQueue = new ConcurrentLinkedQueue<AsyncTask>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    static RestrictedLock newInstance(ReentrantLock wrappedLock) {
        return new RestrictedLock(wrappedLock);
    }

    private RestrictedLock(ReentrantLock wrappedLock) {
        this.wrappedLock = wrappedLock;
        this.unrestrictedCondition = wrappedLock.newCondition();
    }

    @Override
    public void unlock() {
        this.wrappedLock.unlock();
        if (!this.wrappedLock.isHeldByCurrentThread()) {
            this.dequeueTask();
        }
    }

    private void dequeueTask() {
        if (this.lockMode != Mode.UNRESTRICTED) {
            return;
        }
        AsyncTask task = this.taskQueue.poll();
        if (task != null) {
            task.executor.execute(() -> this.lockAsync(task.runnable, task.executor));
        }
    }

    @Override
    public final void lock() {
        this.wrappedLock.lock();
        while (this.lockMode == Mode.RESTRICTED) {
            this.unrestrictedCondition.awaitUninterruptibly();
        }
    }

    @Override
    public final void lockInterruptibly() throws InterruptedException {
        this.wrappedLock.lockInterruptibly();
        if (this.lockMode == Mode.RESTRICTED) {
            try {
                do {
                    this.unrestrictedCondition.await();
                } while (this.lockMode == Mode.RESTRICTED);
            }
            catch (InterruptedException interruptedException) {
                this.wrappedLock.unlock();
                throw interruptedException;
            }
        }
    }

    @Override
    public final boolean tryLock() {
        if (!this.wrappedLock.tryLock()) {
            return false;
        }
        if (this.lockMode == Mode.RESTRICTED) {
            this.unlock();
            return false;
        }
        return true;
    }

    @Override
    public final boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        boolean isSignalled;
        long startTime = System.nanoTime();
        if (!this.wrappedLock.tryLock(time, unit)) {
            return false;
        }
        if (this.lockMode == Mode.RESTRICTED && !(isSignalled = this.unrestrictedCondition.await(unit.toNanos(time) - (System.nanoTime() - startTime), TimeUnit.NANOSECONDS))) {
            this.unlock();
            return false;
        }
        return true;
    }

    @Override
    public final Condition newCondition() {
        return this.wrappedLock.newCondition();
    }

    final void enterRestrictedMode() {
        this.wrappedLock.lock();
        try {
            this.lockMode = Mode.RESTRICTED;
        }
        finally {
            this.wrappedLock.unlock();
        }
    }

    final void exitRestrictedMode() {
        this.wrappedLock.lock();
        try {
            this.lockMode = Mode.UNRESTRICTED;
            this.unrestrictedCondition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    final void runUnrestricted(Runnable runnable) {
        this.callUnrestricted(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T, E extends Exception> T callUnrestricted(Task<T, E> task) throws E {
        this.wrappedLock.lock();
        if (this.lockMode == Mode.RESTRICTED) {
            this.lockMode = Mode.RESTRICTED_EXECUTING;
            T t2 = task.call();
            return t2;
            finally {
                if (this.lockMode == Mode.RESTRICTED_EXECUTING) {
                    this.lockMode = Mode.RESTRICTED;
                }
            }
        }
        T t3 = task.call();
        return t3;
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockAsync(Runnable task, Executor executor) {
        if (this.tryLock()) {
            try {
                task.run();
            }
            finally {
                this.unlock();
            }
        }
        AsyncTask asyncTask = new AsyncTask(task, executor);
        this.taskQueue.add(asyncTask);
        if (this.tryLock()) {
            try {
                if (this.taskQueue.remove(asyncTask)) {
                    task.run();
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    static {
        try {
            $$$methodRef$$$15 = RestrictedLock.class.getDeclaredConstructor(ReentrantLock.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = RestrictedLock.class.getDeclaredMethod("lambda$dequeueTask$0", AsyncTask.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = RestrictedLock.class.getDeclaredMethod("lambda$runUnrestricted$1", Runnable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = RestrictedLock.class.getDeclaredMethod("lockAsync", Runnable.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = RestrictedLock.class.getDeclaredMethod("callUnrestricted", Task.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = RestrictedLock.class.getDeclaredMethod("runUnrestricted", Runnable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = RestrictedLock.class.getDeclaredMethod("exitRestrictedMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = RestrictedLock.class.getDeclaredMethod("enterRestrictedMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = RestrictedLock.class.getDeclaredMethod("newCondition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = RestrictedLock.class.getDeclaredMethod("tryLock", Long.TYPE, TimeUnit.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = RestrictedLock.class.getDeclaredMethod("tryLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = RestrictedLock.class.getDeclaredMethod("lockInterruptibly", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = RestrictedLock.class.getDeclaredMethod("lock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = RestrictedLock.class.getDeclaredMethod("dequeueTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = RestrictedLock.class.getDeclaredMethod("unlock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = RestrictedLock.class.getDeclaredMethod("newInstance", ReentrantLock.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static final class AsyncTask {
        final Runnable runnable;
        final Executor executor;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        private AsyncTask(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        static {
            try {
                $$$methodRef$$$0 = AsyncTask.class.getDeclaredConstructor(Runnable.class, Executor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    @FunctionalInterface
    static interface Task<T, E extends Exception> {
        public T call() throws E;
    }

    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode UNRESTRICTED;
        public static final /* enum */ Mode RESTRICTED;
        public static final /* enum */ Mode RESTRICTED_EXECUTING;
        private static final /* synthetic */ Mode[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        static {
            try {
                $$$methodRef$$$2 = Mode.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Mode.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Mode.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            UNRESTRICTED = new Mode();
            RESTRICTED = new Mode();
            RESTRICTED_EXECUTING = new Mode();
            $VALUES = new Mode[]{UNRESTRICTED, RESTRICTED, RESTRICTED_EXECUTING};
        }
    }
}

