/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptionsOptionDescriptors;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

@Option.Group(value={"python"})
public final class PythonOptions {
    private static final String J_STRING_LIST_SEPARATOR = "\ud83c\udfc6";
    private static final TruffleString T_STRING_LIST_SEPARATOR = PythonUtils.tsLiteral("\ud83c\udfc6");
    public static final boolean AUTOMATIC_ASYNC_ACTIONS = !"false".equalsIgnoreCase(System.getProperty("python.AutomaticAsyncActions"));
    public static final boolean ENABLE_BYTECODE_DSL_INTERPRETER = Boolean.getBoolean("python.EnableBytecodeDSLInterpreter");
    private static final OptionType<TruffleString> TS_OPTION_TYPE = new OptionType("graal.python.TruffleString", PythonUtils::toTruffleStringUncached);
    @Option(category=OptionCategory.EXPERT, help="Set the home of Python. Equivalent of GRAAL_PYTHONHOME env variable. Determines default values for the CoreHome, StdLibHome, SysBasePrefix, SysPrefix.", usageSyntax="<path>", stability=OptionStability.STABLE)
    public static final OptionKey<String> PythonHome = new OptionKey((Object)"");
    @Option(category=OptionCategory.USER, help="Set the location of sys.prefix. Overrides any environment variables or Java options.", usageSyntax="<path>", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> SysPrefix = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.EXPERT, help="Set the location of sys.base_prefix. Overrides any environment variables or Java options.", usageSyntax="<path>", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> SysBasePrefix = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.USER, help="Set the location of what is usually lib/graalpy<graalvm_major>.<graalvm_minor>. Overrides any environment variables or Java options.", usageSyntax="<path>", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> CoreHome = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.USER, help="Set the location of lib/python3.12. Overrides any environment variables or Java options.", usageSyntax="<path>", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> StdLibHome = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -i flag. Inspect interactively after running a script.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> InspectFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -q flag. Don't  print version and copyright messages on interactive startup.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> QuietFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -S flag. Don't imply 'import site' on initialization.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> NoSiteFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -s flag. Don't add user site directory to sys.path.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> NoUserSiteFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -E flag. Ignore PYTHON* environment variables.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> IgnoreEnvironmentFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to setting the PYTHONPATH environment variable for the standard launcher. ':'-separated list of directories prefixed to the default module search path.", usageSyntax="<path>[:<path>]", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> PythonPath = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @EngineOption
    @Option(category=OptionCategory.USER, help="Equivalent to setting the PYTHONIOENCODING environment variable for the standard launcher.", usageSyntax="<Encoding>[:<errors>]", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> StandardStreamEncoding = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.USER, help="Remove assert statements and any code conditional on the value of __debug__.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> PythonOptimizeFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -v flag. Turn on verbose mode.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> VerboseFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -u flag. Force stdout and stderr to be unbuffered.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> UnbufferedIO = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -I flag. Isolate from the users environment by not adding the cwd to the path", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> IsolateFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -P flag. Don't prepend a potentially unsafe path to sys.path", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> SafePathFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -X warn_default_encoding flag. Enable opt-in EncodingWarning for 'encoding=None'", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> WarnDefaultEncodingFlag = new OptionKey((Object)false);
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -X int_max_str_digits option.", stability=OptionStability.STABLE)
    public static final OptionKey<Integer> IntMaxStrDigits = new OptionKey((Object)4300, new OptionType("IntMaxStrDigits", input -> {
        try {
            int value = Integer.parseInt(input);
            if (value == 0 || value >= 640) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format("IntMaxStrDigits: invalid limit; must be >= %d or 0 for unlimited.", 640));
    }));
    @Option(category=OptionCategory.USER, help="Equivalent to the Python -B flag. Don't write bytecode files.", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> DontWriteBytecodeFlag = new OptionKey((Object)true);
    @Option(category=OptionCategory.USER, help="If this is set, GraalPy will write .pyc files in a mirror directory tree at this path, instead of in __pycache__ directories within the source tree. Equivalent to setting the PYTHONPYCACHEPREFIX environment variable for the standard launcher.", usageSyntax="<path>", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> PyCachePrefix = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.USER, help="Equivalent to setting the PYTHONWARNINGS environment variable for the standard launcher.", usageSyntax="<action>[:<message>[:<category>[:<module>[:<line>]]]][,<action>[:<message>[:<category>[:<module>[:<line>]]]]]", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> WarnOptions = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.USER, help="Equivalent to setting PYTHONHASHSEED environment variable", usageSyntax="random|[0,4294967295]", stability=OptionStability.STABLE)
    public static final OptionKey<Optional<Integer>> HashSeed = new OptionKey(Optional.empty(), new OptionType("HashSeed", input -> {
        if ("random".equals(input)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseUnsignedInt(input));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("PYTHONHASHSEED must be \"random\" or an integer in range [0; 4294967295]");
        }
    }));
    @EngineOption
    @Option(category=OptionCategory.USER, help="Choose the backend for the POSIX module.", usageSyntax="java|native", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> PosixModuleBackend = new OptionKey((Object)StringLiterals.T_JAVA, TS_OPTION_TYPE);
    @EngineOption
    @Option(category=OptionCategory.USER, help="Choose the backend for the Sha3 module.", usageSyntax="java|native", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> Sha3ModuleBackend = new OptionKey((Object)StringLiterals.T_JAVA, TS_OPTION_TYPE);
    @EngineOption
    @Option(category=OptionCategory.USER, help="Choose the backend for the Zlib, Bz2, and LZMA modules.", usageSyntax="java|native", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> CompressionModulesBackend = new OptionKey((Object)StringLiterals.T_JAVA, TS_OPTION_TYPE);
    @Option(category=OptionCategory.USER, help="Install default signal handlers on startup", usageSyntax="true|false", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> InstallSignalHandlers = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, help="Sets the language and territory, which will be used for initial locale. Format: 'language[_territory]', e.g., 'en_GB'. Leave empty to use the JVM default locale.", stability=OptionStability.STABLE)
    public static final OptionKey<String> InitialLocale = new OptionKey((Object)"");
    @Option(category=OptionCategory.USER, help="Value of the --check-hash-based-pycs command line option- 'default' means the 'check_source' flag in hash-based pycs  determines invalidation- 'always' causes the interpreter to hash the source file for  invalidation regardless of value of 'check_source' bit- 'never' causes the interpreter to always assume hash-based pycs are  validThe default value is 'default'.See PEP 552 'Deterministic pycs' for more details.", usageSyntax="default|always|never", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> CheckHashPycsMode = new OptionKey((Object)StringLiterals.T_DEFAULT, TS_OPTION_TYPE);
    @Option(category=OptionCategory.INTERNAL, help="Set the location of C API home. Overrides any environment variables or Java options.", usageSyntax="<path>", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> CAPI = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @EngineOption
    @Option(category=OptionCategory.INTERNAL, help="Expose internal sources as normal sources, so they will show up in the debugger and stacks", usageSyntax="true|false")
    public static final OptionKey<Boolean> ExposeInternalSources = new OptionKey((Object)false);
    @EngineOption
    @Option(category=OptionCategory.INTERNAL, help="Eagerly initialize source sections.", usageSyntax="true|false")
    public static final OptionKey<Boolean> ForceInitializeSourceSections = new OptionKey((Object)false);
    @EngineOption
    @Option(category=OptionCategory.INTERNAL, help="Print the Java stacktrace for exceptions. Possible modes:    0   Do not print any Java stacktraces.    1   Print Java stacktrace for Java exceptions only (default).    2   Print Java stacktrace for Python exceptions only (ATTENTION: this will have a notable performance impact).    3   Combines 1 and 2.", usageSyntax="0|1|2|3")
    public static final OptionKey<Integer> WithJavaStacktrace = new OptionKey((Object)1);
    @Option(category=OptionCategory.INTERNAL, usageSyntax="true|false", help="")
    public static final OptionKey<Boolean> CatchGraalPythonExceptionForUnitTesting = new OptionKey((Object)false);
    @EngineOption
    @Option(category=OptionCategory.INTERNAL, usageSyntax="true|false", help="Enable catching all Exceptions in generic try-catch statements.")
    public static final OptionKey<Boolean> CatchAllExceptions = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Prints path to parsed files")
    public static final OptionKey<Boolean> ParserLogFiles = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<numFiles>", help="Prints parser time statistics after number of parsed files, set by this option. 0 or <0 means no statistics are printed.")
    public static final OptionKey<Integer> ParserStatistics = new OptionKey((Object)0);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="<maxDepth>", help="")
    public static final OptionKey<Integer> AttributeAccessInlineCacheMaxDepth = new OptionKey((Object)5);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="<maxDepth>", help="")
    public static final OptionKey<Integer> CallSiteInlineCacheMaxDepth = new OptionKey((Object)4);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="<limit>", help="")
    public static final OptionKey<Integer> VariableArgumentReadUnrollingLimit = new OptionKey((Object)5);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="<limit>", help="")
    public static final OptionKey<Integer> VariableArgumentInlineCacheLimit = new OptionKey((Object)3);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="<limit>", help="")
    public static final OptionKey<Integer> NodeRecursionLimit = new OptionKey((Object)1);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="")
    public static final OptionKey<Boolean> ForceInlineGeneratorCalls = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Force to automatically import site.py module.", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> ForceImportSite = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="This option is set by the Python launcher to tell the language it can print exceptions directly", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> AlwaysRunExcepthook = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, usageSyntax="<path>", help="Used by the launcher to pass the path to be executed", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> InputFilePath = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Use the optimized TRegex engine. Default true")
    public static final OptionKey<Boolean> WithTRegex = new OptionKey((Object)true);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Use the CPython sre engine as a fallback to the TRegex engine.")
    public static final OptionKey<Boolean> TRegexUsesSREFallback = new OptionKey((Object)true);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Switch on/off using lazy strings for performance reasons. Default true.")
    public static final OptionKey<Boolean> LazyStrings = new OptionKey((Object)true);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Enable forced splitting (of builtins). Default false.")
    public static final OptionKey<Boolean> EnableForcedSplits = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Set by the launcher if an interactive console is used to run Python.")
    public static final OptionKey<Boolean> TerminalIsInteractive = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<width>", help="Set by the launcher to the terminal width.")
    public static final OptionKey<Integer> TerminalWidth = new OptionKey((Object)80);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<height>", help="Set by the launcher to the terminal height.")
    public static final OptionKey<Integer> TerminalHeight = new OptionKey((Object)25);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<path>", help="The sys.executable path. Set by the launcher, but may need to be overridden in certain special situations.", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> Executable = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<path>", help="The sys._base_executable path. Set by the launcher, but may need to be overridden in certain special situations.", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> BaseExecutable = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<cmdPart>[\ud83c\udfc6<cmdPart>]", help="The executed command list as string joined by the executable list separator char. This must always correspond to the real, valid command list used to run GraalPy.")
    public static final OptionKey<TruffleString> ExecutableList = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.EXPERT, usageSyntax="", help="Option used by the venvlauncher to pass on the launcher target command", stability=OptionStability.STABLE)
    public static final OptionKey<TruffleString> VenvlauncherCommand = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Determines wether context startup tries to re-use previously cached sources of the core library.")
    public static final OptionKey<Boolean> WithCachedSources = new OptionKey((Object)true);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Embedder option: what to print in response to PythonLanguage#toString.")
    public static final OptionKey<Boolean> UseReprForPrintString = new OptionKey((Object)true);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="<limit>", help="Stop inlining of builtins if caller's cumulative tree size would exceed this limit")
    public static final OptionKey<Integer> BuiltinsInliningMaxCallerSize = new OptionKey((Object)2500);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Disable weakref callback processing, signal handling, and other periodic async actions.")
    public static final OptionKey<Boolean> NoAsyncActions = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Propagate append operations to lists created as literals back to where they were created, to inform overallocation to avoid having to grow them later.")
    public static final OptionKey<Boolean> OverallocateLiteralLists = new OptionKey((Object)true);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Forces AST sharing for inner contexts.")
    public static final OptionKey<Boolean> ForceSharingForInnerContexts = new OptionKey((Object)true);
    @Option(category=OptionCategory.USER, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false", help="Whether the context should isolate its loading of C extension modules. This allows more than one context to access C extensions. Note that all contexts in the operating system process must set this option to true to cooperatively allow this feature to work.")
    public static final OptionKey<Boolean> IsolateNativeModules = new OptionKey((Object)false);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Whether the Python GC should be enabled (default) or not.")
    public static final OptionKey<Boolean> PythonGC = new OptionKey((Object)true);
    @Option(category=OptionCategory.INTERNAL, usageSyntax="true|false", help="Whether the background GC task should be enabled (default) or not.")
    public static final OptionKey<Boolean> BackgroundGCTask = new OptionKey((Object)true);
    @Option(category=OptionCategory.INTERNAL, usageSyntax="<time>", help="Specifies the interval (ms) for the background GC task to monitor the resident set size (RSS)")
    public static final OptionKey<Integer> BackgroundGCTaskInterval = new OptionKey((Object)1000);
    @Option(category=OptionCategory.INTERNAL, usageSyntax="<limit>", help="The percentage increase in RSS memory between System.gc() calls. Low percentage will trigger System.gc() more often. (default: 30).")
    public static final OptionKey<Integer> BackgroundGCTaskThreshold = new OptionKey((Object)30);
    @Option(category=OptionCategory.INTERNAL, usageSyntax="<megabytes>", help="The minimum RSS memory (in megabytes) to start calling System.gc(). (default: 4 GB).")
    public static final OptionKey<Integer> BackgroundGCTaskMinimum = new OptionKey((Object)4096);
    @EngineOption
    @Option(category=OptionCategory.USER, usageSyntax="true|false", help="Emulate some Jython features that can cause performance degradation", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> EmulateJython = new OptionKey((Object)false);
    @EngineOption
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Enable tracing of native memory (ATTENTION: this will have significant impact on CExt execution performance).")
    public static final OptionKey<Boolean> TraceNativeMemory = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="If native memory tracing is enabled, also capture stack.")
    public static final OptionKey<Boolean> TraceNativeMemoryCalls = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<bytes>", help="Max native memory heap size (default: 8 GB).")
    public static final OptionKey<Long> MaxNativeMemory = new OptionKey((Object)0x200000000L);
    @Option(category=OptionCategory.EXPERT, usageSyntax="<bytes>", help="Initial native memory heap size that triggers a GC (default: 256 MB).")
    public static final OptionKey<Long> InitialNativeMemory = new OptionKey((Object)0x10000000L);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Use the panama backend for NFI.", stability=OptionStability.EXPERIMENTAL)
    public static final OptionKey<Boolean> UsePanama = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Set by the launcher to true (false means that GraalPy is being embedded in an application).")
    public static final OptionKey<Boolean> RunViaLauncher = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Enable built-in functions on the __graalpython__ module that are useful for debugging.")
    public static final OptionKey<Boolean> EnableDebuggingBuiltins = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, help="Disables using frozen modules.")
    public static final OptionKey<Boolean> DisableFrozenModules = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, help="Makes bytecode instrumentation node materialization eager instead of lazy.")
    public static final OptionKey<Boolean> EagerlyMaterializeInstrumentationNodes = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, help="The list of the original command line arguments passed to the Python executable.")
    public static final OptionKey<TruffleString> OrigArgv = new OptionKey((Object)StringLiterals.T_EMPTY_STRING, TS_OPTION_TYPE);
    @EngineOption
    @Option(category=OptionCategory.INTERNAL, usageSyntax="true|false", help="If true, uses native storage strategy for primitive types")
    public static final OptionKey<Boolean> UseNativePrimitiveStorageStrategy = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, usageSyntax="true|false", help="Print warnings when using experimental features at runtime.", stability=OptionStability.STABLE)
    public static final OptionKey<Boolean> WarnExperimentalFeatures = new OptionKey((Object)true);
    public static final OptionDescriptors DESCRIPTORS = new PythonOptionsOptionDescriptors();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final OptionKey<?>[] ENGINE_OPTION_KEYS;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final OptionKey<?>[] OPTION_KEYS;

    private PythonOptions() {
    }

    public static void checkBytecodeDSLEnv() {
        if (!ENABLE_BYTECODE_DSL_INTERPRETER && "true".equalsIgnoreCase(System.getenv("BYTECODE_DSL_INTERPRETER"))) {
            System.err.println("WARNING: found environment variable BYTECODE_DSL_INTERPRETER=true, but the python.EnableBytecodeDSLInterpreter Java property was not set.");
        }
    }

    public static OptionKey<?>[] getOptionKeys() {
        return OPTION_KEYS;
    }

    public static OptionKey<?>[] getEngineOptionKeys() {
        return ENGINE_OPTION_KEYS;
    }

    public static Object[] createOptionValuesStorage(TruffleLanguage.Env env) {
        Object[] values = new Object[OPTION_KEYS.length];
        for (int i = 0; i < OPTION_KEYS.length; ++i) {
            values[i] = env.getOptions().get(OPTION_KEYS[i]);
        }
        return values;
    }

    public static Object[] createEngineOptionValuesStorage(TruffleLanguage.Env env) {
        Object[] values = new Object[ENGINE_OPTION_KEYS.length];
        for (int i = 0; i < ENGINE_OPTION_KEYS.length; ++i) {
            values[i] = env.getOptions().get(ENGINE_OPTION_KEYS[i]);
        }
        return values;
    }

    public static OptionValues createEngineOptions(TruffleLanguage.Env env) {
        return new EngineOptionValues(env.getOptions());
    }

    @ExplodeLoop
    public static <T> T getOptionUnrolling(Object[] optionValuesStorage, OptionKey<?>[] optionKeys, OptionKey<T> key) {
        assert (optionValuesStorage.length == optionKeys.length);
        CompilerAsserts.partialEvaluationConstant(optionKeys);
        for (int i = 0; i < optionKeys.length; ++i) {
            CompilerAsserts.partialEvaluationConstant(optionKeys[i]);
            if (optionKeys[i] != key) continue;
            return (T)optionValuesStorage[i];
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("Using Python options with a non-Python option key");
    }

    @ExplodeLoop
    public static boolean isEngineOption(OptionKey<?> key) {
        CompilerAsserts.partialEvaluationConstant(ENGINE_OPTION_KEYS);
        for (int i = 0; i < ENGINE_OPTION_KEYS.length; ++i) {
            CompilerAsserts.partialEvaluationConstant(ENGINE_OPTION_KEYS[i]);
            if (ENGINE_OPTION_KEYS[i] != key) continue;
            return true;
        }
        return false;
    }

    public static boolean areOptionsCompatible(OptionValues first, OptionValues second) {
        for (OptionKey<?> key : ENGINE_OPTION_KEYS) {
            if (first.get(key).equals(second.get(key))) continue;
            return false;
        }
        return true;
    }

    @Idempotent
    public static int getAttributeAccessInlineCacheMaxDepth() {
        CompilerAsserts.neverPartOfCompilation();
        return PythonLanguage.get(null).getEngineOption(AttributeAccessInlineCacheMaxDepth);
    }

    @Idempotent
    public static int getCallSiteInlineCacheMaxDepth() {
        CompilerAsserts.neverPartOfCompilation();
        return PythonLanguage.get(null).getEngineOption(CallSiteInlineCacheMaxDepth);
    }

    @Idempotent
    public static int getVariableArgumentInlineCacheLimit() {
        CompilerAsserts.neverPartOfCompilation();
        return PythonLanguage.get(null).getEngineOption(VariableArgumentInlineCacheLimit);
    }

    @Idempotent
    public static int getNodeRecursionLimit() {
        CompilerAsserts.neverPartOfCompilation();
        int result = PythonLanguage.get(null).getEngineOption(NodeRecursionLimit);
        assert (result < 127);
        return result;
    }

    public static boolean isPExceptionWithJavaStacktrace(PythonLanguage language) {
        return language.getEngineOption(WithJavaStacktrace) >= 2;
    }

    public static boolean shouldPrintJavaStacktrace(PythonLanguage language, Throwable throwable) {
        int mode = language.getEngineOption(WithJavaStacktrace);
        if (mode == 1) {
            return !(throwable instanceof AbstractTruffleException);
        }
        if (mode == 2) {
            return throwable instanceof AbstractTruffleException;
        }
        return mode == 3;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString[] getExecutableList(PythonContext context) {
        TruffleString execListOption = context.getOption(ExecutableList);
        if (execListOption.isEmpty()) {
            return StringUtils.split(context.getOption(Executable), StringLiterals.T_SPACE, TruffleString.CodePointLengthNode.getUncached(), TruffleString.IndexOfStringNode.getUncached(), TruffleString.SubstringNode.getUncached(), TruffleString.EqualNode.getUncached());
        }
        return StringUtils.split(execListOption, T_STRING_LIST_SEPARATOR, TruffleString.CodePointLengthNode.getUncached(), TruffleString.IndexOfStringNode.getUncached(), TruffleString.SubstringNode.getUncached(), TruffleString.EqualNode.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString[] getOrigArgv(PythonContext context) {
        return StringUtils.split(context.getOption(OrigArgv), T_STRING_LIST_SEPARATOR, TruffleString.CodePointLengthNode.getUncached(), TruffleString.IndexOfStringNode.getUncached(), TruffleString.SubstringNode.getUncached(), TruffleString.EqualNode.getUncached());
    }

    static {
        ArrayList<OptionKey> options = new ArrayList<OptionKey>();
        for (OptionDescriptor desc : DESCRIPTORS) {
            options.add(desc.getKey());
        }
        OPTION_KEYS = options.toArray(new OptionKey[options.size()]);
        ArrayList<OptionKey> engineOptions = new ArrayList<OptionKey>();
        for (Field f : PythonOptions.class.getDeclaredFields()) {
            if (f.getAnnotation(EngineOption.class) == null) continue;
            for (OptionDescriptor desc : DESCRIPTORS) {
                if (!desc.getName().endsWith(f.getName())) continue;
                engineOptions.add(desc.getKey());
            }
        }
        ENGINE_OPTION_KEYS = engineOptions.toArray(new OptionKey[engineOptions.size()]);
    }

    private static final class EngineOptionValues
    implements OptionValues {
        private final Map<OptionKey<?>, Object> engineOptions = new HashMap();

        EngineOptionValues(OptionValues contextOptions) {
            for (OptionKey<?> engineKey : ENGINE_OPTION_KEYS) {
                if (!contextOptions.hasBeenSet(engineKey)) continue;
                this.engineOptions.put(engineKey, contextOptions.get(engineKey));
            }
        }

        public OptionDescriptors getDescriptors() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EngineOptionValues)) {
                return false;
            }
            EngineOptionValues other = (EngineOptionValues)obj;
            return this.engineOptions.equals(other.engineOptions);
        }

        public int hashCode() {
            return this.engineOptions.hashCode();
        }

        public <T> T get(OptionKey<T> optionKey) {
            if (this.engineOptions.containsKey(optionKey)) {
                return (T)this.engineOptions.get(optionKey);
            }
            return (T)optionKey.getDefaultValue();
        }

        public boolean hasBeenSet(OptionKey<?> optionKey) {
            return this.engineOptions.containsKey(optionKey);
        }

        public <T> void set(OptionKey<T> optionKey, T value) {
            throw new UnsupportedOperationException();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface EngineOption {
    }
}

