/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.builtins.objects.tuple.StructSequenceBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.StructSequenceBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStatResult, PythonBuiltinClassType.PStatvfsResult, PythonBuiltinClassType.PTerminalSize, PythonBuiltinClassType.PUnameResult, PythonBuiltinClassType.PStructTime, PythonBuiltinClassType.PProfilerEntry, PythonBuiltinClassType.PProfilerSubentry, PythonBuiltinClassType.PStructPasswd, PythonBuiltinClassType.PStructRusage, PythonBuiltinClassType.PVersionInfo, PythonBuiltinClassType.PWindowsVersion, PythonBuiltinClassType.PFlags, PythonBuiltinClassType.PFloatInfo, PythonBuiltinClassType.PIntInfo, PythonBuiltinClassType.PHashInfo, PythonBuiltinClassType.PThreadInfo, PythonBuiltinClassType.PUnraisableHookArgs})
public final class StructSequenceBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = StructSequenceBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StructSequenceBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static PTuple reduce(VirtualFrame frame, PTuple self, @Bind Node inliningTarget, @Cached GetClassNode getClass, @Cached GetSizeNode getSizeNode, @Cached GetFieldNamesNode getFieldNamesNode, @Cached SequenceStorageNodes.GetItemScalarNode getSeqItem, @Cached SequenceStorageNodes.GetItemSliceNode getSeqSlice, @Cached PyDictSetItem dictSetItem, @Cached PRaiseNode raiseNode, @Bind PythonLanguage language) {
            SequenceStorage storage = self.getSequenceStorage();
            Object type = getClass.execute(inliningTarget, self);
            int nFields = getSizeNode.execute(frame, inliningTarget, type, StructSequence.T_N_FIELDS);
            int nVisibleFields = storage.length();
            int nUnnamedFields = getSizeNode.execute(frame, inliningTarget, type, StructSequence.T_N_UNNAMED_FIELDS);
            PTuple tuple = PFactory.createTuple(language, getSeqSlice.execute(storage, 0, nVisibleFields, 1, nVisibleFields));
            PDict dict = PFactory.createDict(language);
            if (nFields > nVisibleFields) {
                if (storage instanceof NativeSequenceStorage) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.NotImplementedError, ErrorMessages.UNSUPPORTED_ACCESS_OF_STRUCT_SEQUENCE_NATIVE_STORAGE);
                }
                assert (storage.getCapacity() >= nFields);
                TruffleString[] fieldNames = getFieldNamesNode.execute(inliningTarget, type);
                for (int i = nVisibleFields; i < nFields; ++i) {
                    TruffleString n = fieldNames[i - nUnnamedFields];
                    dictSetItem.execute(inliningTarget, dict, n, getSeqItem.execute(inliningTarget, storage, i));
                }
            }
            return PFactory.createTuple(language, new Object[]{type, PFactory.createTuple(language, new Object[]{tuple, dict})});
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, PTuple self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached GetFieldNamesNode getFieldNamesNode, @Cached ObjectNodes.GetFullyQualifiedNameNode getQName, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)getQName.execute((Frame)frame, type));
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
            SequenceStorage tupleStore = self.getSequenceStorage();
            int visibleSize = tupleStore.length();
            TruffleString[] fieldNames = getFieldNamesNode.execute(inliningTarget, type);
            if (visibleSize > 0) {
                appendStringNode.execute(sb, (AbstractTruffleString)fieldNames[0]);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EQ);
                appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, getItemNode.execute(inliningTarget, tupleStore, 0)));
                for (int i = 1; i < visibleSize; ++i) {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    appendStringNode.execute(sb, (AbstractTruffleString)fieldNames[i]);
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EQ);
                    appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, getItemNode.execute(inliningTarget, tupleStore, i)));
                }
            }
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
            return toStringNode.execute(sb);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetFieldNamesNode
    extends Node {
        GetFieldNamesNode() {
        }

        public abstract TruffleString[] execute(Node var1, Object var2);

        @Specialization
        static TruffleString[] doPBCT(Node inliningTarget, PythonBuiltinClassType type, @Cached.Shared @Cached HiddenAttr.ReadNode readNode) {
            return GetFieldNamesNode.doManaged(inliningTarget, PythonContext.get(inliningTarget).lookupType(type), readNode);
        }

        @Specialization
        static TruffleString[] doManaged(Node inliningTarget, PythonManagedClass type, @Cached.Shared @Cached HiddenAttr.ReadNode readNode) {
            return (TruffleString[])readNode.execute(inliningTarget, type, HiddenAttr.STRUCTSEQ_FIELD_NAMES, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static TruffleString[] doNative(PythonAbstractNativeObject type) {
            CStructAccess.ReadPointerNode read = CStructAccess.ReadPointerNode.getUncached();
            Object membersPtr = read.readFromObj(type, CFields.PyTypeObject__tp_members);
            ArrayList<TruffleString> members = new ArrayList<TruffleString>();
            InteropLibrary lib = InteropLibrary.getUncached();
            if (!PGuards.isNullOrZero(membersPtr, lib)) {
                Object memberNamePtr;
                int i = 0;
                while (!PGuards.isNullOrZero(memberNamePtr = read.readStructArrayElement(membersPtr, i, CFields.PyMemberDef__name), lib)) {
                    TruffleString name = CExtNodes.FromCharPointerNode.executeUncached(memberNamePtr);
                    members.add(name);
                    ++i;
                }
            }
            return members.toArray(new TruffleString[0]);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetSizeNode
    extends Node {
        GetSizeNode() {
        }

        public abstract int execute(VirtualFrame var1, Node var2, Object var3, TruffleString var4);

        @Specialization
        static int doPBCT(VirtualFrame frame, Node inliningTarget, PythonBuiltinClassType type, TruffleString key, @Cached.Shared @Cached(value="createForceType()") ReadAttributeFromObjectNode read, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            return GetSizeNode.doGeneric(frame, inliningTarget, PythonContext.get(inliningTarget).lookupType(type), key, read, asSizeNode);
        }

        @Fallback
        static int doGeneric(VirtualFrame frame, Node inliningTarget, Object type, TruffleString key, @Cached.Shared @Cached(value="createForceType()") ReadAttributeFromObjectNode read, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            return asSizeNode.executeExact((Frame)frame, inliningTarget, read.execute(type, key));
        }
    }
}

