/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Optional;
import org.firebirdsql.gds.ng.CursorFlag;
import org.firebirdsql.gds.ng.DeferredResponse;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FetchDirection;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.OperationCloseHandle;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.AsyncFetchStatus;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.version10.V10Statement;

public class V11Statement
extends V10Statement {
    protected AsyncFetchStatus asyncFetchStatus = AsyncFetchStatus.nonePending();

    public V11Statement(FbWireDatabase database) {
        super(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String statementText) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            StatementState initialState = this.checkPrepareAllowed();
            this.resetAll();
            int expectedResponseCount = 0;
            try {
                if (initialState == StatementState.NEW) {
                    this.sendAllocate();
                    this.switchState(StatementState.ALLOCATED);
                    ++expectedResponseCount;
                } else {
                    this.checkStatementValid();
                }
                this.sendPrepare(statementText);
                ++expectedResponseCount;
                this.withTransmitLock(OutputStream::flush);
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.ioWriteError(e);
            }
            try {
                FbWireDatabase db = this.getDatabase();
                try {
                    if (initialState == StatementState.NEW) {
                        try {
                            --expectedResponseCount;
                            this.processAllocateResponse(db.readGenericResponse(this.getStatementWarningCallback()));
                        }
                        catch (SQLException e) {
                            this.forceState(StatementState.NEW);
                            throw e;
                        }
                    }
                    try {
                        --expectedResponseCount;
                        this.processPrepareResponse(db.readGenericResponse(this.getStatementWarningCallback()));
                    }
                    catch (SQLException e) {
                        this.switchState(StatementState.ALLOCATED);
                        throw e;
                    }
                }
                finally {
                    db.consumePackets(expectedResponseCount, this.getStatementWarningCallback());
                }
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.ioReadError(e);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void fetchRows(int fetchSize) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (!this.completeAsyncFetch()) {
                super.fetchRows(fetchSize);
            }
        }
    }

    @Override
    public final void asyncFetchRows(int fetchSize) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementHasOpenCursor();
            this.checkFetchSize(fetchSize);
            if (this.isSkipAsyncFetch(fetchSize)) {
                return;
            }
            this.sendAsyncFetch(fetchSize);
            this.asyncFetchStatus = AsyncFetchStatus.pending();
            this.getDatabase().enqueueDeferredAction(this.wrapDeferredResponse(new DeferredResponse<AsyncFetchStatus>(){

                @Override
                public void onResponse(AsyncFetchStatus responseStatus) {
                    V11Statement.this.asyncFetchStatus = responseStatus;
                }

                @Override
                public void onException(Exception exception) {
                    SQLException sqlException;
                    if (exception instanceof SQLException) {
                        SQLException sqle;
                        sqlException = sqle = (SQLException)exception;
                    } else if (exception instanceof IOException) {
                        IOException ioe = (IOException)exception;
                        sqlException = FbExceptionBuilder.ioReadError(ioe);
                    } else {
                        sqlException = new SQLException("Unexpected exception occurred during async fetch", exception);
                    }
                    V11Statement.this.asyncFetchStatus = AsyncFetchStatus.completedWithException(sqlException);
                }
            }, this::processAsyncFetchResponse, false));
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private boolean isSkipAsyncFetch(int fetchSize) {
        return this.isAfterLast() || this.asyncFetchStatus.isPending() || fetchSize == 1 || this.getCursorName() != null || this.isCursorFlagSet(CursorFlag.CURSOR_TYPE_SCROLLABLE) || this.isAsyncFetchDisabled();
    }

    private boolean isAsyncFetchDisabled() {
        return !this.getDatabase().getConnectionProperties().isAsyncFetch();
    }

    private void sendAsyncFetch(int fetchSize) throws SQLException {
        try (OperationCloseHandle operationCloseHandle = this.signalAsyncFetchStart();){
            if (operationCloseHandle.isCancelled()) {
                throw FbExceptionBuilder.toException(335544794);
            }
            this.sendFetch(fetchSize);
            this.withTransmitLock(OutputStream::flush);
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private AsyncFetchStatus processAsyncFetchResponse(Response initialResponse) {
        OperationCloseHandle ignored = this.signalAsyncFetchComplete();
        try {
            this.processFetchResponse(FetchDirection.FORWARD, initialResponse);
            AsyncFetchStatus asyncFetchStatus = AsyncFetchStatus.completed();
            if (ignored != null) {
                ignored.close();
            }
            return asyncFetchStatus;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                try {
                    this.switchState(StatementState.ERROR);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return AsyncFetchStatus.completedWithException(FbExceptionBuilder.ioReadError(e));
            }
            catch (SQLException e) {
                return AsyncFetchStatus.completedWithException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean completeAsyncFetch() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            boolean bl;
            this.checkStatementValid();
            if (!this.asyncFetchStatus.isPending()) {
                boolean bl2 = false;
                return bl2;
            }
            try {
                Optional<SQLException> fetchException = this.asyncFetchStatus.exception();
                if (fetchException.isPresent()) {
                    throw fetchException.get();
                }
                this.getDatabase().completeDeferredActions();
                fetchException = this.asyncFetchStatus.exception();
                if (fetchException.isPresent()) {
                    throw fetchException.get();
                }
                bl = true;
            }
            catch (Throwable throwable) {
                this.asyncFetchStatus = AsyncFetchStatus.completed();
                throw throwable;
            }
            this.asyncFetchStatus = AsyncFetchStatus.completed();
            return bl;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    protected void free(int option) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                this.doFreePacket(option);
                if (option != 1) {
                    this.withTransmitLock(OutputStream::flush);
                }
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.ioWriteError(e);
            }
            this.getDatabase().enqueueDeferredAction(new DeferredAction(){

                @Override
                public void processResponse(Response response) {
                    V11Statement.this.processFreeResponse(response);
                }

                @Override
                public WarningMessageCallback getWarningMessageCallback() {
                    return V11Statement.this.getStatementWarningCallback();
                }

                @Override
                public boolean requiresSync() {
                    return true;
                }
            });
        }
    }

    @Override
    protected void reset(boolean resetAll) {
        try (LockCloseable ignored = this.withLock();){
            try {
                super.reset(resetAll);
            }
            finally {
                this.asyncFetchStatus.exception().ifPresent(e -> System.getLogger(this.getClass().getName()).log(System.Logger.Level.TRACE, "Ignored pending async fetch exception during reset", (Throwable)e));
                this.asyncFetchStatus = AsyncFetchStatus.nonePending();
            }
        }
    }
}

