\name{LabelStatisticsImageFilter}
\alias{LabelStatisticsImageFilter}
\title{LabelStatisticsImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Given an intensity image and a label map, compute min, max, variance
and mean of the pixels associated with each label or segment.
LabelStatisticsImageFilter}
\details{
LabelStatisticsImageFilter computes the minimum, maximum, sum, mean, median, variance and sigma
of regions of an intensity image, where the regions are defined via a
label map (a second input). The label image should be integral type.
The filter needs all of its input image. It behaves as a filter with
an input and output. Thus it can be inserted in a pipeline with other
filters and the statistics will only be recomputed if a downstream
filter changes.
Optionally, the filter also computes intensity histograms on each
object. If histograms are enabled, a median intensity value can also
be computed, although its accuracy is limited to the bin width of the
histogram. If histograms are not enabled, the median returns zero.
This filter is automatically multi-threaded and can stream its input
when NumberOfStreamDivisions is set to more than
Statistics are independently computed for each streamed and threaded region then
merged.
See:
itk::LabelStatisticsImageFilter for the Doxygen on the original ITK class.
LabelStatisticsImageFilter}
%C++ includes: sitkLabelStatisticsImageFilter.h
\section{Methods}{
\describe{
\item{void Execute(const Image &image, const Image &labelImage):}{
Execute the filter on the input image
}
\item{std::vector< int > GetBoundingBox(int64_t label) const:}{
Return the computed bounding box for a label. A vector of minIndex,
maxIndex pairs for each axis. The intervals include the endpoints.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{uint64_t GetCount(int64_t label) const:}{
Return the number of pixels for a label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< int64_t > GetLabels() const:}{
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMaximum(int64_t label) const:}{
Return the computed Maximum for a label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetMean(int64_t label) const:}{
Return the computed Mean for a label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetMedian(int64_t label) const:}{
Return the computed Median for a label. Requires histograms to be
enabled!
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetMinimum(int64_t label) const:}{
Return the computed Minimum for a label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint64_t GetNumberOfLabels():}{
Return the number of labels after execution .
}
\item{std::vector< unsigned int > GetRegion(int64_t label) const:}{
Return the computed region.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetSigma(int64_t label) const:}{
Return the computed Standard Deviation for a label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetSum(int64_t label) const:}{
Return the compute Sum for a label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{bool GetUseHistograms() const:}{}
\item{double GetVariance(int64_t label) const:}{
Return the computed Variance for a label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{bool HasLabel(int64_t label):}{
Does the specified label exist? Can only be called after a call a call
to Update().
}
\item{ LabelStatisticsImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetUseHistograms(bool UseHistograms):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseHistogramsOff():}{}
\item{Self UseHistogramsOn():}{
Set the value of UseHistograms to true or false respectfully.
}
\item{ ~LabelStatisticsImageFilter():}{
Destructor
}
}
}
