/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy;

import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListPrefetchScope;
import androidx.compose.foundation.lazy.LazyListPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.runtime.Stable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0014\u0010\u0019\u001a\u00020\u0003*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u001c\u0010\u001b\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/lazy/DefaultLazyListPrefetchStrategy;", "Landroidx/compose/foundation/lazy/LazyListPrefetchStrategy;", "initialNestedPrefetchItemCount", "", "<init>", "(I)V", "indexToPrefetch", "currentPrefetchHandle", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "wasScrollingForward", "", "previousPassItemCount", "previousPassDelta", "", "onScroll", "", "Landroidx/compose/foundation/lazy/LazyListPrefetchScope;", "delta", "layoutInfo", "Landroidx/compose/foundation/lazy/LazyListLayoutInfo;", "onVisibleItemsUpdated", "onNestedPrefetch", "Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;", "firstVisibleItemIndex", "resetPrefetchState", "calculateIndexToPrefetch", "scrollingForward", "evaluatePrefetchForCancellation", "currentPrefetchingIndex", "foundation"})
@Stable
final class DefaultLazyListPrefetchStrategy
implements LazyListPrefetchStrategy {
    private final int initialNestedPrefetchItemCount;
    private int indexToPrefetch;
    @Nullable
    private LazyLayoutPrefetchState.PrefetchHandle currentPrefetchHandle;
    private boolean wasScrollingForward;
    private int previousPassItemCount;
    private float previousPassDelta;

    public DefaultLazyListPrefetchStrategy(int initialNestedPrefetchItemCount) {
        this.initialNestedPrefetchItemCount = initialNestedPrefetchItemCount;
        this.indexToPrefetch = -1;
        this.previousPassItemCount = -1;
    }

    public /* synthetic */ DefaultLazyListPrefetchStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    @Override
    public void onScroll(@NotNull LazyListPrefetchScope $this$onScroll, float delta, @NotNull LazyListLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$onScroll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (!((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            boolean scrollingForward = delta < 0.0f;
            int indexToPrefetch = this.calculateIndexToPrefetch(layoutInfo, scrollingForward);
            boolean bl = 0 <= indexToPrefetch ? indexToPrefetch < layoutInfo.getTotalItemsCount() : false;
            if (bl) {
                if (indexToPrefetch != this.indexToPrefetch) {
                    if (this.wasScrollingForward != scrollingForward) {
                        this.resetPrefetchState();
                    }
                    this.wasScrollingForward = scrollingForward;
                    this.indexToPrefetch = indexToPrefetch;
                    this.currentPrefetchHandle = LazyListPrefetchScope.schedulePrefetch$default($this$onScroll, indexToPrefetch, null, 2, null);
                }
                if (scrollingForward) {
                    LazyListItemInfo lastItem = (LazyListItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                    int spacing = layoutInfo.getMainAxisItemSpacing();
                    int distanceToPrefetchItem = lastItem.getOffset() + lastItem.getSize() + spacing - layoutInfo.getViewportEndOffset();
                    if ((float)distanceToPrefetchItem < -delta) {
                        LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
                        if (prefetchHandle != null) {
                            prefetchHandle.markAsUrgent();
                        }
                    }
                } else {
                    LazyListItemInfo firstItem = (LazyListItemInfo)CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
                    int distanceToPrefetchItem = layoutInfo.getViewportStartOffset() - firstItem.getOffset();
                    if ((float)distanceToPrefetchItem < delta) {
                        LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
                        if (prefetchHandle != null) {
                            prefetchHandle.markAsUrgent();
                        }
                    }
                }
            }
        }
        this.previousPassDelta = delta;
    }

    @Override
    public void onVisibleItemsUpdated(@NotNull LazyListPrefetchScope $this$onVisibleItemsUpdated, @NotNull LazyListLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$onVisibleItemsUpdated, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        this.evaluatePrefetchForCancellation(layoutInfo, this.indexToPrefetch, this.wasScrollingForward);
        int currentPassItemCount = layoutInfo.getTotalItemsCount();
        if (this.previousPassItemCount != -1 && !(this.previousPassDelta == 0.0f) && this.previousPassItemCount != currentPassItemCount && !((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int indexToPrefetch = this.calculateIndexToPrefetch(layoutInfo, this.previousPassDelta < 0.0f);
            boolean bl = 0 <= indexToPrefetch ? indexToPrefetch < currentPassItemCount : false;
            if (bl) {
                this.indexToPrefetch = indexToPrefetch;
                this.currentPrefetchHandle = LazyListPrefetchScope.schedulePrefetch$default($this$onVisibleItemsUpdated, indexToPrefetch, null, 2, null);
            }
        }
        this.previousPassItemCount = currentPassItemCount;
    }

    @Override
    public void onNestedPrefetch(@NotNull NestedPrefetchScope $this$onNestedPrefetch, int firstVisibleItemIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$onNestedPrefetch, (String)"<this>");
        int resolvedNestedPrefetchItemCount = $this$onNestedPrefetch.getNestedPrefetchItemCount() == -1 ? this.initialNestedPrefetchItemCount : $this$onNestedPrefetch.getNestedPrefetchItemCount();
        int n = 0;
        while (n < resolvedNestedPrefetchItemCount) {
            int i = n++;
            boolean bl = false;
            $this$onNestedPrefetch.schedulePrecomposition(firstVisibleItemIndex + i);
        }
    }

    private final void resetPrefetchState() {
        this.indexToPrefetch = -1;
        LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
        if (prefetchHandle != null) {
            prefetchHandle.cancel();
        }
        this.currentPrefetchHandle = null;
    }

    private final int calculateIndexToPrefetch(LazyListLayoutInfo $this$calculateIndexToPrefetch, boolean scrollingForward) {
        return scrollingForward ? ((LazyListItemInfo)CollectionsKt.last($this$calculateIndexToPrefetch.getVisibleItemsInfo())).getIndex() + 1 : ((LazyListItemInfo)CollectionsKt.first($this$calculateIndexToPrefetch.getVisibleItemsInfo())).getIndex() - 1;
    }

    private final void evaluatePrefetchForCancellation(LazyListLayoutInfo $this$evaluatePrefetchForCancellation, int currentPrefetchingIndex, boolean scrollingForward) {
        int expectedPrefetchIndex;
        if (currentPrefetchingIndex != -1 && !((Collection)$this$evaluatePrefetchForCancellation.getVisibleItemsInfo()).isEmpty() && currentPrefetchingIndex != (expectedPrefetchIndex = this.calculateIndexToPrefetch($this$evaluatePrefetchForCancellation, scrollingForward))) {
            this.resetPrefetchState();
        }
    }

    public DefaultLazyListPrefetchStrategy() {
        this(0, 1, null);
    }
}

