/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diff.Block;
import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.platform.lvcs.impl.diff.DiffUtilsKt;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b'\u0018\u0000 '2\u00020\u0001:\u0002&'B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020\u0006H$J \u0010!\u001a\u00020\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000e\u001a\u0017\u0012\u000e\u0012\f0\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u00120\u000f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "revisions", "", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "fromLine", "", "toLine", "<init>", "(Lcom/intellij/history/integration/IdeaGateway;Ljava/util/List;II)V", "getRevisions$intellij_platform_lvcs_impl", "()Ljava/util/List;", "cache", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lcom/intellij/diff/Block;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "canCalculateFor", "", "revision", "progress", "Lcom/intellij/history/integration/ui/models/Progress;", "getSelectionFor", "doGetSelectionFor", "revisionIndex", "findLastNonEmptyBlock", "Lkotlin/collections/IndexedValue;", "getRevisionContent", "", "getEntry", "Lcom/intellij/history/core/tree/Entry;", "processContents", "", "processor", "Lkotlin/Function2;", "", "ContentIsUnavailableException", "Companion", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public abstract class SelectionCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdeaGateway gateway;
    @NotNull
    private final List<RevisionId> revisions;
    private final int fromLine;
    private final int toLine;
    @NotNull
    private final ConcurrentIntObjectMap<Block> cache;
    @NotNull
    private static final Block EMPTY_BLOCK = new Block("", 0, 0);

    public SelectionCalculator(@NotNull IdeaGateway gateway, @NotNull List<? extends RevisionId> revisions, int fromLine, int toLine) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
        this.gateway = gateway;
        this.revisions = revisions;
        this.fromLine = fromLine;
        this.toLine = toLine;
        ConcurrentIntObjectMap concurrentIntObjectMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentIntObjectMap, (String)"createConcurrentIntObjectMap(...)");
        this.cache = concurrentIntObjectMap;
    }

    @NotNull
    public final List<RevisionId> getRevisions$intellij_platform_lvcs_impl() {
        return this.revisions;
    }

    public final boolean canCalculateFor(@NotNull RevisionId revision, @NotNull Progress progress) {
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        try {
            this.doGetSelectionFor(revision, progress);
        }
        catch (ContentIsUnavailableException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final Block getSelectionFor(@NotNull RevisionId revision, @NotNull Progress progress) {
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        return this.doGetSelectionFor(revision, progress);
    }

    private final Block doGetSelectionFor(RevisionId revision, Progress progress) {
        int target = this.revisions.indexOf(revision);
        return this.getSelectionFor(target, progress);
    }

    private final Block getSelectionFor(int revisionIndex, Progress progress) {
        Block block;
        Block lastNonEmptyBlock;
        Block cached;
        Block block2 = cached = (Block)this.cache.get(revisionIndex);
        if (block2 != null) {
            return block2;
        }
        IndexedValue<Block> indexedValue = this.findLastNonEmptyBlock(revisionIndex);
        int lastNonEmptyIndex = indexedValue.component1();
        Block lastBlock = lastNonEmptyBlock = (Block)indexedValue.component2();
        int currentIndex = lastNonEmptyIndex + 1;
        if (currentIndex <= revisionIndex) {
            while (true) {
                Block block3;
                String content = this.getRevisionContent(this.revisions.get(currentIndex));
                progress.processed((currentIndex + 1) * 100 / (revisionIndex + 1));
                if (content == null) {
                    block3 = EMPTY_BLOCK;
                } else if (currentIndex == 0) {
                    block3 = new Block(content, this.fromLine, this.toLine + 1);
                } else {
                    Block nextBlock = lastBlock;
                    Block block4 = nextBlock.createPreviousBlock(content);
                    Intrinsics.checkNotNull((Object)block4);
                    block3 = block4;
                }
                Block result = block3;
                this.cache.put(currentIndex, (Object)result);
                if (!Intrinsics.areEqual((Object)result, (Object)EMPTY_BLOCK)) {
                    lastBlock = result;
                }
                if (currentIndex == revisionIndex) break;
                ++currentIndex;
            }
        }
        if ((block = (Block)this.cache.get(revisionIndex)) == null) {
            block = EMPTY_BLOCK;
        }
        return block;
    }

    private final IndexedValue<Block> findLastNonEmptyBlock(int revisionIndex) {
        for (int index = revisionIndex; -1 < index; --index) {
            Block cachedBlock = (Block)this.cache.get(index);
            if (cachedBlock == null || Intrinsics.areEqual((Object)cachedBlock, (Object)EMPTY_BLOCK)) continue;
            return new IndexedValue(index, (Object)cachedBlock);
        }
        return new IndexedValue(-1, (Object)EMPTY_BLOCK);
    }

    private final String getRevisionContent(RevisionId revision) {
        Entry entry = this.getEntry(revision);
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry;
        Content content = entry2.getContent();
        if (!content.isAvailable()) {
            throw new ContentIsUnavailableException();
        }
        return content.getString(entry2, this.gateway);
    }

    @Nullable
    protected abstract Entry getEntry(@NotNull RevisionId var1);

    public final void processContents(@NotNull Function2<? super Long, ? super String, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Iterator iterator = ((Iterable)this.revisions).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            RevisionId revisionId = (RevisionId)iterator.next();
            Progress progress = Progress.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)progress, (String)"EMPTY");
            Block block = this.getSelectionFor(index, progress);
            if (!(revisionId instanceof RevisionId.ChangeSet)) continue;
            Long l = ((RevisionId.ChangeSet)revisionId).getId();
            String string = block.getBlockContent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBlockContent(...)");
            if (((Boolean)processor.invoke((Object)l, (Object)string)).booleanValue()) continue;
            break;
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SelectionCalculator create(@NotNull LocalHistoryFacade facade, @NotNull IdeaGateway gateway, @NotNull RootEntry rootEntry, @NotNull String entryPath, @NotNull List<? extends RevisionId> revisions, int fromLine, int toLine, boolean isOldContentUsed) {
        return Companion.create(facade, gateway, rootEntry, entryPath, revisions, fromLine, toLine, isOldContentUsed);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SelectionCalculator create(@NotNull LocalHistoryFacade facade, @NotNull IdeaGateway gateway, @NotNull RootEntry rootEntry, @NotNull String entryPath, @NotNull List<? extends RevisionId> revisions, int fromLine, int toLine) {
        return Companion.create(facade, gateway, rootEntry, entryPath, revisions, fromLine, toLine);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JP\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/history/integration/ui/models/SelectionCalculator$Companion;", "", "<init>", "()V", "EMPTY_BLOCK", "Lcom/intellij/diff/Block;", "create", "Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "facade", "Lcom/intellij/history/core/LocalHistoryFacade;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "rootEntry", "Lcom/intellij/history/core/tree/RootEntry;", "entryPath", "", "revisions", "", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "fromLine", "", "toLine", "isOldContentUsed", "", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SelectionCalculator create(@NotNull LocalHistoryFacade facade, @NotNull IdeaGateway gateway, @NotNull RootEntry rootEntry, @NotNull String entryPath, @NotNull List<? extends RevisionId> revisions, int fromLine, int toLine, boolean isOldContentUsed) {
            Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
            Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
            Intrinsics.checkNotNullParameter((Object)rootEntry, (String)"rootEntry");
            Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
            Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
            return new SelectionCalculator(gateway, revisions, fromLine, toLine, facade, rootEntry, entryPath, isOldContentUsed){
                final /* synthetic */ LocalHistoryFacade $facade;
                final /* synthetic */ RootEntry $rootEntry;
                final /* synthetic */ String $entryPath;
                final /* synthetic */ boolean $isOldContentUsed;
                {
                    this.$facade = $facade;
                    this.$rootEntry = $rootEntry;
                    this.$entryPath = $entryPath;
                    this.$isOldContentUsed = $isOldContentUsed;
                    super($gateway, $revisions, $fromLine, $toLine);
                }

                protected Entry getEntry(RevisionId revision) {
                    Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
                    return DiffUtilsKt.findEntry(this.$facade, this.$rootEntry, revision, this.$entryPath, this.$isOldContentUsed);
                }
            };
        }

        public static /* synthetic */ SelectionCalculator create$default(Companion companion, LocalHistoryFacade localHistoryFacade, IdeaGateway ideaGateway, RootEntry rootEntry, String string, List list, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 0x80) != 0) {
                bl = true;
            }
            return companion.create(localHistoryFacade, ideaGateway, rootEntry, string, list, n, n2, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SelectionCalculator create(@NotNull LocalHistoryFacade facade, @NotNull IdeaGateway gateway, @NotNull RootEntry rootEntry, @NotNull String entryPath, @NotNull List<? extends RevisionId> revisions, int fromLine, int toLine) {
            Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
            Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
            Intrinsics.checkNotNullParameter((Object)rootEntry, (String)"rootEntry");
            Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
            Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
            return com.intellij.history.integration.ui.models.SelectionCalculator$Companion.create$default(this, facade, gateway, rootEntry, entryPath, revisions, fromLine, toLine, false, 128, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/history/integration/ui/models/SelectionCalculator$ContentIsUnavailableException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "intellij.platform.lvcs.impl"})
    private static final class ContentIsUnavailableException
    extends RuntimeException {
    }
}

