/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.geospatial.action.IpEnrichmentActionClient;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.OpenSearchFunctions;
import org.opensearch.transport.client.node.NodeClient;

public class OpenSearchEvalProcessor {
    public static ExprValue process(OpenSearchFunctions.OpenSearchExecutableFunction funcExpression, Environment<Expression, ExprValue> env, NodeClient nodeClient) {
        if (BuiltinFunctionName.GEOIP.getName().equals(funcExpression.getFunctionName())) {
            return OpenSearchEvalProcessor.fetchIpEnrichment(funcExpression.getArguments(), env, nodeClient);
        }
        throw new IllegalArgumentException("Unsupported OpenSearch specific expression.");
    }

    private static ExprValue fetchIpEnrichment(List<Expression> arguments2, Environment<Expression, ExprValue> env, NodeClient nodeClient) {
        IpEnrichmentActionClient ipClient = new IpEnrichmentActionClient(nodeClient);
        String dataSource = StringUtils.unquoteText(arguments2.get(0).toString());
        String ipAddress = arguments2.get(1).valueOf(env).stringValue();
        HashSet options = new HashSet();
        if (arguments2.size() > 2) {
            String option = StringUtils.unquoteText(arguments2.get(2).toString());
            options.addAll(Arrays.stream(option.split(",")).map(String::trim).collect(Collectors.toSet()));
        }
        try {
            Map<String, Object> geoLocationData = ipClient.getGeoLocationData(ipAddress, dataSource);
            Map<String, ExprValue> enrichmentResult = geoLocationData.entrySet().stream().filter(entry -> options.isEmpty() || options.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, v -> new ExprStringValue(v.getValue().toString())));
            return ExprTupleValue.fromExprValueMap(enrichmentResult);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

