/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.FileReader;
import java.util.ArrayList;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.Dictionary;
import org.passay.dictionary.WordList;
import org.passay.dictionary.WordLists;
import org.passay.dictionary.sort.ArraysSort;

public class WordListDictionary
implements Dictionary {
    protected final WordList wordList;

    public WordListDictionary(WordList wl) {
        this.wordList = wl;
    }

    public WordList getWordList() {
        return this.wordList;
    }

    @Override
    public long size() {
        return this.wordList == null ? 0L : (long)this.wordList.size();
    }

    @Override
    public boolean search(String word) {
        return WordLists.binarySearch(this.wordList, word) >= 0;
    }

    public String toString() {
        return String.format("%s@%h::wordList=%s", this.getClass().getName(), this.hashCode(), this.wordList);
    }

    public static void main(String[] args) throws Exception {
        block12: {
            ArrayList<FileReader> files = new ArrayList<FileReader>();
            try {
                if (args.length == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                boolean caseSensitive = true;
                boolean search = false;
                boolean print = false;
                String word = null;
                for (int i = 0; i < args.length; ++i) {
                    if ("-ci".equals(args[i])) {
                        caseSensitive = false;
                        continue;
                    }
                    if ("-s".equals(args[i])) {
                        search = true;
                        word = args[++i];
                        continue;
                    }
                    if ("-p".equals(args[i])) {
                        print = true;
                        continue;
                    }
                    if ("-h".equals(args[i])) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    files.add(new FileReader(args[i]));
                }
                ArrayWordList awl = WordLists.createFromReader(files.toArray(new FileReader[files.size()]), caseSensitive, new ArraysSort());
                WordListDictionary dict = new WordListDictionary(awl);
                if (search) {
                    if (dict.search(word)) {
                        System.out.println(String.format("%s was found in this dictionary", word));
                    } else {
                        System.out.println(String.format("%s was not found in this dictionary", word));
                    }
                    break block12;
                }
                if (print) {
                    System.out.println(dict.getWordList());
                    break block12;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Usage: java " + WordListDictionary.class.getName());
                System.out.println("            <dict1> [... <dictN>] [options] <operation>");
                System.out.println();
                System.out.println("Where <dict1>...<dictN> are files containing dictionary words.");
                System.out.println();
                System.out.println("Options:");
                System.out.println("    -ci make search case-insensitive");
                System.out.println();
                System.out.println("Operations:");
                System.out.println("    -s <word>");
                System.out.println("       search for a word");
                System.out.println("    -p print the entire dictionary");
                System.out.println("    -h print this help message");
                System.exit(1);
            }
        }
    }
}

