/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;

public class RegexRequestURLBuilder
implements Function<CriteriaSet, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegexRequestURLBuilder.class);
    @Nonnull
    private final Pattern pattern;
    @Nonnull
    private final String template;

    public RegexRequestURLBuilder(@Nonnull @NotEmpty String regex, @Nonnull @NotEmpty String replacement) {
        String regexTemp = Constraint.isNotNull(StringSupport.trimOrNull(regex), "Regex was null or empty");
        this.pattern = Pattern.compile(regexTemp);
        this.template = Constraint.isNotNull(StringSupport.trimOrNull(replacement), "Replacement template was null or empty");
    }

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        EntityIdCriterion criterion;
        EntityIdCriterion entityIdCriterion = criterion = criteria != null ? criteria.get(EntityIdCriterion.class) : null;
        if (criterion == null) {
            this.log.trace("Criteria did not contain entity ID, unable to build request URL");
            return null;
        }
        String entityID = criterion.getEntityId();
        try {
            Matcher matcher = this.pattern.matcher(entityID);
            if (matcher.matches()) {
                String result = matcher.replaceAll(this.template);
                this.log.debug("Regular expression '{}' matched successfully against entity ID '{}', returning '{}'", new Object[]{this.pattern.pattern(), entityID, result});
                return result;
            }
            this.log.debug("Regular expression '{}' did not match against entity ID '{}', returning null", (Object)this.pattern.pattern(), (Object)entityID);
            return null;
        }
        catch (Throwable t) {
            this.log.warn("Error evaluating regular expression '{}' against entity ID '{}'", new Object[]{this.pattern.pattern(), entityID, t});
            return null;
        }
    }
}

