/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.utils;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.neuralsearch.highlight.batch.config.HighlightConfig;
import org.opensearch.neuralsearch.highlight.utils.HighlightExtractorUtils;
import org.opensearch.neuralsearch.highlight.utils.HighlightValidator;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;

public class HighlightConfigBuilder {
    @Generated
    private static final Logger log = LogManager.getLogger(HighlightConfigBuilder.class);

    public static HighlightConfig buildFromSearchRequest(SearchRequest request, SearchResponse response) {
        try {
            if (request == null || request.source() == null) {
                return HighlightConfig.empty();
            }
            HighlightBuilder highlighter = request.source().highlighter();
            if (highlighter == null) {
                return HighlightConfig.empty();
            }
            String fieldName = HighlightExtractorUtils.extractSemanticField(highlighter);
            String modelId = HighlightExtractorUtils.extractModelId(highlighter);
            String queryText = HighlightExtractorUtils.extractQueryText(request);
            boolean batchInference = HighlightExtractorUtils.extractBatchInference(highlighter);
            int maxBatchSize = HighlightExtractorUtils.extractMaxBatchSize(highlighter);
            HighlightConfig config = HighlightConfig.builder().fieldName(fieldName).modelId(modelId).queryText(queryText).preTag(HighlightExtractorUtils.extractPreTag(highlighter)).postTag(HighlightExtractorUtils.extractPostTag(highlighter)).batchInference(batchInference).maxBatchSize(maxBatchSize).build();
            return HighlightValidator.validate(config, response);
        }
        catch (Exception e) {
            log.error("Failed to extract highlight configuration", (Throwable)e);
            return HighlightConfig.invalid("Configuration extraction failed: " + e.getMessage());
        }
    }
}

