/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.transform.action.get.GetTransformAction;
import org.opensearch.indexmanagement.transform.action.get.GetTransformRequest;
import org.opensearch.indexmanagement.transform.action.get.GetTransformsAction;
import org.opensearch.indexmanagement.transform.action.get.GetTransformsRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/indexmanagement/transform/resthandler/RestGetTransformAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "opensearch-index-management"})
public final class RestGetTransformAction
extends BaseRestHandler {
    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_transform"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_transform/{transformID}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_plugins/_transform/{transformID}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return "opendistro_get_transform_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String transformID = request.param("transformID");
        String searchString = request.param("search", "");
        int from = request.paramAsInt("from", 0);
        int size = request.paramAsInt("size", 20);
        String sortField = request.param("sortField", "transform.transform_id.keyword");
        String sortDirection = request.param("sortDirection", "asc");
        return arg_0 -> RestGetTransformAction.prepareRequest$lambda$0(transformID, searchString, from, size, sortField, sortDirection, client, request, arg_0);
    }

    private static final void prepareRequest$lambda$0(String $transformID, String $searchString, int $from, int $size, String $sortField, String $sortDirection, NodeClient $client, RestRequest $request, RestChannel channel) {
        if ($transformID == null || ((CharSequence)$transformID).length() == 0) {
            Intrinsics.checkNotNull((Object)$searchString);
            Intrinsics.checkNotNull((Object)$sortField);
            Intrinsics.checkNotNull((Object)$sortDirection);
            GetTransformsRequest req = new GetTransformsRequest($searchString, $from, $size, $sortField, $sortDirection);
            $client.execute((ActionType)GetTransformsAction.Companion.getINSTANCE(), (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
        } else {
            GetTransformRequest req = new GetTransformRequest($transformID, (FetchSourceContext)($request.method() == RestRequest.Method.HEAD ? FetchSourceContext.DO_NOT_FETCH_SOURCE : null), null, 4, null);
            $client.execute((ActionType)GetTransformAction.Companion.getINSTANCE(), (ActionRequest)req, (ActionListener)new RestToXContentListener(channel));
        }
    }
}

