"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@osd/config-schema");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  content: _configSchema.schema.string({
    defaultValue: 'Banner Content'
  }),
  color: _configSchema.schema.oneOf([_configSchema.schema.literal('primary'), _configSchema.schema.literal('success'), _configSchema.schema.literal('warning')], {
    defaultValue: 'primary'
  }),
  iconType: _configSchema.schema.string({
    defaultValue: 'iInCircle'
  }),
  isVisible: _configSchema.schema.boolean({
    defaultValue: true
  }),
  useMarkdown: _configSchema.schema.boolean({
    defaultValue: true
  }),
  size: _configSchema.schema.oneOf([_configSchema.schema.literal('s'), _configSchema.schema.literal('m')], {
    defaultValue: 'm'
  })
});