/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.operator.predicate;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.operator.predicate.UnaryPredicateOperators;
import org.opensearch.sql.utils.OperatorUtils;

public final class BinaryPredicateOperators {
    private static final Table<ExprValue, ExprValue, ExprValue> andTable = new ImmutableTable.Builder().put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).build();
    private static final Table<ExprValue, ExprValue, ExprValue> orTable = new ImmutableTable.Builder().put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).build();
    private static final Table<ExprValue, ExprValue, ExprValue> xorTable = new ImmutableTable.Builder().put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_TRUE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_TRUE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_FALSE).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_FALSE, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_NULL, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_NULL).put((Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING, (Object)ExprValueUtils.LITERAL_MISSING).build();

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(BinaryPredicateOperators.and());
        repository.register(BinaryPredicateOperators.or());
        repository.register(BinaryPredicateOperators.xor());
        repository.register(BinaryPredicateOperators.equal());
        repository.register(BinaryPredicateOperators.notEqual());
        repository.register(BinaryPredicateOperators.less());
        repository.register(BinaryPredicateOperators.lte());
        repository.register(BinaryPredicateOperators.greater());
        repository.register(BinaryPredicateOperators.gte());
        repository.register(BinaryPredicateOperators.like());
        repository.register(BinaryPredicateOperators.notLike());
        repository.register(BinaryPredicateOperators.regexp());
    }

    private static DefaultFunctionResolver and() {
        return FunctionDSL.define(BuiltinFunctionName.AND.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperators.lookupTableFunction(v1, v2, andTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver or() {
        return FunctionDSL.define(BuiltinFunctionName.OR.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperators.lookupTableFunction(v1, v2, orTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver xor() {
        return FunctionDSL.define(BuiltinFunctionName.XOR.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperators.lookupTableFunction(v1, v2, xorTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver equal() {
        return FunctionDSL.define(BuiltinFunctionName.EQUAL.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.equals(v2))), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver notEqual() {
        return FunctionDSL.define(BuiltinFunctionName.NOTEQUAL.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(!v1.equals(v2))), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver less() {
        return FunctionDSL.define(BuiltinFunctionName.LESS.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) < 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver lte() {
        return FunctionDSL.define(BuiltinFunctionName.LTE.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) <= 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver greater() {
        return FunctionDSL.define(BuiltinFunctionName.GREATER.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) > 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver gte() {
        return FunctionDSL.define(BuiltinFunctionName.GTE.getName(), ExprCoreType.coreTypes().stream().map(type -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) >= 0)), ExprCoreType.BOOLEAN, type, type)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver like() {
        return FunctionDSL.define(BuiltinFunctionName.LIKE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(OperatorUtils::matches2), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling(OperatorUtils::matches3), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver regexp() {
        return FunctionDSL.define(BuiltinFunctionName.REGEXP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(OperatorUtils::matchesRegexp), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver notLike() {
        return FunctionDSL.define(BuiltinFunctionName.NOT_LIKE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> UnaryPredicateOperators.not(OperatorUtils.matches2(v1, v2))), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2, v3) -> UnaryPredicateOperators.not(OperatorUtils.matches3(v1, v2, v3))), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.BOOLEAN));
    }

    private static ExprValue lookupTableFunction(ExprValue arg1, ExprValue arg2, Table<ExprValue, ExprValue, ExprValue> table) {
        if (table.contains((Object)arg1, (Object)arg2)) {
            return (ExprValue)table.get((Object)arg1, (Object)arg2);
        }
        return (ExprValue)table.get((Object)arg2, (Object)arg1);
    }

    @Generated
    private BinaryPredicateOperators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

