/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public class BigNumberConverter
extends AbstractConverter {
    private static final Log log = LogFactory.getLog(BigNumberConverter.class);

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data) throws ConversionException {
        if (data.isNull()) {
            return null;
        }
        String value = data.getValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            if (paramType == BigDecimal.class) {
                return new BigDecimal(value.trim());
            }
            if (paramType == BigInteger.class) {
                return new BigInteger(value.trim());
            }
            throw new ConversionException(paramType);
        }
        catch (NumberFormatException ex) {
            log.debug((Object)("Error converting " + value + " to a number."));
            throw new ConversionException(paramType, "Format error converting number.");
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) {
        if (data == null) {
            return new NonNestedOutboundVariable("null");
        }
        return new NonNestedOutboundVariable(data.toString());
    }
}

