/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.TimeClaimNormalizer;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.CredentialSubject;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OID4VCIssuedAtTimeClaimMapper
extends OID4VCMapper {
    public static final String MAPPER_ID = "oid4vc-issued-at-time-claim-mapper";
    public static final String TRUNCATE_TO_TIME_UNIT_KEY = "truncateToTimeUnit";
    public static final String VALUE_SOURCE = "valueSource";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    private static final Logger log = LoggerFactory.getLogger(OID4VCIssuedAtTimeClaimMapper.class);

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public boolean includeInMetadata() {
        return Optional.ofNullable((String)this.mapperModel.getConfig().get("vc.include_in_metadata")).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public void setClaim(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
        List<String> attributePath = this.getMetadataAttributePath();
        String propertyName = attributePath.get(attributePath.size() - 1);
        if (propertyName == null) {
            log.error("Invalid configuration: missing config-property '{}' for mapper '{}' of type '{}'. Mapper is ignored.", new Object[]{"claim.name", this.mapperModel.getName(), MAPPER_ID});
            return;
        }
        Instant iat = Optional.ofNullable(this.mapperModel.getConfig()).flatMap(config -> Optional.ofNullable((String)config.get(VALUE_SOURCE))).filter(valueSource -> Objects.equals(valueSource, "COMPUTE")).map(valueSource -> Instant.ofEpochSecond(Time.currentTime())).orElseGet(() -> Optional.ofNullable(verifiableCredential.getIssuanceDate()).orElse(Instant.ofEpochSecond(Time.currentTime())));
        Instant normalizedIat = new TimeClaimNormalizer(userSessionModel.getRealm()).normalize(iat);
        Instant iatTrunc = Optional.ofNullable(this.mapperModel.getConfig()).map(config -> (String)config.get(TRUNCATE_TO_TIME_UNIT_KEY)).filter(val -> !val.isEmpty()).map(ChronoUnit::valueOf).map(normalizedIat::truncatedTo).orElse(normalizedIat);
        CredentialSubject credentialSubject = verifiableCredential.getCredentialSubject();
        credentialSubject.setClaims(propertyName, iatTrunc.getEpochSecond());
    }

    @Override
    public void setClaim(Map<String, Object> claims, UserSessionModel userSessionModel) {
    }

    public String getDisplayType() {
        return "Issuance Date Claim Mapper";
    }

    public String getHelpText() {
        return "Allows to set the issuance date credential subject.";
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCIssuedAtTimeClaimMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    static {
        ProviderConfigProperty subjectPropertyNameConfig = new ProviderConfigProperty();
        subjectPropertyNameConfig.setName("claim.name");
        subjectPropertyNameConfig.setLabel("Time Claim Name");
        subjectPropertyNameConfig.setHelpText("Name of this time claim. Default is iat");
        subjectPropertyNameConfig.setType("String");
        subjectPropertyNameConfig.setDefaultValue((Object)"iat");
        CONFIG_PROPERTIES.add(subjectPropertyNameConfig);
        ProviderConfigProperty truncateToTimeUnit = new ProviderConfigProperty();
        truncateToTimeUnit.setName(TRUNCATE_TO_TIME_UNIT_KEY);
        truncateToTimeUnit.setLabel("Truncate To Time Unit");
        truncateToTimeUnit.setHelpText("Truncate time to the start of the selected unit. Supported: SECONDS, MINUTES, HOURS, HALF_DAYS, DAYS, WEEKS, MONTHS, YEARS. Such as to prevent correlation of credentials based on this time value.");
        truncateToTimeUnit.setType("List");
        truncateToTimeUnit.setOptions(List.of("SECONDS", "MINUTES", "HOURS", "HALF_DAYS", "DAYS", "WEEKS", "MONTHS", "YEARS"));
        CONFIG_PROPERTIES.add(truncateToTimeUnit);
        ProviderConfigProperty valueSource = new ProviderConfigProperty();
        valueSource.setName(VALUE_SOURCE);
        valueSource.setLabel("Source of Value");
        valueSource.setHelpText("Tells the protocol mapper where to get the information. For now: COMPUTE or VC. Default is COMPUTE, in which this protocol mapper computes the current time in seconds. With value `VC`, the time is read from the verifiable credential issuance date field.");
        valueSource.setType("List");
        valueSource.setOptions(List.of("COMPUTE", "VC"));
        valueSource.setDefaultValue((Object)"COMPUTE");
        CONFIG_PROPERTIES.add(valueSource);
    }
}

